/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.Roots;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.impl.RootsAccessor;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class SourcesImpl
implements Sources,
SourceGroupModifierImplementation,
PropertyChangeListener,
ChangeListener {
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final List<? extends Roots> roots;
    private boolean dirty;
    private final Map<String, SourceGroup[]> cachedGroups = new ConcurrentHashMap<String, SourceGroup[]>();
    private long eventId;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final SourceGroupModifierImplementation sgmi;
    private final FireAction fireTask = new FireAction();

    SourcesImpl(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, Roots ... roots) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.roots = Collections.unmodifiableList(Arrays.asList(roots));
        for (Roots roots2 : this.roots) {
            roots2.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)roots2));
        }
        SourcesHelper sh = this.initSources();
        assert (sh != null);
        this.sgmi = sh.createSourceGroupModifierImplementation();
        this.delegate = sh.createSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        SourceGroup[] _cachedGroups = this.cachedGroups.get(type);
        if (_cachedGroups != null) {
            return _cachedGroups;
        }
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                FileObject libLoc;
                long myEventId;
                Sources _delegate;
                SourcesImpl sourcesImpl = SourcesImpl.this;
                synchronized (sourcesImpl) {
                    if (SourcesImpl.this.dirty) {
                        SourcesImpl.this.delegate.removeChangeListener((ChangeListener)SourcesImpl.this);
                        SourcesImpl.this.delegate = SourcesImpl.this.initSources().createSources();
                        SourcesImpl.this.delegate.addChangeListener((ChangeListener)SourcesImpl.this);
                        SourcesImpl.this.dirty = false;
                    }
                    _delegate = SourcesImpl.this.delegate;
                    myEventId = ++SourcesImpl.this.eventId;
                }
                SourceGroup[] groups = _delegate.getSourceGroups(type);
                if (type.equals("generic") && (libLoc = SourcesImpl.this.getSharedLibraryFolderLocation()) != null) {
                    SourceGroup[] grps = new SourceGroup[groups.length + 1];
                    System.arraycopy(groups, 0, grps, 0, groups.length);
                    grps[grps.length - 1] = GenericSources.group(null, (FileObject)libLoc, (String)"sharedlibraries", (String)NbBundle.getMessage(SourcesImpl.class, (String)"LibrarySourceGroup_DisplayName"), null, null);
                    groups = grps;
                }
                SourcesImpl sourcesImpl2 = SourcesImpl.this;
                synchronized (sourcesImpl2) {
                    if (myEventId == SourcesImpl.this.eventId) {
                        SourcesImpl.this.cachedGroups.put(type, groups);
                    }
                }
                return groups;
            }
        });
    }

    public SourceGroup createSourceGroup(String type, String hint) {
        return this.sgmi.createSourceGroup(type, hint);
    }

    public boolean canCreateSourceGroup(String type, String hint) {
        return this.sgmi.canCreateSourceGroup(type, hint);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private FileObject getSharedLibraryFolderLocation() {
        String libLoc = this.helper.getLibrariesLocation();
        if (libLoc != null) {
            FileObject libLocFO;
            String libLocEval = this.evaluator.evaluate(libLoc);
            File file = null;
            if (libLocEval != null) {
                file = this.helper.resolveFile(libLocEval);
            }
            if ((libLocFO = FileUtil.toFileObject(file)) != null) {
                FileObject libLocParent = libLocFO.getParent();
                return libLocParent;
            }
        }
        return null;
    }

    private SourcesHelper initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        for (Roots roots : this.roots) {
            if (RootsAccessor.getInstance().isSourceRoot(roots)) {
                this.registerSources(sourcesHelper, roots);
                continue;
            }
            this.registerNonSources(sourcesHelper, roots);
        }
        sourcesHelper.registerExternalRoots(0, false);
        return sourcesHelper;
    }

    private void registerSources(SourcesHelper sourcesHelper, Roots roots) {
        String[] propNames = roots.getRootProperties();
        String[] displayNames = roots.getRootDisplayNames();
        for (int i = 0; i < propNames.length; ++i) {
            String hint;
            String prop = propNames[i];
            String loc = "${" + prop + "}";
            SourcesHelper.SourceRootConfig cfg = sourcesHelper.sourceRoot(loc);
            cfg.displayName(displayNames[i]);
            if (RootsAccessor.getInstance().supportIncludes(roots)) {
                String includes = "${includes}";
                String excludes = "${excludes}";
                cfg.includes("${includes}");
                cfg.excludes("${excludes}");
            }
            if ((hint = RootsAccessor.getInstance().getHint(roots)) != null) {
                cfg.hint(hint);
            }
            cfg.add();
            String type = RootsAccessor.getInstance().getType(roots);
            if (type == null) continue;
            cfg.type(type).add();
        }
    }

    private void registerNonSources(SourcesHelper sourcesHelper, Roots nonSources) {
        for (String nonSourceRootProp : nonSources.getRootProperties()) {
            sourcesHelper.addNonSourceRoot(String.format("${%s}", nonSourceRootProp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        SourcesImpl sourcesImpl = this;
        synchronized (sourcesImpl) {
            this.cachedGroups.clear();
            this.dirty = true;
        }
        ProjectManager.mutex().postReadRequest((Runnable)this.fireTask.activate());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(propName)) {
            this.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }

    private class FireAction
    implements Runnable {
        private AtomicBoolean fire = new AtomicBoolean();

        private FireAction() {
        }

        @Override
        public void run() {
            if (this.fire.getAndSet(false)) {
                SourcesImpl.this.changeSupport.fireChange();
            }
        }

        FireAction activate() {
            this.fire.set(true);
            return this;
        }
    }
}

