/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

public class ViewNode
extends BaseNode
implements SchemaNameProvider {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/view.gif";
    private static final String FOLDER = "View";
    private String name = "";
    private final MetadataElementHandle<View> viewHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ViewNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ViewNode node = new ViewNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ViewNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.viewHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        View view = (View)ViewNode.this.viewHandle.resolve(metaData);
                        ViewNode.this.name = view.getName();
                        ViewNode.this.updateProperties(view);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(View view) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
    }

    @Override
    public String getCatalogName() {
        return ViewNode.getCatalogName(this.connection, this.viewHandle);
    }

    @Override
    public String getSchemaName() {
        return ViewNode.getSchemaName(this.connection, this.viewHandle);
    }

    @Override
    public void destroy() {
        DatabaseConnector connector = this.connection.getConnector();
        Specification spec = connector.getDatabaseSpecification();
        try {
            AbstractCommand command = spec.createCommandDropView(this.getName());
            command.execute();
            this.remove();
        }
        catch (DDLException e) {
            Logger.getLogger(ViewNode.class.getName()).log(Level.INFO, e + " while deleting view " + this.getName());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector connector = this.connection.getConnector();
        return connector.supportsCommand("DropViewCommand");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable result = ExTransferable.create((Transferable)super.clipboardCopy());
        result.put(new ExTransferable.Single(DatabaseMetaDataTransfer.VIEW_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createViewData(ViewNode.this.connection.getDatabaseConnection(), ViewNode.this.connection.findJDBCDriver(), ViewNode.this.getName());
            }
        });
        return result;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ViewNode.class, (String)"ND_View");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ViewNode.class);
    }

    public static String getSchemaName(DatabaseConnection connection, final MetadataElementHandle<View> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    View view = (View)handle.resolve(metaData);
                    if (view != null) {
                        array[0] = view.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(ViewNode.class, connection, e, true);
        }
        return array[0];
    }

    public static String getCatalogName(DatabaseConnection connection, final MetadataElementHandle<View> handle) {
        MetadataModel metaDataModel = connection.getMetadataModel();
        final String[] array = new String[1];
        try {
            metaDataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metaData) {
                    View view = (View)handle.resolve(metaData);
                    if (view != null) {
                        array[0] = view.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException e) {
            NodeRegistry.handleMetadataModelException(ViewNode.class, connection, e, true);
        }
        return array[0];
    }
}

