/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Element;

public class Util {
    public static final String ENDORSED_LIBRARY_NAME = "javaee-endorsed-api-6.0";
    public static final String ENDORSED_LIBRARY_CLASSPATH = "${libs.javaee-endorsed-api-6.0.classpath}";
    public static final String DESTINATION_DIRECTORY = "destinationDirectory";
    public static final String DESTINATION_DIRECTORY_ROOT = "100";
    public static final String DESTINATION_DIRECTORY_LIB = "200";
    public static final String DESTINATION_DIRECTORY_DO_NOT_COPY = "300";
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    public static void updateDirsAttributeInCPSItem(ClassPathSupport.Item item, Element element) {
        String dirs = item.getAdditionalProperty(DESTINATION_DIRECTORY);
        if (dirs == null) {
            dirs = DESTINATION_DIRECTORY_LIB;
            if (item.getType() == 2 && !item.isBroken() && item.getArtifact() != null && item.getArtifact().getProject() != null && item.getArtifact().getProject().getLookup().lookup(J2eeModuleProvider.class) != null) {
                dirs = DESTINATION_DIRECTORY_ROOT;
            }
        }
        element.setAttribute("dirs", dirs);
    }

    public static void changeLabelInComponent(JComponent component, String oldLabel, String newLabel) {
        JLabel label = Util.findLabel(component, oldLabel);
        if (label != null) {
            label.setText(newLabel);
        }
    }

    public static void hideLabelAndLabelFor(JComponent component, String lab) {
        JLabel label = Util.findLabel(component, lab);
        if (label != null) {
            label.setVisible(false);
            Component c = label.getLabelFor();
            if (c != null) {
                c.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] components, Collection<Component> allComponents) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            allComponents.add(components[i]);
            if (((Container)components[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)components[i]).getComponents(), allComponents);
        }
    }

    public static JLabel findLabel(JComponent comp, String labelText) {
        ArrayList<Component> allComponents = new ArrayList<Component>();
        Util.getAllComponents(comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JLabel label;
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(labelText)) continue;
            return label;
        }
        return null;
    }

    public static ClassPath getFullClasspath(FileObject fo) {
        if (fo == null) {
            return null;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)fo, (String)"classpath/source"), ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot"), ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")});
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            double version = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.Type.EJB.equals(type) && version > 2.1) {
                return true;
            }
            if (J2eeModule.Type.WAR.equals(type) && version > 2.4) {
                return true;
            }
            if (J2eeModule.Type.CAR.equals(type) && version > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static String getSourceLevel(Project project) {
        String srcLevel = null;
        SourceLevelQueryImplementation2 sl2 = (SourceLevelQueryImplementation2)project.getLookup().lookup(SourceLevelQueryImplementation2.class);
        if (sl2 != null) {
            srcLevel = sl2.getSourceLevel(project.getProjectDirectory()).getSourceLevel();
        } else {
            SourceLevelQueryImplementation sl = (SourceLevelQueryImplementation)project.getLookup().lookup(SourceLevelQueryImplementation.class);
            if (sl != null) {
                srcLevel = sl.getSourceLevel(project.getProjectDirectory());
            }
        }
        return srcLevel;
    }

    public static boolean isSourceLevel14orLower(Project project) {
        String srcLevel = Util.getSourceLevel(project);
        if (srcLevel != null) {
            double sourceLevel = Double.parseDouble(srcLevel);
            return sourceLevel <= 1.4;
        }
        return false;
    }

    public static boolean isSourceLevel16orHigher(Project project) {
        String srcLevel = Util.getSourceLevel(project);
        if (srcLevel != null) {
            double sourceLevel = Double.parseDouble(srcLevel);
            return sourceLevel >= 1.6;
        }
        return false;
    }

    public static boolean isValidServerInstance(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return false;
        }
        return Util.isValidServerInstance(j2eeModuleProvider);
    }

    public static boolean isValidServerInstance(J2eeModuleProvider j2eeModuleProvider) {
        String serverInstanceID = j2eeModuleProvider.getServerInstanceID();
        if (serverInstanceID == null) {
            return false;
        }
        return Deployment.getDefault().getServerID(serverInstanceID) != null;
    }

    public static ServerStatusProvider createServerStatusProvider(final J2eeModuleProvider j2eeModuleProvider) {
        return new ServerStatusProvider(){

            public boolean validServerInstancePresent() {
                return Util.isValidServerInstance(j2eeModuleProvider);
            }
        };
    }

    @NonNull
    public static File[] getJ2eePlatformClasspathEntries(@NullAllowed Project project, @NullAllowed J2eePlatform j2eePlatform) {
        J2eeModuleProvider j2eeModuleProvider;
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            J2eePlatform j2eePlatformLocal;
            J2eePlatform j2eePlatform2 = j2eePlatformLocal = j2eePlatform != null ? j2eePlatform : Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
            if (j2eePlatformLocal != null) {
                try {
                    return j2eePlatformLocal.getClasspathEntries(j2eeModuleProvider.getConfigSupport().getLibraries());
                }
                catch (ConfigurationException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                    return j2eePlatformLocal.getClasspathEntries();
                }
            }
        }
        if (j2eePlatform != null) {
            return j2eePlatform.getClasspathEntries();
        }
        return new File[0];
    }

    public static boolean containsClass(List<URL> classPath, String className) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classPath);
        Parameters.notNull((CharSequence)"className", (Object)className);
        ArrayList<File> diskFiles = new ArrayList<File>();
        for (URL url : classPath) {
            File diskFile;
            URL localURL;
            FileObject fo;
            URL archiveURL = FileUtil.getArchiveFile((URL)url);
            if (archiveURL != null) {
                url = archiveURL;
            }
            if ("nbinst".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && (localURL = URLMapper.findURL((FileObject)fo, (int)1)) != null) {
                url = localURL;
            }
            if ((fo = URLMapper.findFileObject((URL)url)) == null || (diskFile = FileUtil.toFile((FileObject)fo)) == null) continue;
            diskFiles.add(diskFile);
        }
        return Util.containsClass(diskFiles, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsClass(Collection<File> classpath, String className) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classpath);
        Parameters.notNull((CharSequence)"driverClassName", (Object)className);
        String classFilePath = className.replace('.', '/') + ".class";
        for (File file : classpath) {
            if (file.isFile()) {
                JarFile jf = new JarFile(file);
                try {
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!classFilePath.equals(entry.getName())) continue;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
                finally {
                    jf.close();
                    continue;
                }
            }
            if (!new File(file, classFilePath).exists()) continue;
            return true;
        }
        return false;
    }

    public static String getJ2eeSpecificationLabel(String specificationVersion) {
        Parameters.notNull((CharSequence)"specificationVersion", (Object)specificationVersion);
        if ("1.3".equals(specificationVersion)) {
            return NbBundle.getMessage(Util.class, (String)"LBL_J2EESpec_13");
        }
        if ("1.4".equals(specificationVersion)) {
            return NbBundle.getMessage(Util.class, (String)"LBL_J2EESpec_14");
        }
        if ("1.5".equals(specificationVersion)) {
            return NbBundle.getMessage(Util.class, (String)"LBL_JavaEESpec_5");
        }
        throw new IllegalArgumentException("Unknown specification version: " + specificationVersion);
    }

    public static Set<Profile> getSupportedProfiles(Project project) {
        Set<Object> supportedProfiles = new HashSet<Profile>();
        J2eePlatform j2eePlatform = Util.getPlatform(project);
        if (j2eePlatform != null) {
            supportedProfiles = j2eePlatform.getSupportedProfiles();
        }
        return supportedProfiles;
    }

    private static J2eePlatform getPlatform(Project project) {
        try {
            String instance;
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (provider != null && (instance = provider.getServerInstanceID()) != null) {
                return Deployment.getDefault().getServerInstance(provider.getServerInstanceID()).getJ2eePlatform();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupBuildImplFile(UpdateHelper updateHelper) throws IOException {
        FileObject projectDir = updateHelper.getAntProjectHelper().getProjectDirectory();
        FileObject buildImpl = projectDir.getFileObject("nbproject/build-impl.xml");
        if (buildImpl != null) {
            String name = buildImpl.getName();
            String backupext = String.format("%s~", buildImpl.getExt());
            FileObject oldBackup = buildImpl.getParent().getFileObject(name, backupext);
            if (oldBackup != null) {
                oldBackup.delete();
            }
            FileLock lock = buildImpl.lock();
            try {
                buildImpl.rename(lock, name, backupext);
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    public static void initTwoColumnTableVisualProperties(Component component, JTable table) {
        table.setSelectionMode(2);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        Util.updateColumnWidths(table);
        component.addComponentListener(new TableColumnSizeComponentAdapter(table));
    }

    private static void updateColumnWidths(JTable table) {
        double pw = table.getParent().getSize().getWidth();
        table.setAutoResizeMode(0);
        TableColumn column = table.getColumnModel().getColumn(1);
        int w = (int)pw / 2 - 1;
        if (w > column.getMaxWidth()) {
            w = column.getMaxWidth();
        }
        column.setWidth(w);
        column.setPreferredWidth(w);
        w = (int)pw - w;
        column = table.getColumnModel().getColumn(0);
        column.setWidth(w);
        column.setPreferredWidth(w);
    }

    private static class TableColumnSizeComponentAdapter
    extends ComponentAdapter {
        private JTable table = null;

        public TableColumnSizeComponentAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            Util.updateColumnWidths(this.table);
        }
    }
}

