/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

final class PersistentList<E>
extends Vector<E>
implements Serializable {
    private static final long serialVersionUID = -8893123456464434693L;
    private final transient Object lock = new Object();

    public PersistentList() {
    }

    public PersistentList(List<E> values) {
        super(values);
    }

    private static String getRoot() {
        String dir = System.getProperty("netbeans.user") + "/config/cnd-compilers/";
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnique(E string) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.inList(string)) {
                super.add(string);
            }
        }
    }

    private boolean inList(E path) {
        if (path == null) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!path.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void saveList(ObjectOutputStream out) {
        try {
            out.writeObject(this);
        }
        catch (IOException ioe) {
            System.out.println("PersistentList - saveList - ioe " + ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveList(String name) {
        Object object = this.lock;
        synchronized (object) {
            File dirfile = new File(PersistentList.getRoot());
            if (!dirfile.exists()) {
                dirfile.mkdirs();
            }
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(PersistentList.getRoot() + name));
                this.saveList(oos);
                oos.flush();
                oos.close();
            }
            catch (Exception e) {
                System.out.println("e " + e);
            }
        }
    }

    private static PersistentList<String> restoreList(ObjectInputStream in) throws Exception {
        PersistentList list = null;
        try {
            list = (PersistentList)in.readObject();
        }
        catch (Exception e) {
            System.err.println("PersistentList - restorePicklist - e " + e);
            throw e;
        }
        return new PersistentList<String>(list);
    }

    public static PersistentList<String> restoreList(String name) {
        PersistentList<String> ret = null;
        File file = new File(PersistentList.getRoot() + File.separator + name);
        if (file.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(PersistentList.getRoot() + name));
                ret = PersistentList.restoreList(ois);
                ois.close();
            }
            catch (Exception e) {
                System.err.println("PersistentList - restoreList - e" + e);
                System.err.println(PersistentList.getRoot() + name + " deleted");
                file.delete();
            }
        }
        return ret;
    }
}

