/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.awt.Container;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SourceSupportProviderImpl
implements SourceSupportProvider {
    private static String loc(String key, String ... arg) {
        return NbBundle.getMessage(SourceSupportProviderImpl.class, (String)key, (Object[])arg);
    }

    public void showSource(SourceFileInfoProvider.SourceFileInfo lineInfo, boolean isReadOnly) {
        FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)lineInfo.getFileName()));
        try {
            new ROEditor(fo).open();
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void showSource(final SourceFileInfoProvider.SourceFileInfo lineInfo) {
        if (lineInfo == null) {
            StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.NoInfo", new String[0]));
            return;
        }
        if (!lineInfo.isSourceKnown()) {
            StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.UnknownSource", new String[0]));
            return;
        }
        String fileName = lineInfo.getFileName();
        try {
            FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)fileName));
            if (fo == null || !fo.isValid()) {
                InputStream inputStream = null;
                try {
                    URI uri = new URI(lineInfo.getFileName());
                    if (uri.getScheme() != null && uri.getScheme().equals("file")) {
                        fo = CndFileUtils.toFileObject((File)FileUtil.normalizeFile((File)new File(uri)));
                    }
                    if (fo == null || !fo.isValid()) {
                        String rowPath = uri.getRawPath();
                        int lastIndexOfSeparator = rowPath.lastIndexOf(47);
                        if (lastIndexOfSeparator == -1) {
                            return;
                        }
                        String file = rowPath.substring(lastIndexOfSeparator, rowPath.length());
                        inputStream = uri.toURL().openStream();
                        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
                        String line = null;
                        StringBuilder buffer = new StringBuilder();
                        while ((line = in.readLine()) != null) {
                            buffer.append(line + "\n");
                        }
                        in.close();
                        inputStream.close();
                        fileName = System.getProperty("java.io.tmpdir") + File.separator + file;
                        File tempFile = new File(fileName);
                        tempFile.deleteOnExit();
                        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
                        writer.write(buffer.toString());
                        writer.flush();
                        writer.close();
                        fo = CndFileUtils.toFileObject((File)CndFileUtils.normalizeFile((File)tempFile));
                    }
                }
                catch (Throwable e) {
                    Throwable t = ErrorManager.getDefault().annotate(e, SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", fileName));
                    ErrorManager.getDefault().notify(16, t);
                    StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", fileName));
                }
            }
            if (fo == null || !fo.isValid()) {
                StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", fileName));
                return;
            }
            DataObject dob = DataObject.find((FileObject)fo);
            SourceSupportProvider.FileObjectsToSourceMap.getInstance().put(fo, lineInfo.getFileName());
            final EditorCookie.Observable ec = (EditorCookie.Observable)dob.getCookie(EditorCookie.Observable.class);
            if (ec != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JumpList.checkAddEntry();
                        JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
                        boolean opened = true;
                        if (pane == null) {
                            ec.open();
                            opened = false;
                            JEditorPane[] panes = ec.getOpenedPanes();
                            JEditorPane jEditorPane = pane = panes != null && panes.length > 0 ? panes[0] : null;
                        }
                        if (pane != null) {
                            SourceSupportProviderImpl.jumpToLine(pane, lineInfo, !opened);
                        }
                    }
                });
            }
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace(System.err);
            StatusDisplayer.getDefault().setStatusText(SourceSupportProviderImpl.loc("SourceSupportProviderImpl.CannotOpenFile", fileName));
        }
    }

    private static void jumpToLine(JEditorPane pane, SourceFileInfoProvider.SourceFileInfo sourceFileInfo, boolean delayProcessing) {
        Container temp;
        for (temp = pane; temp != null && !(temp instanceof TopComponent); temp = temp.getParent()) {
        }
        if (temp instanceof TopComponent) {
            ((TopComponent)temp).open();
            ((TopComponent)temp).requestActive();
            ((TopComponent)temp).requestVisible();
        }
        SourceSupportProviderImpl.jumpToLine(pane, sourceFileInfo);
    }

    private static void jumpToLine(JEditorPane pane, SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
        assert (SwingUtilities.isEventDispatchThread()) : "must be called in EDT";
        long start = sourceFileInfo.hasOffset() ? sourceFileInfo.getOffset() : (long)Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)pane.getDocument()), (int)(sourceFileInfo.getLine() - 1));
        if (pane.getDocument() != null && start >= 0L && start < (long)pane.getDocument().getLength()) {
            pane.setCaretPosition((int)start);
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    private static final class E
    extends DataEditorSupport.Env {
        public E(DataObject d) {
            super(d);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            throw new IOException("No way!");
        }
    }

    private static final class ROEditor
    extends DataEditorSupport {
        private ROEditor(DataObject d) {
            super(d, (CloneableEditorSupport.Env)new E(d));
        }

        public ROEditor(FileObject fo) throws DataObjectNotFoundException {
            this(DataObject.find((FileObject)fo));
        }
    }
}

