/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.selector.java.nodes.JavaClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.PackageNode;
import org.openide.filesystems.FileObject;

public class JavaPackageNode
extends PackageNode {
    private ClasspathInfo cpInfo;
    private Set<ClassIndex.SearchScope> scope;
    private ClientUtils.SourceCodeSelection signature;

    public JavaPackageNode(ClasspathInfo cpInfo, String name, ContainerNode parent, Set<ClassIndex.SearchScope> scope) {
        super(name, parent);
        this.cpInfo = cpInfo;
        this.scope = scope;
        this.signature = new ClientUtils.SourceCodeSelection(name + ".**", null, null);
    }

    protected List<ClassNode> getContainedClasses() {
        final ArrayList<ClassNode> nodes = new ArrayList<ClassNode>();
        JavaSource source = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.PARSED);
                    PackageElement pelem = controller.getElements().getPackageElement(JavaPackageNode.this.getNodeName());
                    if (pelem != null) {
                        for (TypeElement type : ElementFilter.typesIn(pelem.getEnclosedElements())) {
                            if (type.getKind() != ElementKind.CLASS && type.getKind() != ElementKind.ENUM) continue;
                            nodes.add(new JavaClassNode(JavaPackageNode.this.cpInfo, false, type, (ContainerNode)JavaPackageNode.this));
                        }
                    } else {
                        LOGGER.log(Level.FINEST, "Package name {0} resulted into a NULL element", JavaPackageNode.this.getNodeName());
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            LOGGER.severe(ex.getLocalizedMessage());
        }
        return nodes;
    }

    protected List<PackageNode> getContainedPackages() {
        ClassIndex index = this.cpInfo.getClassIndex();
        ArrayList<PackageNode> nodes = new ArrayList<PackageNode>();
        for (String pkgName : index.getPackageNames(this.getNodeName() + ".", true, this.scope)) {
            nodes.add(new JavaPackageNode(this.cpInfo, pkgName, (ContainerNode)this, this.scope));
        }
        return nodes;
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }
}

