/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.RenameSceneDialog;
import org.netbeans.modules.vmd.game.editor.scene.SceneEditor;
import org.netbeans.modules.vmd.game.editor.scene.SceneLayerNavigator;
import org.netbeans.modules.vmd.game.editor.scene.ScenePreviewPanel;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.SceneSelectionListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class Scene
implements GlobalRepositoryListener,
PropertyChangeListener,
Previewable,
Editable,
Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    public static final String PROPERTY_LAYERS_BOUNDS = "prop.layers.bounds";
    EventListenerList listenerList = new EventListenerList();
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ArrayList<Layer> layers = new ArrayList();
    private HashMap<Layer, LayerInfo> layerInfos = new HashMap();
    private String name;
    private SceneLayerNavigator navigator;
    private ScenePreviewPanel preview;
    private Rectangle allLayersBounds = new Rectangle();
    private SceneEditor editor;
    private GlobalRepository gameDesign;

    Scene(GlobalRepository gameDesign, String name) {
        assert (gameDesign != null);
        this.gameDesign = gameDesign;
        this.editor = null;
        this.name = name;
        this.gameDesign.addGlobalRepositoryListener(this);
    }

    Scene(GlobalRepository gameDesign, String name, Scene other) {
        this(gameDesign, name);
        for (Layer layer : other.layers) {
            this.insert(layer, other.indexOf(layer));
            this.setLayerPosition(layer, other.getLayerPosition(layer), false);
            this.setLayerLocked(layer, other.isLayerLocked(layer));
            this.setLayerVisible(layer, other.isLayerVisible(layer));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (!this.gameDesign.isComponentNameAvailable(name)) {
            throw new IllegalArgumentException("Scene cannot be renamed because component name '" + name + "' already exists.");
        }
        String oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("editable.prop.name", oldName, this.name);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public synchronized void addSceneListener(SceneListener l) {
        this.listenerList.add(SceneListener.class, l);
    }

    public synchronized void removeSceneListener(SceneListener l) {
        this.listenerList.remove(SceneListener.class, l);
    }

    public synchronized void addSceneListener(SceneSelectionListener l) {
        this.listenerList.add(SceneSelectionListener.class, l);
    }

    public synchronized void removeSceneListener(SceneSelectionListener l) {
        this.listenerList.remove(SceneSelectionListener.class, l);
    }

    public Rectangle getAllLayersBounds() {
        return this.allLayersBounds;
    }

    private void updateLayersBounds() {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Layer layer : this.getLayers()) {
            Point point = this.getLayerPosition(layer);
            xMin = xMin < point.x ? xMin : point.x;
            yMin = yMin < point.y ? yMin : point.y;
            int right = point.x + layer.getWidth();
            xMax = xMax > right ? xMax : right;
            int bottom = point.y + layer.getHeight();
            yMax = yMax > bottom ? yMax : bottom;
        }
        Rectangle newBounds = new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
        if (!this.allLayersBounds.equals(newBounds)) {
            Rectangle oldBounds = this.allLayersBounds;
            this.allLayersBounds = newBounds;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_LAYERS_BOUNDS, oldBounds, newBounds);
        }
    }

    public TiledLayer createTiledLayer(String name, ImageResource imageResource, int rows, int columns, int tileWidth, int tileHeight) {
        TiledLayer layer = this.gameDesign.createTiledLayer(name, imageResource, rows, columns, tileWidth, tileHeight);
        this.append(layer);
        return layer;
    }

    public Sprite createSprite(String name, ImageResource imageResource, int numberFrames, int frameWidth, int frameHeight) {
        Sprite sprite = this.gameDesign.createSprite(name, imageResource, numberFrames, frameWidth, frameHeight);
        this.append(sprite);
        return sprite;
    }

    private LayerInfo getLayerInfo(Layer l) {
        return this.layerInfos.get(l);
    }

    public boolean contains(Layer layer) {
        return this.indexOf(layer) >= 0;
    }

    public void append(Layer layer) {
        if (this.layers.contains(layer)) {
            this.remove(layer);
        }
        this.layers.add(layer);
        LayerInfo info = new LayerInfo();
        this.layerInfos.put(layer, info);
        int index = this.layers.indexOf(layer);
        layer.addPropertyChangeListener(this);
        this.updateLayersBounds();
        this.fireLayerAdded(layer, index);
    }

    public void insert(Layer layer, int index) {
        if (this.layers.contains(layer)) {
            this.move(layer, index);
            return;
        }
        this.layers.add(index, layer);
        LayerInfo info = new LayerInfo();
        this.layerInfos.put(layer, info);
        layer.addPropertyChangeListener(this);
        this.updateLayersBounds();
        this.fireLayerAdded(layer, index);
    }

    public void remove(Layer layer) {
        int index = this.layers.indexOf(layer);
        if (this.layers.remove(layer)) {
            layer.removePropertyChangeListener(this);
            this.updateLayersBounds();
            this.fireLayerRemoved(layer, index);
        }
    }

    public void move(Layer layer, int newIndex) {
        int oldIndex = this.layers.indexOf(layer);
        if (oldIndex == -1) {
            return;
        }
        if (oldIndex == newIndex) {
            return;
        }
        this.layers.remove(layer);
        this.layers.ensureCapacity(newIndex + 1);
        this.layers.add(newIndex, layer);
        this.updateLayersBounds();
        this.fireLayerMoved(layer, oldIndex, newIndex);
    }

    private void fireLayerMoved(Layer layer, int oldIndex, int newIndex) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneListener.class) continue;
            ((SceneListener)listeners[i + 1]).layerMoved(this, layer, oldIndex, newIndex);
        }
    }

    private void fireLayerAdded(Layer layer, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneListener.class) continue;
            ((SceneListener)listeners[i + 1]).layerAdded(this, layer, index);
        }
    }

    private void fireLayerRemoved(Layer layer, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneListener.class) continue;
            ((SceneListener)listeners[i + 1]).layerRemoved(this, layer, this.getLayerInfo(layer), index);
        }
    }

    private void fireLayerPositionModified(Layer layer, int index, Point oldPosition, Point newPosition, boolean inTransition) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneListener.class) continue;
            ((SceneListener)listeners[i + 1]).layerPositionChanged(this, layer, oldPosition, newPosition, inTransition);
        }
    }

    private void fireLayerLockModified(Layer layer, int index, boolean locked) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneListener.class) continue;
            ((SceneListener)listeners[i + 1]).layerLockChanged(this, layer, locked);
        }
    }

    private void fireLayerSelectionModified(Layer layer, int index, boolean selected) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneSelectionListener.class) continue;
            ((SceneSelectionListener)listeners[i + 1]).layerSelectionChanged(this, layer, selected);
        }
    }

    private void fireLayerVisibilityModified(Layer layer, int index, boolean visible) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SceneListener.class) continue;
            ((SceneListener)listeners[i + 1]).layerVisibilityChanged(this, layer, visible);
        }
    }

    public int indexOf(Layer layer) {
        return this.layers.indexOf(layer);
    }

    public Layer getLayerAt(int index) {
        return this.layers.get(index);
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<Layer> getLayersAtPoint(Point p) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer l : this.layers) {
            LayerInfo li = this.getLayerInfo(l);
            Point lp = li.getPosition();
            if (lp.equals(p)) {
                layers.add(l);
                continue;
            }
            if (lp.x > p.x || lp.y > p.y || !this.getLayerBounds(l).contains(p)) continue;
            layers.add(l);
        }
        Collections.sort(layers, new LayerIndexComparator());
        return layers;
    }

    public Rectangle getLayerBounds(Layer layer) {
        Point p = this.getLayerPosition(layer);
        return new Rectangle(p.x, p.y, layer.getWidth(), layer.getHeight());
    }

    public Point getLayerPosition(Layer layer) {
        Point position = this.getLayerInfo(layer).getPosition();
        return position;
    }

    public void setLayerPositionX(Layer layer, int x, boolean inTransition) {
        Point p = this.getLayerPosition(layer);
        p.x = x;
        this.setLayerPosition(layer, p, inTransition);
    }

    public void setLayerPositionY(Layer layer, int y, boolean inTransition) {
        Point p = this.getLayerPosition(layer);
        p.y = y;
        this.setLayerPosition(layer, p, inTransition);
    }

    public void setLayerPosition(Layer layer, int x, int y, boolean inTransition) {
        Point p = this.getLayerPosition(layer);
        p.x = x;
        p.y = y;
        this.setLayerPosition(layer, p, inTransition);
    }

    public void setLayerPosition(Layer layer, Point position, boolean inTransition) {
        if (this.isLayerLocked(layer)) {
            throw new IllegalArgumentException("Layer: " + layer + " is locked");
        }
        LayerInfo info = this.getLayerInfo(layer);
        Point old = info.getPosition();
        info.setPosition(position);
        this.updateLayersBounds();
        this.fireLayerPositionModified(layer, this.layers.indexOf(layer), old, info.getPosition(), inTransition);
    }

    public boolean isLayerVisible(Layer layer) {
        return this.getLayerInfo(layer).isVisible();
    }

    public void setLayerVisible(Layer layer, boolean visible) {
        boolean old = this.getLayerInfo(layer).isVisible();
        if (old == visible) {
            return;
        }
        this.getLayerInfo(layer).setVisible(visible);
        this.fireLayerVisibilityModified(layer, this.layers.indexOf(layer), visible);
    }

    public boolean isLayerLocked(Layer layer) {
        return this.getLayerInfo(layer).isLocked();
    }

    public void setLayerLocked(Layer layer, boolean locked) {
        boolean old = this.getLayerInfo(layer).isLocked();
        if (old == locked) {
            return;
        }
        this.getLayerInfo(layer).setLocked(locked);
        this.fireLayerLockModified(layer, this.layers.indexOf(layer), locked);
    }

    public boolean isLayerSelected(Layer layer) {
        return this.getLayerInfo(layer).isSelected();
    }

    public void setLayerSelected(Layer layer, boolean selected) {
        boolean old = this.getLayerInfo(layer).isSelected();
        if (old == selected) {
            return;
        }
        this.getLayerInfo(layer).setSelected(selected);
        this.fireLayerSelectionModified(layer, this.layers.indexOf(layer), selected);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public JComponent getEditor() {
        if (null == this.editor) {
            this.editor = new SceneEditor(this);
        }
        return this.editor.getJComponent();
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return null;
    }

    public GlobalRepository getGameDesign() {
        return this.gameDesign;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new EditSceneAction());
        actions.add(new RemoveSceneAction());
        actions.add(new RenameSceneAction());
        return Collections.unmodifiableList(actions);
    }

    @Override
    public void sceneAdded(Scene scene, int index) {
    }

    @Override
    public void sceneRemoved(Scene scene, int index) {
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int index) {
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int index) {
        this.remove(tiledLayer);
    }

    @Override
    public void spriteAdded(Sprite sprite, int index) {
    }

    @Override
    public void spriteRemoved(Sprite sprite, int index) {
        this.remove(sprite);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }

    @Override
    public JComponent getPreview() {
        if (this.preview == null) {
            this.preview = new ScenePreviewPanel(this);
            return this.preview;
        }
        return this.preview;
    }

    @Override
    public JComponent getNavigator() {
        if (this.navigator == null) {
            this.navigator = new SceneLayerNavigator(this);
            return this.navigator;
        }
        return this.navigator;
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public class RemoveSceneAction
    extends AbstractAction {
        public RemoveSceneAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.RemoveSceneAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object response = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(Scene.class, (String)"Scene.RemoveDialog.text", (Object)Scene.this.getName()), NbBundle.getMessage(Scene.class, (String)"Scene.RemoveSceneAction.text"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION));
            if (response == NotifyDescriptor.YES_OPTION) {
                Scene.this.gameDesign.removeScene(Scene.this);
            }
        }
    }

    public class CreateTiledLayerAction
    extends AbstractAction {
        public CreateTiledLayerAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.CreateTiledLayerAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TiledLayerDialog nld = new TiledLayerDialog(Scene.this);
            DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(Scene.class, (String)"Scene.CreateTiledLayerAction.text"));
            dd.setButtonListener((ActionListener)nld);
            dd.setValid(false);
            nld.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class CreateSpriteAction
    extends AbstractAction {
        public CreateSpriteAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.CreateSpriteAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpriteDialog nld = new SpriteDialog(Scene.this);
            DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(Scene.class, (String)"Scene.CreateSpriteAction.text"));
            dd.setButtonListener((ActionListener)nld);
            dd.setValid(false);
            nld.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class EditSceneAction
    extends AbstractAction {
        public EditSceneAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.EditSceneAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Scene.this.gameDesign.getMainView().requestEditing(Scene.this);
        }
    }

    public class RenameSceneAction
    extends AbstractAction {
        public RenameSceneAction() {
            this.putValue("Name", NbBundle.getMessage(Scene.class, (String)"Scene.RenameSceneAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameSceneDialog dialog = new RenameSceneDialog(Scene.this);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(Scene.class, (String)"Scene.RenameSceneAction.text"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    static class NameComparator
    implements Comparator {
        NameComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (!(arg0 instanceof Scene) || !(arg1 instanceof Scene)) {
                throw new ClassCastException("Compared object not instance of Scene");
            }
            Scene s0 = (Scene)arg0;
            Scene s1 = (Scene)arg1;
            return s0.getName().compareTo(s1.getName());
        }
    }

    public static class LayerInfo {
        private Point position = new Point();
        private boolean visible = true;
        private boolean locked;
        private boolean selected;

        public String toString() {
            return "Position: " + this.position + ", visible: " + this.visible + ", locked: " + this.locked;
        }

        public Point getPosition() {
            return new Point(this.position);
        }

        public void setPosition(Point position) {
            this.position = position;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    private class LayerIndexComparator
    implements Comparator<Layer> {
        private LayerIndexComparator() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            return Scene.this.layers.indexOf(l1) - Scene.this.layers.indexOf(l2);
        }
    }
}

