/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.game.editor.tiledlayer.AnimatedTileListCellRenderer;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditorComponent;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileTransferable;

public class AnimatedTileList
extends JList {
    public static final boolean DEBUG = false;
    private TiledLayerEditorComponent editorComponent;
    private ImageResource imageResource;
    private AnimatedTileListDataModel model;

    public AnimatedTileList(TiledLayerEditorComponent editorComponent) {
        this.editorComponent = editorComponent;
        this.imageResource = this.editorComponent.getTiledLayer().getImageResource();
        this.model = new AnimatedTileListDataModel();
        this.init();
        this.imageResource.addImageResourceListener(this.model);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setCellRenderer(new AnimatedTileListCellRenderer());
        this.setMinimumSize(new Dimension(this.editorComponent.getTiledLayer().getTileWidth(), 20));
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AnimatedTileList.this.updatePaintTile();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AnimatedTileList.this.updatePaintTile();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AnimatedTileList.this.handlePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AnimatedTileList.this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                AnimatedTile tile;
                if (e.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(e) && (tile = (AnimatedTile)AnimatedTileList.this.getSelectedValue()) != null) {
                    tile.getImageResource().getGameDesign().getMainView().requestEditing(tile);
                }
            }
        });
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, new DGL());
    }

    private void handlePopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        int row = this.locationToIndex(e.getPoint());
        if (row == -1) {
            return;
        }
        this.setSelectedIndex(row);
        AnimatedTile at = (AnimatedTile)this.getModel().getElementAt(row);
        List<Action> actions = at.getActions();
        for (Action action : actions) {
            menu.add(action);
        }
        menu.show(this, e.getX(), e.getY());
    }

    private void updatePaintTile() {
        Tile tile = (Tile)this.getSelectedValue();
        if (tile == null) {
            return;
        }
        tile.getImageResource().getGameDesign().getMainView().requestPreview(tile);
        this.editorComponent.setPaintTileIndex(tile.getIndex());
    }

    private void init() {
        List<AnimatedTile> animatedTiles = this.imageResource.getAnimatedTiles(this.editorComponent.getTiledLayer().getTileWidth(), this.editorComponent.getTiledLayer().getTileHeight());
        for (AnimatedTile tile : animatedTiles) {
            tile.addSequenceContainerListener(this.model);
            this.model.addElement(tile);
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private class AnimatedTileListDataModel
    extends DefaultListModel
    implements ImageResourceListener,
    SequenceContainerListener,
    PropertyChangeListener {
        private AnimatedTileListDataModel() {
        }

        public void addElement(Object obj) {
            AnimatedTile tile = (AnimatedTile)obj;
            super.addElement(tile);
            tile.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int index = this.indexOf(evt.getSource());
            if (evt.getPropertyName().equals("editable.prop.name")) {
                this.fireContentsChanged(this, index, index);
            }
        }

        @Override
        public void animatedTileAdded(ImageResource source, AnimatedTile tile) {
            if (tile.getWidth() == AnimatedTileList.this.editorComponent.getTiledLayer().getTileWidth() && tile.getHeight() == AnimatedTileList.this.editorComponent.getTiledLayer().getTileHeight()) {
                this.addElement(tile);
                tile.addSequenceContainerListener(this);
            }
        }

        @Override
        public void animatedTileRemoved(ImageResource source, AnimatedTile tile) {
            tile.removeSequenceContainerListener(this);
            this.removeElement(tile);
        }

        @Override
        public void sequenceAdded(ImageResource source, Sequence sequence) {
        }

        @Override
        public void sequenceRemoved(ImageResource source, Sequence sequence) {
        }

        @Override
        public void sequenceAdded(SequenceContainer source, Sequence sequence, int index) {
            int tileIndex = this.indexOf(source);
            this.fireContentsChanged(this, tileIndex, tileIndex);
        }

        @Override
        public void sequenceRemoved(SequenceContainer source, Sequence sequence, int index) {
            int tileIndex = this.indexOf(source);
            this.fireContentsChanged(this, tileIndex, tileIndex);
        }

        @Override
        public void sequenceMoved(SequenceContainer source, Sequence sequence, int indexOld, int indexNew) {
            int tileIndex = this.indexOf(source);
            this.fireContentsChanged(this, tileIndex, tileIndex);
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Point dragOrigin = dge.getDragOrigin();
            int row = AnimatedTileList.this.locationToIndex(dragOrigin);
            if (row == -1) {
                return;
            }
            Tile tile = (Tile)AnimatedTileList.this.getModel().getElementAt(row);
            TileTransferable payload = new TileTransferable();
            payload.getTiles().add(tile);
            dge.startDrag(null, payload, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            super.dragDropEnd(dsde);
            if (dsde.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

