/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.sequece;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanel;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanelListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.preview.SequencePreviewPanel;
import org.openide.util.NbBundle;

public class SequenceContainerEditor
extends JPanel
implements SequenceEditingPanelListener,
SequenceContainerListener,
PropertyChangeListener {
    private SequenceContainer sequenceContainer;
    private Map<Sequence, JComponent> previewMap = new HashMap<Sequence, JComponent>();
    private JPanel previewsPanel;
    private JScrollPane scrollPreviews;
    private JPanel editorsPanel;
    private JScrollPane scrollEditors;
    private int syncComponentHeight = 0;
    private int maxFrameCount = 0;
    private int filmUnitWidth = 0;

    public SequenceContainerEditor(SequenceContainer sequenceContainer) {
        this.setBackground(Color.WHITE);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SequenceContainerEditor.class, (String)"SequenceContainerEditor.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SequenceContainerEditor.class, (String)"SequenceContainerEditor.accessible.description"));
        this.sequenceContainer = sequenceContainer;
        this.sequenceContainer.addSequenceContainerListener(this);
        this.sequenceContainer.addPropertyChangeListener(this);
        this.setSyncComponentHeight();
        this.rebuildUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
            Sequence oldSeq = (Sequence)evt.getOldValue();
            Sequence newSeq = (Sequence)evt.getNewValue();
            SequencePreviewPanel previewOld = (SequencePreviewPanel)this.previewMap.get(oldSeq);
            SequencePreviewPanel previewNew = (SequencePreviewPanel)this.previewMap.get(newSeq);
            if (previewOld != null) {
                previewOld.setImportant(false);
            }
            if (previewNew != null) {
                previewNew.setImportant(true);
            }
        }
    }

    private void rebuildUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SequenceContainerEditor.this.removeAll();
                SequenceContainerEditor.this.previewMap.clear();
                for (Sequence s : SequenceContainerEditor.this.sequenceContainer.getSequences()) {
                    ((SequenceEditingPanel)s.getEditor()).removeSequenceEditingPanelListener(SequenceContainerEditor.this);
                }
                SequenceContainerEditor.this.previewsPanel = new FastScrollPanel();
                SequenceContainerEditor.this.editorsPanel = new FastScrollPanel();
                SequenceContainerEditor.this.initScrolling();
                SequenceContainerEditor.this.initPreviews();
                SequenceContainerEditor.this.initEditors();
                SequenceContainerEditor.this.setLayout(new BorderLayout());
                SequenceContainerEditor.this.add((Component)SequenceContainerEditor.this.scrollPreviews, "West");
                SequenceContainerEditor.this.add((Component)SequenceContainerEditor.this.scrollEditors, "Center");
                SequenceContainerEditor.this.validate();
            }
        });
    }

    private void setSyncComponentHeight() {
        Sequence s = this.sequenceContainer.getDefaultSequence();
        JComponent preview = s.getPreview();
        JComponent editor = s.getEditor();
        this.syncComponentHeight = Math.max(preview.getPreferredSize().height, editor.getPreferredSize().height);
    }

    private void initPreviews() {
        this.previewsPanel.setBackground(Color.WHITE);
        this.previewsPanel.setLayout(new BoxLayout(this.previewsPanel, 1));
        for (Sequence s : this.sequenceContainer.getSequences()) {
            this.addPreviewForSequence(s);
        }
    }

    private void addPreviewForSequence(Sequence s) {
        JPanel p = new JPanel();
        p.setBackground(Color.WHITE);
        p.setLayout(new BoxLayout(p, 0));
        SequencePreviewPanel preview = (SequencePreviewPanel)s.getPreview();
        preview.setSequenceContainer(this.sequenceContainer);
        if (this.sequenceContainer.getDefaultSequence() == s) {
            preview.setImportant(true);
        } else {
            preview.setImportant(false);
        }
        p.add(preview);
        Dimension minSize = new Dimension(0, this.syncComponentHeight);
        Dimension prefSize = new Dimension(0, this.syncComponentHeight);
        Dimension maxSize = new Dimension(0, this.syncComponentHeight);
        p.add(new Box.Filler(minSize, prefSize, maxSize));
        this.previewsPanel.add(p);
        this.previewMap.put(s, preview);
    }

    private void initEditors() {
        this.editorsPanel.setBackground(Color.WHITE);
        this.editorsPanel.setLayout(new BoxLayout(this.editorsPanel, 1));
        Color colorEven = new Color(245, 245, 255);
        Color colorOdd = Color.WHITE;
        int index = 0;
        for (Sequence s : this.sequenceContainer.getSequences()) {
            Color bg = index++ % 2 == 0 ? colorEven : colorOdd;
            this.addEditorForSequence(s, bg);
        }
    }

    private void addEditorForSequence(Sequence s, Color c) {
        JPanel p = new JPanel();
        p.setBackground(c);
        p.setLayout(new BoxLayout(p, 0));
        SequenceEditingPanel editor = (SequenceEditingPanel)s.getEditor();
        editor.setBackground(c);
        editor.addSequenceEditingPanelListener(this);
        editor.setSequenceContainer(this.sequenceContainer);
        p.add(editor);
        Dimension minSize = new Dimension(0, this.syncComponentHeight);
        Dimension prefSize = new Dimension(0, this.syncComponentHeight);
        Dimension maxSize = new Dimension(0, this.syncComponentHeight);
        p.add(new Box.Filler(minSize, prefSize, maxSize));
        this.editorsPanel.add(p);
    }

    private void initScrolling() {
        this.scrollPreviews = new JScrollPane(this.previewsPanel);
        this.scrollPreviews.setHorizontalScrollBarPolicy(31);
        this.scrollPreviews.setVerticalScrollBarPolicy(21);
        this.scrollPreviews.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPreviews.getViewport().setBackground(Color.WHITE);
        this.scrollEditors = new JScrollPane(this.editorsPanel);
        this.scrollEditors.setBorder(BorderFactory.createEmptyBorder());
        this.scrollEditors.getViewport().setBackground(Color.WHITE);
        this.scrollEditors.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Point pPrev = SequenceContainerEditor.this.scrollPreviews.getViewport().getViewPosition();
                Point pEdit = SequenceContainerEditor.this.scrollEditors.getViewport().getViewPosition();
                Point n = new Point(pPrev.x, pEdit.y);
                SequenceContainerEditor.this.scrollPreviews.getViewport().setViewPosition(n);
            }
        });
    }

    @Override
    public void frameHilited(SequenceEditingPanel source, int frameIndex) {
        ((SequencePreviewPanel)this.previewMap.get(source.getSequence())).requestPreviewFrame(frameIndex);
    }

    @Override
    public void hiliteLost(SequenceEditingPanel source) {
        ((SequencePreviewPanel)this.previewMap.get(source.getSequence())).requestPreviewFrame(0);
    }

    @Override
    public void frameSelectionChange(SequenceEditingPanel source, int[] selectedFrameIdices) {
    }

    @Override
    public void sequenceAdded(SequenceContainer source, Sequence sequence, int index) {
        this.rebuildUI();
    }

    @Override
    public void sequenceRemoved(SequenceContainer source, Sequence sequence, int index) {
        this.rebuildUI();
    }

    @Override
    public void sequenceMoved(SequenceContainer source, Sequence sequence, int indexOld, int indexNew) {
    }

    class RulerHorizontal
    extends JComponent {
        private static final int SIZE = 18;
        private static final boolean DEBUG = false;

        public RulerHorizontal() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return NbBundle.getMessage(SequenceContainerEditor.class, (String)"SequenceContainerEditor.ruler.tooltip", (Object)this.getColumnAtPoint(event.getPoint()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = SequenceContainerEditor.this.editorsPanel.getPreferredSize();
            size.height = 18;
            return size;
        }

        @Override
        protected void paintComponent(Graphics graphincs) {
            int col;
            Graphics2D g = (Graphics2D)graphincs;
            Rectangle rect = g.getClipBounds();
            g.setColor(Color.WHITE);
            g.fill(rect);
            int unit = 1 + SequenceContainerEditor.this.filmUnitWidth;
            for (int x = rect.x / unit * unit; x <= rect.x + rect.width && (col = x / unit) < SequenceContainerEditor.this.maxFrameCount; x += unit) {
                boolean raised = true;
                g.setColor(new Color(240, 238, 230));
                g.fill3DRect(x, 0, unit, 18, raised);
            }
        }

        private int getColumnAtPoint(Point point) {
            return this.getColumnAtCoordinates(point.x, point.y);
        }

        private int getColumnAtCoordinates(int x, int y) {
            return (x - 1) / (SequenceContainerEditor.this.filmUnitWidth + 1);
        }
    }

    private static class FastScrollPanel
    extends JPanel
    implements Scrollable {
        private FastScrollPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

