/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.editor.scene.ScenePanel;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;

public class ScenePreviewPanel
extends JComponent
implements SceneListener {
    private Scene scene;
    private ScenePanel scenePanel;

    public ScenePreviewPanel(Scene scene) {
        this.scene = scene;
        this.scenePanel = new ScenePanel(scene);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScenePreviewPanel.this.repaint();
            }
        });
        this.scene.addSceneListener(this);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle bounds = this.scene.getAllLayersBounds();
        double ratioW = (double)this.getWidth() / bounds.getWidth();
        double ratioH = (double)this.getHeight() / bounds.getHeight();
        double ratio = Math.min(ratioW, ratioH);
        double x = 0.0;
        double y = 0.0;
        if (ratio == ratioW) {
            double newHeight = bounds.getHeight() * ratio;
            y = ((double)this.getHeight() - newHeight) / 2.0;
        } else {
            double newWidth = bounds.getWidth() * ratio;
            x = ((double)this.getWidth() - newWidth) / 2.0;
        }
        g.translate(x, y);
        g.scale(ratio, ratio);
        this.scenePanel.drawLayers(g);
    }

    @Override
    public void layerAdded(Scene sourceScene, Layer layer, int index) {
        this.sceneChangedVisualy();
    }

    @Override
    public void layerRemoved(Scene sourceScene, Layer layer, Scene.LayerInfo info, int index) {
        this.sceneChangedVisualy();
    }

    @Override
    public void layerMoved(Scene sourceScene, Layer layer, int indexOld, int indexNew) {
        this.sceneChangedVisualy();
    }

    @Override
    public void layerPositionChanged(Scene sourceScene, Layer layer, Point oldPosition, Point newPosition, boolean inTransition) {
        if (inTransition) {
            return;
        }
        this.sceneChangedVisualy();
    }

    @Override
    public void layerLockChanged(Scene sourceScene, Layer layer, boolean locked) {
        this.sceneChangedVisualy();
    }

    @Override
    public void layerVisibilityChanged(Scene sourceScene, Layer layer, boolean visible) {
        this.sceneChangedVisualy();
    }

    private void sceneChangedVisualy() {
        this.repaint();
    }
}

