/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.CvsVisibilityQuery;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;

public class CVS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener {
    private VCSVisibilityQuery visibilityQuery;
    private static final String PROP_PRIORITY = "Integer VCS.Priority";
    private static final Integer priority = org.netbeans.modules.versioning.util.Utils.getPriority((String)"cvs");
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File a, File b) {
            File fra = CVS.this.getTopmostManagedAncestor(a);
            File frb = CVS.this.getTopmostManagedAncestor(b);
            if (fra == null || !fra.equals(frb)) {
                return false;
            }
            try {
                String ra = Utils.getCVSRootFor(a);
                String rb = Utils.getCVSRootFor(b);
                String rr = Utils.getCVSRootFor(fra);
                return ra.equals(rb) && ra.equals(rr);
            }
            catch (IOException e) {
                return false;
            }
        }

        public File findRoot(File file) {
            return CVS.this.getTopmostManagedAncestor(file);
        }
    };

    public CVS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(CVS.class, (String)"CTL_CVS_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(CVS.class, (String)"CTL_CVS_MainMenu"));
        this.putProperty(PROP_PRIORITY, priority);
        CvsVersioningSystem.getInstance().addVersioningListener(this);
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        return CvsVersioningSystem.getInstance().getTopmostManagedParent(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return CvsVersioningSystem.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return CvsVersioningSystem.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        CvsVersioningSystem.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public VCSVisibilityQuery getVisibilityQuery() {
        if (this.visibilityQuery == null) {
            this.visibilityQuery = new CvsVisibilityQuery();
        }
        return this.visibilityQuery;
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            this.fireStatusChanged(file);
        } else if (event.getId() == CvsVersioningSystem.EVENT_REFRESH_ANNOTATIONS) {
            this.fireStatusChanged(null);
        } else if (event.getId() == CvsVersioningSystem.EVENT_VERSIONED_FILES_CHANGED) {
            this.fireVersionedFilesChanged();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        } else if (evt.getKey().startsWith("annotationsFormat")) {
            this.fireAnnotationsChanged(null);
        }
    }
}

