/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.support;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.ForeignKeyConstraint;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLRequestsProcessor;
import org.netbeans.modules.dlight.spi.support.SQLStatementsCache;
import org.netbeans.modules.dlight.spi.support.impl.SQLBaseRequest;
import org.netbeans.modules.dlight.spi.support.impl.SQLConnection;
import org.netbeans.modules.dlight.spi.support.impl.SQLRequestsProcessorImpl;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;
import org.openide.util.Exceptions;

public abstract class SQLDataStorage
implements PersistentDataStorage {
    public static final String SQL_DATA_STORAGE_TYPE = "db:sql";
    private static final Logger logger = DLightLogger.getLogger(SQLDataStorage.class);
    private static final HashMap<Class<?>, String> classToType = new HashMap();
    private static final DataStorageType storageType = DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    private final HashMap<String, DataTableMetadata> tables;
    private final ConcurrentHashMap<DataTableMetadata, String> tblMetadataToInsertSQL;
    private final SQLRequestsProcessorImpl requestProcessor;
    private final SQLStatementsCache statementsCache;
    private final String dburl;
    private final SQLConnection connection = new SQLConnection();
    private volatile ServiceInfoDataStorage serviceInfoDataStorage;

    public static DataStorageType getStorageType() {
        return storageType;
    }

    protected SQLDataStorage(String dburl) {
        this.dburl = dburl;
        this.tables = new HashMap();
        this.tblMetadataToInsertSQL = new ConcurrentHashMap();
        this.requestProcessor = new SQLRequestsProcessorImpl(5000, 200, TimeUnit.MILLISECONDS);
        this.statementsCache = SQLStatementsCache.getFor(this);
    }

    @Override
    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        this.serviceInfoDataStorage = serviceInfoStorage;
    }

    protected final ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    public abstract String getSQLQueriesDelimeter();

    public abstract String getPrimaryKeyExpression();

    public abstract String getAutoIncrementExpresion();

    public abstract String createForeignKeyConstraint(ForeignKeyConstraint var1);

    public final synchronized void connect() throws SQLException {
        this.connection.connect(this.doConnect());
        this.postConnectInit();
    }

    protected abstract Connection doConnect() throws SQLException;

    protected void postConnectInit() {
    }

    protected final String getDbURL() {
        return this.dburl;
    }

    protected String classToType(Class<?> clazz) {
        return classToType.get(clazz);
    }

    protected Class<?> typeToClass(String type) {
        Set<Class<?>> clazzes = classToType.keySet();
        for (Class<?> clazz : clazzes) {
            if (!classToType.get(clazz).equalsIgnoreCase(type)) continue;
            return clazz;
        }
        return String.class;
    }

    protected final String createView(Collection<DataTableMetadataFilter> filters, String tableName, List<DataTableMetadata.Column> columns) {
        if (filters == null || filters.isEmpty()) {
            return tableName;
        }
        String viewName = tableName + "_DLIGHT_VIEW";
        this.connection.execute("DROP VIEW IF EXISTS " + viewName);
        StringBuilder createViewQuery = new StringBuilder("CREATE  VIEW " + viewName + " AS ");
        createViewQuery.append("SELECT ");
        createViewQuery.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(columns, new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column item) {
                return item.getExpression() == null ? item.getColumnName() : item.getExpression() + " AS " + item.getColumnName();
            }
        }));
        createViewQuery.append(" FROM ").append(tableName);
        String whereClause = null;
        for (DataTableMetadataFilter filter : filters) {
            Range<?> range;
            DataTableMetadata.Column filterColumn = filter.getFilteredColumn();
            if (!columns.contains(filterColumn) || (range = filter.getNumericDataFilter().getInterval()).getStart() == null && range.getEnd() == null) continue;
            whereClause = range.toString(" WHERE ", "%d <= " + filterColumn.getColumnName(), " AND ", filterColumn.getColumnName() + " <= %d", null);
            break;
        }
        if (whereClause == null) {
            return tableName;
        }
        createViewQuery.append(whereClause);
        if (!this.connection.execute(createViewQuery.toString())) {
            return tableName;
        }
        return viewName;
    }

    protected final void loadTable(DataTableMetadata metadata) {
        this.tables.put(metadata.getName(), metadata);
    }

    protected final boolean createTable(final DataTableMetadata metadata) {
        if (this.tables.containsKey(metadata.getName())) {
            return true;
        }
        String tableName = metadata.getName();
        StringBuilder sb = new StringBuilder("CREATE TABLE " + tableName + "(");
        sb.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(metadata.getColumns(), new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column item) {
                return item.getColumnName() + " " + SQLDataStorage.this.classToType(item.getColumnClass()) + " " + (metadata.isAutoIncrement(item) && SQLDataStorage.this.getAutoIncrementExpresion() != null ? SQLDataStorage.this.getAutoIncrementExpresion() : "") + " " + (metadata.isPrimaryKey(item) && SQLDataStorage.this.getPrimaryKeyExpression() != null ? SQLDataStorage.this.getPrimaryKeyExpression() : "");
            }
        }));
        List<ForeignKeyConstraint> fKeys = metadata.getForeignKeyConstraints();
        if (!fKeys.isEmpty()) {
            for (ForeignKeyConstraint fKey : fKeys) {
                DataTableMetadata referenceTable = fKey.getReferenceTable();
                if (!this.tables.containsKey(metadata.getName())) {
                    this.createTable(referenceTable);
                }
                sb.append(", ").append(this.createForeignKeyConstraint(fKey));
            }
        }
        sb.append(")").append(this.getSQLQueriesDelimeter());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "About to execute query: {0}", sb.toString());
        }
        if (!this.connection.execute(sb.toString())) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Table {0} created", tableName);
        }
        this.tables.put(tableName, metadata);
        for (DataTableMetadata.Column col : metadata.getIndexedColumns()) {
            this.connection.execute("create index " + tableName + "_" + col.getColumnName() + "_index on " + tableName + "(" + col.getColumnName() + ")");
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                SQLDataStorage.this.getPreparedInsertStatement(metadata);
            }
        }, (String)("SQL: Prepare Insert Statement for " + metadata.getName()));
        return true;
    }

    public PreparedStatement getPreparedInsertStatement(DataTableMetadata tableDescription, DataRow row) {
        String tableName = tableDescription.getName();
        if (this.tables.get(tableName) == null) {
            this.createTable(tableDescription);
            tableDescription = this.tables.get(tableName);
        }
        return this.createRowInsertStatement(tableDescription, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedInsertStatement(DataTableMetadata tableDescription) {
        String tableName;
        String sql = this.tblMetadataToInsertSQL.get(tableDescription);
        if (sql == null) {
            sql = this.createInsertQuery(tableDescription);
            this.tblMetadataToInsertSQL.putIfAbsent(tableDescription, sql);
        }
        if (!this.tables.containsKey(tableName = tableDescription.getName())) {
            HashMap<String, DataTableMetadata> hashMap = this.tables;
            synchronized (hashMap) {
                if (!this.tables.containsKey(tableName) && !this.createTable(tableDescription)) {
                    return null;
                }
            }
        }
        PreparedStatement result = null;
        try {
            result = this.statementsCache.getPreparedStatement(sql);
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private String createInsertQuery(DataTableMetadata tableDescription) {
        String tableName = tableDescription.getName();
        StringBuilder query = new StringBuilder("insert into " + tableName + " (");
        query.append(new EnumStringConstructor<String>().constructEnumString(tableDescription.getColumnNames(), new Convertor<String>(){

            @Override
            public String toString(String item) {
                return item;
            }
        }));
        query.append(") values (");
        int columnsCount = tableDescription.getColumnsCount();
        for (int i = 0; i < columnsCount - 1; ++i) {
            query.append("?, ");
        }
        query.append("? ) ").append(this.getSQLQueriesDelimeter());
        return query.toString();
    }

    public ResultSet select(String tableName, List<DataTableMetadata.Column> columns) {
        return this.select(tableName, columns, null);
    }

    @Override
    public Collection<DataStorageType> getStorageTypes() {
        return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType(SQL_DATA_STORAGE_TYPE));
    }

    public final synchronized ResultSet select(DataTableMetadata metadata, Collection<DataTableMetadataFilter> filters) {
        String tableName = metadata.getName();
        String sqlQuery = metadata.getViewStatement();
        List<DataTableMetadata.Column> columns = metadata.getColumns();
        List<DataTableMetadata> sourceTables = metadata.getSourceTables();
        HashMap<String, String> renamedTableNames = new HashMap<String, String>();
        if (sourceTables != null) {
            for (DataTableMetadata sourceTable : sourceTables) {
                String viewName = this.createView(filters, sourceTable.getName(), sourceTable.getColumns());
                if (viewName == null || viewName.equals(sourceTable.getName())) continue;
                renamedTableNames.put(sourceTable.getName(), viewName);
            }
        } else {
            String viewName = this.createView(filters, tableName, columns);
            if (viewName != null && viewName.equals(tableName)) {
                return this.select(tableName, columns, sqlQuery);
            }
            if (sqlQuery == null) {
                return this.select(viewName, columns, null);
            }
        }
        String sqlQueryNew = sqlQuery;
        for (Map.Entry entry : renamedTableNames.entrySet()) {
            sqlQueryNew = sqlQueryNew.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return this.select(tableName, columns, sqlQueryNew);
    }

    public final ResultSet select(String tableName, List<DataTableMetadata.Column> columns, String sqlQuery) {
        if (sqlQuery == null) {
            StringBuilder query = new StringBuilder("select ");
            query.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(columns, new Convertor<DataTableMetadata.Column>(){

                @Override
                public String toString(DataTableMetadata.Column item) {
                    return item.getExpression() == null ? item.getColumnName() : item.getExpression() + " AS " + item.getColumnName();
                }
            }));
            query.append(" from ").append(tableName);
            sqlQuery = query.toString();
        }
        return this.connection.executeQuery(sqlQuery);
    }

    public void executeUpdate(String sql) throws SQLException {
        this.connection.executeUpdate(sql);
    }

    public int executeUpdate(PreparedStatement statement) {
        try {
            return statement.executeUpdate();
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    protected final Connection getConnection() {
        return this.connection.getConnection();
    }

    protected void addInsertInQueue(PreparedStatement st) {
        this.requestProcessor.queueRequest(new CustomRequest(st));
    }

    @Override
    public final void addData(String tableName, List<DataRow> data) {
        for (DataRow row : data) {
            this.requestProcessor.queueRequest(new DataRowInsertRequest(tableName, row));
        }
    }

    @Override
    public synchronized boolean shutdown() {
        try {
            this.statementsCache.close();
            this.connection.close();
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    @Override
    public final synchronized void syncAddData(String tableName, List<DataRow> data) {
        for (DataRow row : data) {
            DataRowInsertRequest request = new DataRowInsertRequest(tableName, row);
            try {
                request.execute();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private PreparedStatement createRowInsertStatement(String tableName, DataRow row) {
        logger.fine("Will add to the queue with using prepared statement");
        StringBuilder query = new StringBuilder("insert into " + tableName + " (");
        query.append(new EnumStringConstructor<String>().constructEnumString(row.getColumnNames(), new Convertor<String>(){

            @Override
            public String toString(String item) {
                return item;
            }
        }));
        query.append(") values (");
        query.append(new EnumStringConstructor<Object>().constructEnumString(row.getData(), new Convertor<Object>(){

            @Override
            public String toString(Object item) {
                return '\'' + String.valueOf(item) + '\'';
            }
        }));
        query.append(")").append(this.getSQLQueriesDelimeter());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "----------SQL: dispatching {0}", query.toString());
        }
        return this.connection.prepareStatement(query.toString());
    }

    private PreparedStatement createRowInsertStatement(DataTableMetadata table, DataRow row) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Will add to the queue with using prepared statement");
        }
        String tableName = table.getName();
        StringBuilder query = new StringBuilder("insert into " + tableName + " (");
        StringBuilder sb = new StringBuilder();
        Iterator<DataTableMetadata.Column> i = table.getColumns().iterator();
        while (i.hasNext()) {
            DataTableMetadata.Column item = i.next();
            if (table.isAutoIncrement(item)) continue;
            sb.append(item.getColumnName());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        query.append(sb.toString());
        query.append(") values (");
        query.append(new EnumStringConstructor<Object>().constructEnumString(row.getData(), new Convertor<Object>(){

            @Override
            public String toString(Object item) {
                return '\'' + String.valueOf(item) + '\'';
            }
        }));
        query.append(")").append(this.getSQLQueriesDelimeter());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "----------SQL: dispatching {0}", query.toString());
        }
        return this.connection.prepareStatement(query.toString());
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        String sqlUpper;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SQL: prepare statement {0}", sql);
        }
        PreparedStatement stmt = (sqlUpper = sql.toUpperCase()).startsWith("INSERT INTO ") ? this.connection.prepareStatement(sql, 1) : (sqlUpper.endsWith(" FOR UPDATE") ? this.connection.prepareStatement(sql, 1003, 1008) : this.connection.prepareStatement(sql));
        return stmt;
    }

    public void flush() {
        this.requestProcessor.flush();
    }

    public final SQLRequestsProcessor getRequestsProcessor() {
        return this.requestProcessor;
    }

    static {
        classToType.put(Byte.class, "tinyint");
        classToType.put(Short.class, "smallint");
        classToType.put(Integer.class, "int");
        classToType.put(Long.class, "bigint");
        classToType.put(Double.class, "double");
        classToType.put(Float.class, "real");
        classToType.put(String.class, "varchar");
        classToType.put(Time.class, "bigint");
    }

    public static interface Convertor<T> {
        public String toString(T var1);
    }

    public static final class EnumStringConstructor<T> {
        public String constructEnumString(Collection<? extends T> collection, Convertor<T> conv) {
            StringBuilder sb = new StringBuilder();
            Iterator<T> i = collection.iterator();
            while (i.hasNext()) {
                T item = i.next();
                sb.append(conv.toString(item));
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    private class DataRowInsertRequest
    extends SQLBaseRequest {
        final String tableName;
        final DataRow dataRow;

        public DataRowInsertRequest(String tableName, DataRow dataRow) {
            this.tableName = tableName;
            this.dataRow = dataRow;
        }

        @Override
        public PreparedStatement getPreparedStatement() throws SQLException {
            DataTableMetadata tableMetadata = (DataTableMetadata)SQLDataStorage.this.tables.get(this.tableName);
            PreparedStatement statement = SQLDataStorage.this.getPreparedInsertStatement(tableMetadata);
            if (statement == null) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            List<DataTableMetadata.Column> columns = tableMetadata.getColumns();
            List<String> columnNames = this.dataRow.getColumnNames();
            if (columnNames.size() != columns.size()) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                DataTableMetadata.Column c = columns.get(i);
                statement.setObject(i + 1, this.dataRow.getData(c.getColumnName()));
            }
            return statement;
        }

        public String toString() {
            return "insert into " + this.tableName + ": " + this.dataRow.toString();
        }
    }

    private static class CustomRequest
    extends SQLBaseRequest {
        PreparedStatement preparedStatement;

        public CustomRequest(PreparedStatement preparedStatement) {
            this.preparedStatement = preparedStatement;
        }

        @Override
        public PreparedStatement getPreparedStatement() throws SQLException {
            return this.preparedStatement;
        }
    }
}

