/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.support.TimerIDPConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;

public final class TimerTicker
extends IndicatorDataProvider<TimerIDPConfiguration>
implements Runnable {
    private static final List<DataTableMetadata> metadata;
    private static final List<String> columnNames;
    private long startTime = 0L;
    private DLightExecutorService.DLightScheduledTask tickerTask;

    TimerTicker(TimerIDPConfiguration configuration) {
        super("Timer");
    }

    @Override
    protected synchronized void targetStarted(DLightTarget target) {
        this.resetIndicators();
        this.tickerTask = DLightExecutorService.scheduleAtFixedRate((Runnable)this, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"TimerTicker");
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected synchronized void targetFinished(DLightTarget target) {
        this.tickerTask.cancel(1L);
        this.tickerTask = null;
    }

    @Override
    public void run() {
        DataRow data = new DataRow(columnNames, Collections.singletonList(System.currentTimeMillis() - this.startTime));
        this.notifyIndicators(Collections.singletonList(data));
    }

    @Override
    protected ValidationStatus doValidation(DLightTarget target) {
        return ValidationStatus.validStatus();
    }

    @Override
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    @Override
    public List<DataTableMetadata> getDataTablesMetadata() {
        return metadata;
    }

    static {
        DataTableMetadata tableMetadata = new DataTableMetadata("time", Collections.singletonList(TimerIDPConfiguration.TIME_INFO), null);
        metadata = Collections.singletonList(tableMetadata);
        columnNames = tableMetadata.getColumnNames();
    }
}

