/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionImpl;
import org.netbeans.modules.websvc.rest.model.impl.RestServicesImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;

public class HttpMethodImpl
extends RestMethodDescriptionImpl
implements HttpMethod {
    private String type;
    private String consumeMime;
    private String produceMime;
    private String path;
    private Map<String, String> queryParams;

    public HttpMethodImpl(ExecutableElement methodElement) {
        super(methodElement);
        this.type = Utils.getHttpMethod(methodElement);
        this.consumeMime = Utils.getConsumeMime(methodElement);
        this.produceMime = Utils.getProduceMime(methodElement);
        this.path = Utils.hasUriTemplate(methodElement) ? Utils.getUriTemplate(methodElement) : "";
        this.queryParams = new HashMap<String, String>();
        Utils.fillQueryParams(this.queryParams, methodElement);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getConsumeMime() {
        return this.consumeMime;
    }

    @Override
    public String getProduceMime() {
        return this.produceMime;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public RestServicesImpl.Status refresh(Element element) {
        boolean isModified = false;
        if (super.refresh(element) == RestServicesImpl.Status.MODIFIED) {
            isModified = true;
        }
        if (!Utils.hasHttpMethod(element)) {
            return RestServicesImpl.Status.REMOVED;
        }
        String newValue = Utils.getConsumeMime(element);
        if (!this.consumeMime.equals(newValue)) {
            this.consumeMime = newValue;
            isModified = true;
        }
        if (!this.produceMime.equals(newValue = Utils.getProduceMime(element))) {
            this.produceMime = newValue;
            isModified = true;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Utils.fillQueryParams(map, element);
        Set current = map.keySet();
        Set<String> original = this.queryParams.keySet();
        if (current.containsAll(original) && current.size() != original.size()) {
            for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null && map.get(key) != null) {
                    this.queryParams = map;
                    isModified = true;
                } else {
                    if (value == null || value.equals(map.get(key))) continue;
                    this.queryParams = map;
                    isModified = true;
                }
                break;
            }
        } else {
            this.queryParams = map;
            isModified = true;
        }
        if (isModified) {
            return RestServicesImpl.Status.MODIFIED;
        }
        return RestServicesImpl.Status.UNMODIFIED;
    }
}

