/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class SessionSynchImplementedBySFSBOnly
extends EJBVerificationRule {
    private static final String SESSION_SYNC_IFACE = "javax.ejb.SessionSynchronization";

    @Override
    public Collection<ErrorDescription> check(EJBProblemContext ctx) {
        if (ctx.getEjb() instanceof Session && "Stateful".equals(((Session)ctx.getEjb()).getSessionType())) {
            return null;
        }
        for (TypeMirror typeMirror : ctx.getClazz().getInterfaces()) {
            String ifaceName = JavaUtils.extractClassNameFromType(typeMirror);
            if (!SESSION_SYNC_IFACE.equals(ifaceName)) continue;
            ErrorDescription err = HintsUtils.createProblem(ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(SessionSynchImplementedBySFSBOnly.class, (String)"MSG_SessionSynchImplementedBySFSBOnly"));
            return Collections.singletonList(err);
        }
        return null;
    }
}

