/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCollectionMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping,
EmbeddableMapping {
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys;
    protected transient Map<String, DatabaseField> aggregateToSourceFields = new HashMap<String, DatabaseField>(5);
    protected transient Map<String, Map<String, DatabaseField>> nestedAggregateToSourceFields = new HashMap<String, Map<String, DatabaseField>>(5);
    protected ClassDescriptor remoteReferenceDescriptor;
    protected transient boolean isEntireObjectPK;
    protected transient DataModifyQuery updateListOrderFieldQuery;
    protected transient DataModifyQuery bulkUpdateListOrderFieldQuery;
    protected transient DataModifyQuery pkUpdateListOrderFieldQuery;
    protected boolean isListOrderFieldUpdatable;
    protected static final String min = "min";
    protected static final String max = "max";
    protected static final String shift = "shift";
    protected static final String pk = "pk";
    protected static final String bulk = "bulk";

    public AggregateCollectionMapping() {
        this.targetForeignKeyToSourceKeys = new HashMap<DatabaseField, DatabaseField>(5);
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
        this.setCascadeAll(true);
        this.isListOrderFieldSupported = true;
        this.isListOrderFieldUpdatable = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    @Override
    public void addOverrideManyToManyMapping(ManyToManyMapping mapping) {
    }

    @Override
    public void addOverrideUnidirectionalOneToManyMapping(UnidirectionalOneToManyMapping mapping) {
    }

    public void addFieldNameTranslation(String sourceFieldName, String aggregateFieldName) {
        this.addFieldTranslation(new DatabaseField(sourceFieldName), aggregateFieldName);
    }

    @Override
    public void addFieldTranslation(DatabaseField sourceField, String aggregateField) {
        this.aggregateToSourceFields.put(aggregateField, sourceField);
    }

    public void addFieldTranslations(Map<String, DatabaseField> map) {
        this.aggregateToSourceFields.putAll(map);
    }

    public void addNestedFieldNameTranslation(String attributeName, String sourceFieldName, String aggregateFieldName) {
        this.addNestedFieldTranslation(attributeName, new DatabaseField(sourceFieldName), aggregateFieldName);
    }

    @Override
    public void addNestedFieldTranslation(String attributeName, DatabaseField sourceField, String aggregateFieldName) {
        Map<String, DatabaseField> attributeFieldNameTranslation = this.nestedAggregateToSourceFields.get(attributeName);
        if (attributeFieldNameTranslation == null) {
            attributeFieldNameTranslation = new HashMap<String, DatabaseField>(5);
            this.nestedAggregateToSourceFields.put(attributeName, attributeFieldNameTranslation);
        }
        attributeFieldNameTranslation.put(aggregateFieldName, sourceField);
    }

    public void addNestedFieldNameTranslations(String attributeName, Map<String, DatabaseField> map) {
        Map<String, DatabaseField> attributeFieldNameTranslation = this.nestedAggregateToSourceFields.get(attributeName);
        if (attributeFieldNameTranslation == null) {
            this.nestedAggregateToSourceFields.put(attributeName, map);
        } else {
            attributeFieldNameTranslation.putAll(map);
        }
    }

    public void addTargetForeignKeyField(DatabaseField targetForeignKey, DatabaseField sourceKey) {
        this.getTargetForeignKeyFields().addElement(targetForeignKey);
        this.getSourceKeyFields().addElement(sourceKey);
    }

    public void addTargetForeignKeyFieldName(String targetForeignKey, String sourceKey) {
        this.addTargetForeignKeyField(new DatabaseField(targetForeignKey), new DatabaseField(sourceKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object object = attributeValue;
        synchronized (object) {
            Object valuesIterator = containerPolicy.iteratorFor(attributeValue);
            while (containerPolicy.hasNext(valuesIterator)) {
                Object wrappedElement = containerPolicy.nextEntry(valuesIterator, unitOfWork);
                Object cloneValue = this.buildElementBackupClone(containerPolicy.unwrapIteratorResult(wrappedElement), unitOfWork);
                containerPolicy.addInto(containerPolicy.keyFromIterator(valuesIterator), cloneValue, clonedAttributeValue, unitOfWork);
            }
        }
        return clonedAttributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession, boolean isExisting) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object valuesIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(valuesIterator)) {
            Object wrappedElement = containerPolicy.nextEntry(valuesIterator, cloningSession);
            Object originalElement = containerPolicy.unwrapIteratorResult(wrappedElement);
            if (cloningSession.isUnitOfWork() && ((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original)) {
                ((UnitOfWorkImpl)cloningSession).addNewAggregate(originalElement);
            }
            Object cloneValue = this.buildElementClone(originalElement, clone, cacheKey, cloningSession, isExisting);
            Object clonedKey = containerPolicy.buildCloneForKey(containerPolicy.keyFromIterator(valuesIterator), clone, cacheKey, cloningSession, isExisting);
            containerPolicy.addInto(clonedKey, cloneValue, clonedAttributeValue, cloningSession);
        }
        if (temporaryCollection instanceof IndirectList) {
            ((IndirectList)clonedAttributeValue).setIsListOrderBrokenInDb(((IndirectList)temporaryCollection).isListOrderBrokenInDb());
        }
        return clonedAttributeValue;
    }

    protected Object buildElementBackupClone(Object element, UnitOfWorkImpl unitOfWork) {
        if (unitOfWork.isClassReadOnly(element.getClass(), this.getReferenceDescriptor())) {
            return element;
        }
        ClassDescriptor aggregateDescriptor = this.getReferenceDescriptor(element.getClass(), unitOfWork);
        Object clonedElement = aggregateDescriptor.getObjectBuilder().buildBackupClone(element, unitOfWork);
        return clonedElement;
    }

    @Override
    public Object buildElementClone(Object element, Object parent, CacheKey parentCacheKey, AbstractSession cloningSession, boolean isExisting) {
        if (cloningSession.isUnitOfWork() && cloningSession.isClassReadOnly(element.getClass(), this.getReferenceDescriptor())) {
            return element;
        }
        ClassDescriptor aggregateDescriptor = this.getReferenceDescriptor(element.getClass(), cloningSession);
        Object clonedElement = aggregateDescriptor.getObjectBuilder().instantiateWorkingCopyClone(element, cloningSession);
        aggregateDescriptor.getObjectBuilder().populateAttributesForClone(element, parentCacheKey, clonedElement, cloningSession);
        if (cloningSession.isUnitOfWork()) {
            ((UnitOfWorkImpl)cloningSession).getCloneToOriginals().put(clonedElement, element);
        }
        return clonedElement;
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> cacheFields) {
        for (DatabaseField field : this.getSourceKeyFields()) {
            cacheFields.add(field);
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (nextObject == null) continue;
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadeDiscoverAndPersistUnregisteredNewObjects(nextObject, newObjects, unregisteredExistingObjects, visitedObjects, uow);
            cp.cascadeDiscoverAndPersistUnregisteredNewObjects(wrappedObject, newObjects, unregisteredExistingObjects, visitedObjects, uow);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(nextObject, uow, visitedObjects);
            cp.cascadeRegisterNewIfRequired(wrappedObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        if (this.usesIndirection() && !this.mustDeleteReferenceObjectsOneByOne() && !this.indirectionPolicy.objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object wrappedObject = cp.nextEntry(cloneIter, uow);
            Object nextObject = cp.unwrapIteratorResult(wrappedObject);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            if (this.isCascadeOnDeleteSetOnDatabase) {
                uow.getCascadeDeleteObjects().add(nextObject);
            }
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadePerformRemove(nextObject, uow, visitedObjects);
            cp.cascadePerformRemoveIfRequired(wrappedObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.getIndirectionPolicy().objectIsInstantiated(attributeValue)) {
            Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
            ContainerPolicy cp = this.getContainerPolicy();
            Object cloneIter = cp.iteratorFor(cloneObjectCollection);
            while (cp.hasNext(cloneIter)) {
                Object referencedObject = cp.next(cloneIter, uow);
                if (referencedObject == null || visitedObjects.containsKey(referencedObject)) continue;
                visitedObjects.put(referencedObject, referencedObject);
                ObjectBuilder builder = this.getReferenceDescriptor(referencedObject.getClass(), uow).getObjectBuilder();
                builder.cascadePerformRemovePrivateOwnedObjectFromChangeSet(referencedObject, uow, visitedObjects);
            }
        }
    }

    @Override
    public Object clone() {
        AggregateCollectionMapping mappingObject = (AggregateCollectionMapping)super.clone();
        mappingObject.setTargetForeignKeyToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeyToSourceKeys()));
        mappingObject.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getSourceKeyFields()));
        mappingObject.setTargetForeignKeyFields(NonSynchronizedVector.newInstance(this.getTargetForeignKeyFields()));
        mappingObject.aggregateToSourceFields = new HashMap<String, DatabaseField>(this.aggregateToSourceFields);
        mappingObject.nestedAggregateToSourceFields = new HashMap<String, Map<String, DatabaseField>>(this.nestedAggregateToSourceFields);
        if (this.updateListOrderFieldQuery != null) {
            mappingObject.updateListOrderFieldQuery = this.updateListOrderFieldQuery;
        }
        if (this.bulkUpdateListOrderFieldQuery != null) {
            mappingObject.bulkUpdateListOrderFieldQuery = this.bulkUpdateListOrderFieldQuery;
        }
        if (this.pkUpdateListOrderFieldQuery != null) {
            mappingObject.pkUpdateListOrderFieldQuery = this.pkUpdateListOrderFieldQuery;
        }
        return mappingObject;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            ContainerPolicy cp = this.getContainerPolicy();
            Object backupCollection = null;
            Object cloneCollection = null;
            cloneCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
            backupCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
            if (cp.sizeFor(backupCollection) != cp.sizeFor(cloneCollection)) {
                return this.convertToChangeRecord(cloneCollection, backupCollection, owner, session);
            }
            Object cloneIterator = cp.iteratorFor(cloneCollection);
            Object backUpIterator = cp.iteratorFor(backupCollection);
            boolean change = false;
            UnitOfWorkChangeSet uowComparisonChangeSet = new UnitOfWorkChangeSet(session);
            while (cp.hasNext(cloneIterator)) {
                Object cloneObject = cp.next(cloneIterator, session);
                if (cloneObject == null) {
                    change = true;
                    break;
                }
                Object backUpObject = null;
                if (!cp.hasNext(backUpIterator)) {
                    change = true;
                    break;
                }
                backUpObject = cp.next(backUpIterator, session);
                if (cloneObject.getClass().equals(backUpObject.getClass())) {
                    ObjectBuilder builder = this.getReferenceDescriptor(cloneObject.getClass(), session).getObjectBuilder();
                    ObjectChangeSet initialChanges = builder.createObjectChangeSet(cloneObject, uowComparisonChangeSet, owner.isNew(), session);
                    ObjectChangeSet changes = builder.compareForChange(cloneObject, backUpObject, uowComparisonChangeSet, session);
                    if (changes == null) continue;
                    change = true;
                    break;
                }
                change = true;
                break;
            }
            if (change || cp.hasNext(backUpIterator)) {
                return this.convertToChangeRecord(cloneCollection, backupCollection, owner, session);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(clone, session), this.containerPolicy.containerInstance(), owner, session);
    }

    @Override
    protected void compareListsAndWrite(List previousList, List currentList, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isListOrderFieldUpdatable) {
            this.compareListsAndWrite_UpdatableListOrderField(previousList, currentList, query);
        } else {
            this.compareListsAndWrite_NonUpdatableListOrderField(previousList, currentList, query);
        }
    }

    protected void compareListsAndWrite_NonUpdatableListOrderField(List previousList, List currentList, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object[] previousAndCurrent;
        CacheId primaryKey;
        int i;
        boolean shouldRepairOrder = false;
        if (currentList instanceof IndirectList) {
            shouldRepairOrder = ((IndirectList)currentList).isListOrderBrokenInDb();
        }
        HashMap<CacheId, Object[]> previousAndCurrentByKey = new HashMap<CacheId, Object[]>();
        int pkSize = this.getReferenceDescriptor().getPrimaryKeyFields().size();
        for (i = 0; i < currentList.size(); ++i) {
            Object currentObject = currentList.get(i);
            try {
                primaryKey = (CacheId)this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(currentObject, query.getSession());
                primaryKey.add(i);
                previousAndCurrent = new Object[]{null, currentObject};
                previousAndCurrentByKey.put(primaryKey, previousAndCurrent);
                continue;
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
        if (shouldRepairOrder) {
            DeleteAllQuery deleteAllQuery = (DeleteAllQuery)this.deleteAllQuery;
            if (this.isCascadeOnDeleteSetOnDatabase) {
                deleteAllQuery = (DeleteAllQuery)deleteAllQuery.clone();
                deleteAllQuery.setIsInMemoryOnly(false);
            }
            deleteAllQuery.executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), new Vector(previousList));
        } else {
            for (i = 0; i < previousList.size(); ++i) {
                Object previousObject = previousList.get(i);
                primaryKey = (CacheId)this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(previousObject, query.getSession());
                primaryKey.add(i);
                previousAndCurrent = (Object[])previousAndCurrentByKey.get(primaryKey);
                if (previousAndCurrent == null) {
                    DatabaseRecord extraData = new DatabaseRecord(1);
                    extraData.put(this.listOrderField, (Object)i);
                    this.objectRemovedDuringUpdate(query, previousObject, extraData);
                    continue;
                }
                previousAndCurrent[0] = previousObject;
            }
        }
        for (Map.Entry entry : previousAndCurrentByKey.entrySet()) {
            Object key = entry.getKey();
            previousAndCurrent = (Object[])entry.getValue();
            Object previousObject = previousAndCurrent[0];
            Object currentObject = previousAndCurrent[1];
            if (previousObject == null) {
                int iCurrent = (Integer)((CacheId)key).getPrimaryKey()[pkSize];
                DatabaseRecord extraData = new DatabaseRecord(1);
                extraData.put(this.listOrderField, (Object)iCurrent);
                this.objectAddedDuringUpdate(query, currentObject, null, extraData);
                continue;
            }
            if (this.isEntireObjectPK) continue;
            this.objectUnchangedDuringUpdate(query, currentObject, previousObject);
        }
        if (shouldRepairOrder) {
            ((IndirectList)currentList).setIsListOrderBrokenInDb(false);
        }
    }

    protected void compareListsAndWrite_UpdatableListOrderField(List previousList, List currentList, WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        int iCurrent;
        Object[] previousAndCurrent;
        Object primaryKey;
        int i;
        boolean shouldRepairOrder = false;
        if (currentList instanceof IndirectList) {
            shouldRepairOrder = ((IndirectList)currentList).isListOrderBrokenInDb();
        }
        HashMap<Object, Object[]> previousAndCurrentByKey = new HashMap<Object, Object[]>();
        TreeMap<Integer, Integer> currentIndexByPreviousIndex = new TreeMap<Integer, Integer>();
        for (i = 0; i < currentList.size(); ++i) {
            Object currentObject = currentList.get(i);
            try {
                primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(currentObject, query.getSession());
                previousAndCurrent = new Object[]{null, currentObject, null, i};
                previousAndCurrentByKey.put(primaryKey, previousAndCurrent);
                continue;
            }
            catch (NullPointerException e) {
                if (currentObject == null) continue;
                throw e;
            }
        }
        for (i = 0; i < previousList.size(); ++i) {
            Object previousObject = previousList.get(i);
            primaryKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(previousObject, query.getSession());
            previousAndCurrent = (Object[])previousAndCurrentByKey.get(primaryKey);
            if (previousAndCurrent == null) {
                this.objectRemovedDuringUpdate(query, previousObject, null);
                continue;
            }
            previousAndCurrent[0] = previousObject;
            previousAndCurrent[2] = i;
            iCurrent = (Integer)previousAndCurrent[3];
            if (i == iCurrent && !shouldRepairOrder) continue;
            currentIndexByPreviousIndex.put(i, iCurrent);
        }
        if (!currentIndexByPreviousIndex.isEmpty()) {
            boolean shouldUpdateOrderUsingPk = shouldRepairOrder;
            if (!shouldUpdateOrderUsingPk) {
                boolean isCycleFound = false;
                int iCurrentMax = -1;
                Iterator itCurrentIndexes = currentIndexByPreviousIndex.values().iterator();
                while (itCurrentIndexes.hasNext() && !isCycleFound) {
                    iCurrent = (Integer)itCurrentIndexes.next();
                    if (iCurrent > iCurrentMax) {
                        iCurrentMax = iCurrent;
                        continue;
                    }
                    isCycleFound = true;
                }
                shouldUpdateOrderUsingPk = isCycleFound;
            }
            if (shouldUpdateOrderUsingPk) {
                for (Map.Entry entry : previousAndCurrentByKey.entrySet()) {
                    int iCurrent2;
                    int iPrevious;
                    Object key = entry.getKey();
                    Object[] previousAndCurrent2 = (Object[])entry.getValue();
                    Object previousObject = previousAndCurrent2[0];
                    if (previousObject == null) continue;
                    Object currentObject = previousAndCurrent2[1];
                    if (!this.isEntireObjectPK) {
                        this.objectUnchangedDuringUpdate(query, currentObject, previousObject);
                    }
                    if ((iPrevious = ((Integer)previousAndCurrent2[2]).intValue()) == (iCurrent2 = ((Integer)previousAndCurrent2[3]).intValue()) && !shouldRepairOrder) continue;
                    this.objectChangedListOrderDuringUpdate(query, key, iCurrent2);
                }
            } else {
                if (!this.isEntireObjectPK) {
                    for (Map.Entry entry : previousAndCurrentByKey.entrySet()) {
                        previousAndCurrent = (Object[])entry.getValue();
                        Object previousObject = previousAndCurrent[0];
                        if (previousObject == null) continue;
                        Object currentObject = previousAndCurrent[1];
                        this.objectUnchangedDuringUpdate(query, currentObject, previousObject);
                    }
                }
                int iMin = -1;
                int iMax = -1;
                int iShift = 0;
                ArrayList<Integer> iMinList = new ArrayList<Integer>();
                ArrayList<Integer> iMaxList = new ArrayList<Integer>();
                ArrayList<Integer> iShiftList = new ArrayList<Integer>();
                for (Map.Entry entry : currentIndexByPreviousIndex.entrySet()) {
                    int iPrevious = (Integer)entry.getKey();
                    int iCurrent3 = (Integer)entry.getValue();
                    if (iMin >= 0) {
                        int iPreviousExpected = iMax + 1;
                        if (iPrevious == iPreviousExpected && iCurrent3 == iPreviousExpected + iShift) {
                            ++iMax;
                        } else {
                            iMinList.add(iMin);
                            iMaxList.add(iMax);
                            iShiftList.add(iShift);
                            iMin = -1;
                        }
                    }
                    if (iMin != -1) continue;
                    iMin = iPrevious;
                    iMax = iPrevious;
                    iShift = iCurrent3 - iPrevious;
                }
                if (iMin >= 0) {
                    iMinList.add(iMin);
                    iMaxList.add(iMax);
                    iShiftList.add(iShift);
                }
                while (!iMinList.isEmpty()) {
                    int iMinLeft = previousList.size() + 1;
                    int iMinRight = -1;
                    int indexShiftLeft = -1;
                    int indexShiftRight = -1;
                    for (int i2 = 0; i2 < iMinList.size(); ++i2) {
                        iMin = (Integer)iMinList.get(i2);
                        iShift = (Integer)iShiftList.get(i2);
                        if (iShift < 0) {
                            if (iMin >= iMinLeft) continue;
                            iMinLeft = iMin;
                            indexShiftLeft = i2;
                            continue;
                        }
                        if (iMin <= iMinRight) continue;
                        iMinRight = iMin;
                        indexShiftRight = i2;
                    }
                    if (indexShiftLeft >= 0) {
                        this.objectChangedListOrderDuringUpdate(query, (Integer)iMinList.get(indexShiftLeft), (Integer)iMaxList.get(indexShiftLeft), (Integer)iShiftList.get(indexShiftLeft));
                    }
                    if (indexShiftRight >= 0) {
                        this.objectChangedListOrderDuringUpdate(query, (Integer)iMinList.get(indexShiftRight), (Integer)iMaxList.get(indexShiftRight), (Integer)iShiftList.get(indexShiftRight));
                    }
                    if (indexShiftLeft >= 0) {
                        iMinList.remove(indexShiftLeft);
                        iMaxList.remove(indexShiftLeft);
                        iShiftList.remove(indexShiftLeft);
                    }
                    if (indexShiftRight < 0) continue;
                    iMinList.remove(indexShiftRight);
                    iMaxList.remove(indexShiftRight);
                    iShiftList.remove(indexShiftRight);
                }
            }
        }
        for (Map.Entry entry : previousAndCurrentByKey.entrySet()) {
            Object[] previousAndCurrent3 = (Object[])entry.getValue();
            Object previousObject = previousAndCurrent3[0];
            if (previousObject != null) continue;
            Object currentObject = previousAndCurrent3[1];
            int iCurrent4 = (Integer)previousAndCurrent3[3];
            DatabaseRecord extraData = new DatabaseRecord(1);
            extraData.put(this.listOrderField, (Object)iCurrent4);
            this.objectAddedDuringUpdate(query, currentObject, null, extraData);
        }
        if (shouldRepairOrder) {
            ((IndirectList)currentList).setIsListOrderBrokenInDb(false);
        }
    }

    protected int objectChangedListOrderDuringUpdate(WriteObjectQuery query, int iMin, int iMax, int iShift) {
        DataModifyQuery updateQuery;
        AbstractRecord translationRow = query.getTranslationRow().clone();
        translationRow.put(min, (Object)iMin);
        if (iMin == iMax) {
            translationRow.put(this.listOrderField, (Object)(iMin + iShift));
            updateQuery = this.updateListOrderFieldQuery;
        } else {
            translationRow.put(max, (Object)iMax);
            translationRow.put(shift, (Object)iShift);
            updateQuery = this.bulkUpdateListOrderFieldQuery;
        }
        return (Integer)query.getSession().executeQuery((DatabaseQuery)updateQuery, translationRow);
    }

    protected int objectChangedListOrderDuringUpdate(WriteObjectQuery query, Object key, int newOrderValue) {
        AbstractRecord translationRow = query.getTranslationRow().clone();
        translationRow.put(this.listOrderField, (Object)newOrderValue);
        this.getReferenceDescriptor().getObjectBuilder().writeIntoRowFromPrimaryKeyValues(translationRow, key, query.getSession(), true);
        return (Integer)query.getSession().executeQuery((DatabaseQuery)this.pkUpdateListOrderFieldQuery, translationRow);
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        if (this.listOrderField != null) {
            return this.compareLists((List)firstCollection, (List)secondCollection, session);
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        if (containerPolicy.sizeFor(firstCollection) == 0) {
            return true;
        }
        Object iterFirst = containerPolicy.iteratorFor(firstCollection);
        block0: while (containerPolicy.hasNext(iterFirst)) {
            Object firstAggregateObject = containerPolicy.next(iterFirst, session);
            Object iterSecond = containerPolicy.iteratorFor(secondCollection);
            do {
                Object secondAggregateObject = containerPolicy.next(iterSecond, session);
                if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(firstAggregateObject, secondAggregateObject, session)) continue block0;
            } while (containerPolicy.hasNext(iterSecond));
            return false;
        }
        return true;
    }

    public boolean compareLists(List firstList, List secondList, AbstractSession session) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        int size = firstList.size();
        for (int i = 0; i < size; ++i) {
            Object firstObject = firstList.get(i);
            Object secondObject = secondList.get(i);
            if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(firstObject, secondObject, session)) continue;
            return false;
        }
        return true;
    }

    protected ChangeRecord convertToChangeRecord(Object cloneCollection, Object backupCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneIter = cp.iteratorFor(cloneCollection);
        Vector<ObjectChangeSet> collectionChanges = new Vector<ObjectChangeSet>(2);
        while (cp.hasNext(cloneIter)) {
            Object entry = cp.nextEntry(cloneIter, session);
            Object aggregateObject = cp.unwrapIteratorResult(entry);
            if (aggregateObject == null) continue;
            ObjectChangeSet changes = this.getReferenceDescriptor(aggregateObject.getClass(), session).getObjectBuilder().compareForChange(aggregateObject, null, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
            changes.setNewKey(cp.keyFromIterator(cloneIter));
            collectionChanges.addElement(changes);
        }
        AggregateCollectionChangeRecord changeRecord = new AggregateCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setChangedValues(collectionChanges);
        this.getContainerPolicy().compareCollectionsForChange(backupCollection, cloneCollection, changeRecord, session, this.remoteReferenceDescriptor);
        return changeRecord;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.valueFromRow(dbRow, null, query, parentCacheKey, query.getExecutionSession(), isTargetProtected);
    }

    protected void deleteAll(DeleteObjectQuery query, AbstractSession session) throws DatabaseException {
        Object attribute = this.getAttributeValueFromObject(query.getObject());
        if (this.usesIndirection() && !this.indirectionPolicy.objectIsInstantiated(attribute)) {
            ((DeleteAllQuery)this.deleteAllQuery).executeDeleteAll(session.getSessionForClass(this.referenceClass), query.getTranslationRow(), new Vector(0));
            return;
        }
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), session);
        if (session.isUnitOfWork() && this.containerPolicy.isEmpty(referenceObjects)) {
            return;
        }
        ((DeleteAllQuery)this.deleteAllQuery).executeDeleteAll(session.getSessionForClass(this.referenceClass), query.getTranslationRow(), this.containerPolicy.vectorFor(referenceObjects, session));
    }

    protected void executeEvent(int eventCode, ObjectLevelModifyQuery query) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(query.getObject().getClass(), query.getSession());
        if (referenceDescriptor.getEventManager().hasAnyEventListeners()) {
            referenceDescriptor.getEventManager().executeEvent(new DescriptorEvent(eventCode, query));
        }
    }

    @Override
    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        int size = this.targetForeignKeyFields.size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetField = this.targetForeignKeyFields.get(index);
            DatabaseField sourceField = this.sourceKeyFields.get(index);
            Object value = row.get(targetField);
            try {
                value = conversionManager.convertObject(value, sourceField.getType());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key[index] = value;
        }
        return new CacheId(key);
    }

    @Override
    protected Object extractBatchKeyFromRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = this.sourceKeyFields.get(index);
            Object value = row.get(field);
            try {
                value = conversionManager.convertObject(value, field.getType());
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
            key[index] = value;
        }
        return new CacheId(key);
    }

    @Override
    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        int size = this.targetForeignKeyFields.size();
        if (size > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size);
            for (DatabaseField targetForeignKeyField : this.targetForeignKeyFields) {
                fields.add(builder.getField(targetForeignKeyField));
            }
            return builder.value(fields).in(builder.getParameter("query-batch-parameter"));
        }
        return builder.getField(this.targetForeignKeyFields.get(0)).in(builder.getParameter("query-batch-parameter"));
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
        super.postPrepareNestedBatchQuery(batchQuery, query);
        ReadAllQuery aggregateBatchQuery = (ReadAllQuery)batchQuery;
        for (DatabaseField relationField : this.getTargetForeignKeyFields()) {
            aggregateBatchQuery.getAdditionalFields().add(relationField);
        }
    }

    public AbstractRecord getAggregateRow(ObjectLevelModifyQuery query, Object object) {
        Vector referenceObjectKeys = this.getReferenceObjectKeys(query);
        DatabaseRecord aggregateRow = new DatabaseRecord();
        Vector<DatabaseField> keys = this.getTargetForeignKeyFields();
        for (int keyIndex = 0; keyIndex < keys.size(); ++keyIndex) {
            ((AbstractRecord)aggregateRow).put((Object)keys.elementAt(keyIndex), referenceObjectKeys.elementAt(keyIndex));
        }
        this.getReferenceDescriptor(object.getClass(), query.getSession()).getObjectBuilder().buildRow(aggregateRow, object, query.getSession(), DatabaseMapping.WriteType.UNDEFINED);
        return aggregateRow;
    }

    protected Expression getDeleteAllCriteria(AbstractSession session) {
        Expression criteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeyToSourceKeys().get(targetForeignKey);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            criteria = expression.and(criteria);
        }
        return criteria;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            this.referenceDescriptor = this.remoteReferenceDescriptor;
        }
        return this.referenceDescriptor;
    }

    public ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.referenceDescriptor.getJavaClass() == theClass) {
            return this.referenceDescriptor;
        }
        ClassDescriptor subDescriptor = this.referenceDescriptor.getInheritancePolicy().getSubclassDescriptor(theClass);
        if (subDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    public Vector getReferenceObjectKeys(ObjectLevelModifyQuery query) throws DatabaseException, OptimisticLockException {
        Vector<Object> referenceObjectKeys = new Vector<Object>(this.getSourceKeyFields().size());
        AbstractRecord translationRow = query.getTranslationRow();
        Enumeration<DatabaseField> sourcekeys = this.getSourceKeyFields().elements();
        while (sourcekeys.hasMoreElements()) {
            DatabaseField sourceKey = sourcekeys.nextElement();
            Object referenceKey = null;
            referenceKey = translationRow != null && translationRow.containsKey(sourceKey) ? translationRow.get(sourceKey) : this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(query.getObject(), sourceKey, query.getSession());
            referenceObjectKeys.addElement(referenceKey);
        }
        return referenceObjectKeys;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeyToSourceKeys() {
        return this.targetForeignKeyToSourceKeys;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getDescriptor() != null) {
            this.getDescriptor().addMappingsPostCalculateChanges(this);
            if (this.getDescriptor().hasInheritance()) {
                for (ClassDescriptor descriptor : this.getDescriptor().getInheritancePolicy().getAllChildDescriptors()) {
                    descriptor.addMappingsPostCalculateChanges(this);
                }
            }
        }
        if (!this.getReferenceDescriptor().isAggregateCollectionDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(this.getReferenceClass().getName(), this));
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.isSourceKeySpecified()) {
                this.initializeTargetForeignKeyToSourceKeys(session);
            } else {
                this.initializeTargetForeignKeyToSourceKeysWithDefaults(session);
            }
            this.initializeSelectionCriteria(session);
            this.getContainerPolicy().addAdditionalFieldsToQuery(this.getSelectionQuery(), this.getAdditionalFieldsBaseExpression(this.getSelectionQuery()));
        }
        this.getSelectionQuery().setShouldMaintainCache(false);
        for (DatabaseField relationField : this.getTargetForeignKeyFields()) {
            ((ReadAllQuery)this.getSelectionQuery()).getAdditionalFields().add(relationField);
        }
        this.initializeDeleteAllQuery(session);
        if (this.listOrderField != null) {
            this.initializeUpdateListOrderQuery(session, "");
            this.initializeUpdateListOrderQuery(session, bulk);
            this.initializeUpdateListOrderQuery(session, pk);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getTables().size() > 1) {
            DatabaseTable firstTable = this.getDescriptor().getTables().get(0);
            for (DatabaseField field : this.getSourceKeyFields()) {
                if (field.getTable().equals(firstTable)) continue;
                this.getDescriptor().setHasMultipleTableConstraintDependecy(true);
            }
        }
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession session) throws DescriptorException {
        List<DatabaseField> identityFields;
        super.initializeReferenceDescriptor(session);
        HashMap<DatabaseField, DatabaseField> fieldTranslation = null;
        HashMap<DatabaseTable, DatabaseTable> tableTranslation = null;
        int nAggregateTables = 0;
        if (this.getReferenceDescriptor().getTables() != null) {
            nAggregateTables = this.getReferenceDescriptor().getTables().size();
        }
        if (!this.aggregateToSourceFields.isEmpty()) {
            DatabaseTable aggregateDefaultTable = null;
            aggregateDefaultTable = nAggregateTables != 0 ? this.getReferenceDescriptor().getTables().get(0) : new DatabaseTable();
            tableTranslation = new HashMap<DatabaseTable, DatabaseTable>();
            fieldTranslation = new HashMap<DatabaseField, DatabaseField>();
            for (Map.Entry<String, DatabaseField> entry : this.aggregateToSourceFields.entrySet()) {
                DatabaseField sourceField;
                DatabaseField aggregateField = new DatabaseField(entry.getKey());
                if (!aggregateField.hasTableName()) {
                    aggregateField.setTable(aggregateDefaultTable);
                }
                if (!(sourceField = entry.getValue()).hasTableName()) {
                    // empty if block
                }
                DatabaseTable sourceTable = sourceField.getTable();
                DatabaseTable savedSourceTable = tableTranslation.get(aggregateField.getTable());
                if (savedSourceTable == null) {
                    tableTranslation.put(aggregateField.getTable(), sourceTable);
                } else if (!sourceTable.equals(savedSourceTable)) {
                    // empty if block
                }
                fieldTranslation.put(aggregateField, sourceField);
            }
        } else if (nAggregateTables == 0) {
            // empty if block
        }
        ClassDescriptor clonedDescriptor = (ClassDescriptor)this.getReferenceDescriptor().clone();
        if (fieldTranslation != null) {
            AggregateCollectionMapping.translateTablesAndFields(clonedDescriptor, fieldTranslation, tableTranslation);
        }
        this.updateNestedAggregateMappings(clonedDescriptor, session);
        if (clonedDescriptor.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = session.getDescriptor(clonedDescriptor.getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(parentDescriptor, clonedDescriptor, session, fieldTranslation, tableTranslation);
        }
        if (clonedDescriptor.isAggregateDescriptor()) {
            clonedDescriptor.descriptorIsAggregateCollection();
        }
        this.setReferenceDescriptor(clonedDescriptor);
        clonedDescriptor.preInitialize(session);
        this.getContainerPolicy().initialize(session, clonedDescriptor.getDefaultTable());
        if (clonedDescriptor.getPrimaryKeyFields().isEmpty()) {
            this.isEntireObjectPK = true;
            clonedDescriptor.getAdditionalAggregateCollectionKeyFields().addAll(this.getTargetForeignKeyFields());
            if (this.listOrderField != null && !this.isListOrderFieldUpdatable) {
                clonedDescriptor.getAdditionalAggregateCollectionKeyFields().add(this.listOrderField);
            }
        }
        if ((identityFields = this.getContainerPolicy().getIdentityFieldsForMapKey()) != null) {
            clonedDescriptor.getAdditionalAggregateCollectionKeyFields().addAll(identityFields);
        }
        clonedDescriptor.initialize(session);
        if (clonedDescriptor.hasInheritance() && clonedDescriptor.getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance(clonedDescriptor, session, fieldTranslation, tableTranslation);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeUpdateListOrderQuery(AbstractSession session, String queryType) {
        DataModifyQuery query = new DataModifyQuery();
        if (queryType == pk) {
            this.pkUpdateListOrderFieldQuery = query;
        } else if (queryType == bulk) {
            this.bulkUpdateListOrderFieldQuery = query;
        } else {
            this.updateListOrderFieldQuery = query;
        }
        query.setSessionName(session.getName());
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        DatabaseRecord modifyRow = new DatabaseRecord();
        if (queryType == pk) {
            for (DatabaseField databaseField : this.getReferenceDescriptor().getPrimaryKeyFields()) {
                DatabaseField sourceField = this.targetForeignKeyToSourceKeys.get(databaseField);
                DatabaseField parameterField = sourceField != null ? sourceField : databaseField;
                Expression expression = ((Expression)builder).getField(databaseField).equal(builder.getParameter(parameterField));
                whereClause = expression.and(whereClause);
            }
            modifyRow.add(this.listOrderField, null);
        } else {
            void var8_12;
            for (Map.Entry entry : this.targetForeignKeyToSourceKeys.entrySet()) {
                Expression expression = ((Expression)builder).getField((DatabaseField)entry.getKey()).equal(builder.getParameter((DatabaseField)entry.getValue()));
                whereClause = expression.and(whereClause);
            }
            if (queryType == bulk) {
                Expression expression = ((Expression)builder).getField(this.listOrderField).between(builder.getParameter(min), builder.getParameter(max));
                modifyRow.add(this.listOrderField, ExpressionMath.add(((Expression)builder).getField(this.listOrderField), builder.getParameter(shift)));
            } else {
                Expression expression = ((Expression)builder).getField(this.listOrderField).equal(builder.getParameter(min));
                modifyRow.add(this.listOrderField, null);
            }
            whereClause = var8_12.and(whereClause);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(this.getReferenceDescriptor().getDefaultTable());
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        query.setSQLStatement(statement);
    }

    @Override
    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinManager, ObjectBuildingQuery baseQuery, AbstractSession session) {
        ObjectLevelReadQuery nestedQuery = super.prepareNestedJoins(joinManager, baseQuery, session);
        nestedQuery.setShouldMaintainCache(false);
        return nestedQuery;
    }

    protected static void translateTablesAndFields(ClassDescriptor descriptor, HashMap<DatabaseField, DatabaseField> fieldTranslation, HashMap<DatabaseTable, DatabaseTable> tableTranslation) {
        int nTables = 0;
        if (descriptor.getTables() != null) {
            nTables = descriptor.getTables().size();
        }
        DatabaseTable defaultAggregateTable = null;
        if (nTables == 0) {
            defaultAggregateTable = new DatabaseTable();
            DatabaseTable defaultSourceTable = tableTranslation.get(defaultAggregateTable);
            if (defaultSourceTable == null) {
                // empty if block
            }
            descriptor.addTable(defaultSourceTable);
        } else {
            defaultAggregateTable = descriptor.getTables().get(0);
            NonSynchronizedVector newTables = NonSynchronizedVector.newInstance(nTables);
            for (int i = 0; i < nTables; ++i) {
                DatabaseTable table = tableTranslation.get(descriptor.getTables().get(i));
                if (table == null) {
                    // empty if block
                }
                if (newTables.contains(table)) continue;
                ((Vector)newTables).add(table);
            }
            descriptor.setTables(newTables);
        }
        int nPrimaryKeyFields = 0;
        if (descriptor.getPrimaryKeyFields() != null) {
            nPrimaryKeyFields = descriptor.getPrimaryKeyFields().size();
        }
        if (nPrimaryKeyFields > 0) {
            ArrayList<DatabaseField> newPrimaryKeyFields = new ArrayList<DatabaseField>(nPrimaryKeyFields);
            for (int i = 0; i < nPrimaryKeyFields; ++i) {
                DatabaseField field;
                DatabaseField pkField = descriptor.getPrimaryKeyFields().get(i);
                if (!pkField.hasTableName() && nTables > 0) {
                    pkField = new DatabaseField(pkField.getName(), defaultAggregateTable);
                }
                if ((field = fieldTranslation.get(pkField)) == null) {
                    // empty if block
                }
                newPrimaryKeyFields.add(field);
            }
            descriptor.setPrimaryKeyFields(newPrimaryKeyFields);
        }
        descriptor.getObjectBuilder().getFieldsMap().putAll(fieldTranslation);
    }

    protected void updateNestedAggregateMappings(ClassDescriptor descriptor, AbstractSession session) {
        if (!this.nestedAggregateToSourceFields.isEmpty()) {
            for (Map.Entry<String, Map<String, DatabaseField>> entry : this.nestedAggregateToSourceFields.entrySet()) {
                DatabaseMapping mapping;
                String attribute = entry.getKey();
                String nestedAttribute = null;
                int indexOfDot = attribute.indexOf(46);
                if (indexOfDot >= 0) {
                    nestedAttribute = attribute.substring(indexOfDot + 1, attribute.length());
                    attribute = attribute.substring(0, indexOfDot);
                }
                if ((mapping = descriptor.getMappingForAttributeName(attribute)) == null) continue;
                if (mapping.isAggregateCollectionMapping()) {
                    AggregateCollectionMapping nestedAggregateCollectionMapping = (AggregateCollectionMapping)mapping;
                    if (nestedAttribute == null) {
                        nestedAggregateCollectionMapping.addFieldTranslations(entry.getValue());
                        continue;
                    }
                    nestedAggregateCollectionMapping.addNestedFieldNameTranslations(nestedAttribute, entry.getValue());
                    continue;
                }
                if (!mapping.isAggregateObjectMapping()) continue;
                AggregateObjectMapping nestedAggregateObjectMapping = (AggregateObjectMapping)mapping;
                Map<String, DatabaseField> entries = entry.getValue();
                for (String aggregateFieldName : entries.keySet()) {
                    DatabaseField sourceField = entries.get(aggregateFieldName);
                    nestedAggregateObjectMapping.addFieldTranslation(sourceField, aggregateFieldName);
                }
            }
        }
    }

    public void initializeChildInheritance(ClassDescriptor parentDescriptor, AbstractSession session, HashMap<DatabaseField, DatabaseField> fieldTranslation, HashMap<DatabaseTable, DatabaseTable> tableTranslation) throws DescriptorException {
        if (parentDescriptor.getInheritancePolicy().hasChildren()) {
            List<ClassDescriptor> childDescriptors = parentDescriptor.getInheritancePolicy().getChildDescriptors();
            ArrayList<ClassDescriptor> cloneChildDescriptors = new ArrayList<ClassDescriptor>(childDescriptors.size());
            for (ClassDescriptor childDescriptor : childDescriptors) {
                ClassDescriptor clonedChildDescriptor = (ClassDescriptor)childDescriptor.clone();
                if (fieldTranslation != null) {
                    AggregateCollectionMapping.translateTablesAndFields(clonedChildDescriptor, fieldTranslation, tableTranslation);
                }
                this.updateNestedAggregateMappings(clonedChildDescriptor, session);
                if (clonedChildDescriptor.isAggregateDescriptor()) {
                    clonedChildDescriptor.descriptorIsAggregateCollection();
                }
                if (!clonedChildDescriptor.isAggregateCollectionDescriptor()) {
                    session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(clonedChildDescriptor.getJavaClass().getName(), this));
                }
                clonedChildDescriptor.getInheritancePolicy().setParentDescriptor(parentDescriptor);
                clonedChildDescriptor.preInitialize(session);
                clonedChildDescriptor.initialize(session);
                cloneChildDescriptors.add(clonedChildDescriptor);
                this.initializeChildInheritance(clonedChildDescriptor, session, fieldTranslation, tableTranslation);
            }
            parentDescriptor.getInheritancePolicy().setChildDescriptors(cloneChildDescriptors);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        DeleteAllQuery query = (DeleteAllQuery)this.getDeleteAllQuery();
        query.setReferenceClass(this.getReferenceClass());
        query.setDescriptor(this.getReferenceDescriptor());
        query.setShouldMaintainCache(false);
        query.setIsInMemoryOnly(this.isCascadeOnDeleteSetOnDatabase());
        if (query.getPartitioningPolicy() == null) {
            query.setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                query.setSelectionCriteria(this.getDeleteAllCriteria(session));
            } else {
                query.setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    public void initializeParentInheritance(ClassDescriptor parentDescriptor, ClassDescriptor childDescriptor, AbstractSession session, HashMap<DatabaseField, DatabaseField> fieldTranslation, HashMap<DatabaseTable, DatabaseTable> tableTranslation) throws DescriptorException {
        ClassDescriptor clonedParentDescriptor = (ClassDescriptor)parentDescriptor.clone();
        if (clonedParentDescriptor.isAggregateDescriptor()) {
            clonedParentDescriptor.descriptorIsAggregateCollection();
        }
        if (!clonedParentDescriptor.isAggregateCollectionDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(parentDescriptor.getJavaClass().getName(), this));
        }
        if (fieldTranslation != null) {
            AggregateCollectionMapping.translateTablesAndFields(clonedParentDescriptor, fieldTranslation, tableTranslation);
        }
        this.updateNestedAggregateMappings(clonedParentDescriptor, session);
        if (clonedParentDescriptor.getInheritancePolicy().isChildDescriptor()) {
            ClassDescriptor parentToParentDescriptor = session.getDescriptor(clonedParentDescriptor.getJavaClass());
            this.initializeParentInheritance(parentToParentDescriptor, parentDescriptor, session, fieldTranslation, tableTranslation);
        }
        NonSynchronizedVector children = NonSynchronizedVector.newInstance(1);
        ((Vector)children).addElement(childDescriptor);
        clonedParentDescriptor.getInheritancePolicy().setChildDescriptors(children);
        clonedParentDescriptor.preInitialize(session);
        clonedParentDescriptor.initialize(session);
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeyToSourceKeys().get(targetForeignKey);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            Expression criteria = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(criteria);
        }
    }

    protected void initializeTargetForeignKeyToSourceKeys(AbstractSession session) throws DescriptorException {
        int index;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            DatabaseField foreignKeyfield = this.getTargetForeignKeyFields().get(index);
            foreignKeyfield = this.getReferenceDescriptor().buildField(foreignKeyfield);
            this.getTargetForeignKeyFields().set(index, foreignKeyfield);
        }
        for (index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField sourceKeyfield = this.getSourceKeyFields().get(index);
            sourceKeyfield = this.getDescriptor().buildField(sourceKeyfield);
            this.getSourceKeyFields().set(index, sourceKeyfield);
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        Iterator<DatabaseField> targetForeignKeysEnum = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> sourceKeysEnum = this.getSourceKeyFields().iterator();
        while (targetForeignKeysEnum.hasNext()) {
            this.getTargetForeignKeyToSourceKeys().put(targetForeignKeysEnum.next(), sourceKeysEnum.next());
        }
    }

    protected void initializeTargetForeignKeyToSourceKeysWithDefaults(AbstractSession session) throws DescriptorException {
        int index;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        List<DatabaseField> sourceKeys = this.getDescriptor().getPrimaryKeyFields();
        this.setSourceKeyFields(NonSynchronizedVector.newInstance(sourceKeys));
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            DatabaseField foreignKeyfield = this.getTargetForeignKeyFields().get(index);
            foreignKeyfield = this.getReferenceDescriptor().buildField(foreignKeyfield);
            this.getTargetForeignKeyFields().set(index, foreignKeyfield);
        }
        if (this.getTargetForeignKeyFields().size() != sourceKeys.size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            this.getTargetForeignKeyToSourceKeys().put(this.getTargetForeignKeyFields().get(index), sourceKeys.get(index));
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        if (element != null) {
            iterator.iterateForAggregateMapping(element, this, this.getReferenceDescriptor(element.getClass(), iterator.getSession()));
        }
    }

    @Override
    public boolean isAggregateCollectionMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean isOwned() {
        return true;
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.descriptor.isProtectedIsolation()) {
            if (!this.isCacheable && !targetSession.isProtectedSession()) {
                this.setRealAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            }
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(target)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object valueOfTarget = null;
        Object sourceAggregate = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            ClassDescriptor descriptor = this.getDescriptor();
            AbstractRecord parentRow = descriptor.getObjectBuilder().extractPrimaryKeyRowFromObject(target, session);
            Object result = this.getIndirectionPolicy().valueFromQuery(this.getSelectionQuery(), parentRow, session);
            this.setAttributeValueInObject(target, result);
            return;
        }
        Vector aggregateObjects = ((AggregateCollectionChangeRecord)changeRecord).getChangedValues();
        int size = aggregateObjects.size();
        valueOfTarget = containerPolicy.containerInstance(size);
        ObjectChangeSet objectChanges = null;
        for (int index = 0; index < size; ++index) {
            objectChanges = (ObjectChangeSet)aggregateObjects.elementAt(index);
            Class localClassType = objectChanges.getClassType(session);
            sourceAggregate = objectChanges.getUnitOfWorkClone();
            Object targetAggregate = ((UnitOfWorkImpl)mergeManager.getSession()).getCloneToOriginals().get(sourceAggregate);
            if (targetAggregate == null) {
                targetAggregate = this.getReferenceDescriptor(localClassType, session).getObjectBuilder().buildNewInstance();
            }
            this.getReferenceDescriptor(localClassType, session).getObjectBuilder().mergeChangesIntoObject(targetAggregate, objectChanges, sourceAggregate, mergeManager, targetSession);
            containerPolicy.addInto(objectChanges.getNewKey(), targetAggregate, valueOfTarget, session);
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.descriptor.isProtectedIsolation()) {
            if (!this.isCacheable && !targetSession.isProtectedSession()) {
                this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            }
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiatedOrChanged(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), targetSession));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiatedOrChanged(target) : !this.isAttributeValueInstantiatedOrChanged(source)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object wrappedSourceValue = containerPolicy.nextEntry(sourceValuesIterator, mergeManager.getSession());
            Object sourceValue = containerPolicy.unwrapIteratorResult(wrappedSourceValue);
            Object originalValue = null;
            if (sourceValue == null) continue;
            originalValue = this.getReferenceDescriptor(sourceValue.getClass(), mergeManager.getSession()).getObjectBuilder().buildNewInstance();
            this.getReferenceDescriptor(sourceValue.getClass(), mergeManager.getSession()).getObjectBuilder().mergeIntoObject(originalValue, true, sourceValue, mergeManager, targetSession);
            containerPolicy.addInto(containerPolicy.keyFromIterator(sourceValuesIterator), originalValue, valueOfTarget, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet, Map extraData) throws DatabaseException, OptimisticLockException {
        InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, objectAdded);
        ContainerPolicy.copyMapDataToRow(extraData, insertQuery.getModifyRow());
        if (this.listOrderField != null && extraData != null) {
            insertQuery.getModifyRow().put(this.listOrderField, extraData.get(this.listOrderField));
        }
        query.getSession().executeQuery((DatabaseQuery)insertQuery, insertQuery.getTranslationRow());
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted, Map extraData) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setIsExecutionClone(true);
        this.prepareModifyQueryForDelete(query, deleteQuery, objectDeleted, extraData);
        ContainerPolicy.copyMapDataToRow(extraData, deleteQuery.getTranslationRow());
        query.getSession().executeQuery((DatabaseQuery)deleteQuery, deleteQuery.getTranslationRow());
        if (this.containerPolicy.shouldIncludeKeyInDeleteEvent()) {
            query.getSession().deleteObject(this.containerPolicy.keyFromEntry(objectDeleted));
        }
    }

    @Override
    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Map backupCloneKeyedCache, Object cachedKey) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        updateQuery.setIsExecutionClone(true);
        Object backupclone = backupCloneKeyedCache.get(cachedKey);
        updateQuery.setBackupClone(backupclone);
        this.prepareModifyQueryForUpdate(query, updateQuery, object);
        query.getSession().executeQuery((DatabaseQuery)updateQuery, updateQuery.getTranslationRow());
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Object backupClone) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        updateQuery.setIsExecutionClone(true);
        updateQuery.setBackupClone(backupClone);
        this.prepareModifyQueryForUpdate(query, updateQuery, object);
        query.getSession().executeQuery((DatabaseQuery)updateQuery, updateQuery.getTranslationRow());
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        super.postInitialize(session);
        if (this.getReferenceDescriptor() != null) {
            if (this.getDescriptor().getObjectChangePolicy().getClass().equals(DeferredChangeDetectionPolicy.class)) {
                this.getReferenceDescriptor().setObjectChangePolicy(new DeferredChangeDetectionPolicy());
            } else if (this.getDescriptor().getObjectChangePolicy().getClass().equals(ObjectChangeTrackingPolicy.class) && this.getReferenceDescriptor().getObjectChangePolicy().getClass().equals(AttributeChangeTrackingPolicy.class)) {
                this.getReferenceDescriptor().setObjectChangePolicy(new ObjectChangeTrackingPolicy());
            }
            this.getReferenceDescriptor().postInitialize(session);
        }
        for (int index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField foreignKey = this.getSourceKeyFields().get(index);
            DatabaseField targetKey = this.getTargetForeignKeyFields().get(index);
            if (targetKey.getType() != null) continue;
            targetKey.setType(this.getDescriptor().getObjectBuilder().getFieldClassification(foreignKey));
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        int index = 0;
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, query.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, object);
            ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession()), insertQuery.getModifyRow());
            if (this.listOrderField != null) {
                insertQuery.getModifyRow().add(this.listOrderField, index++);
            }
            query.getSession().executeQuery((DatabaseQuery)insertQuery, insertQuery.getTranslationRow());
            cp.propogatePostInsert(query, wrappedObject);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(writeQuery.getObject(), writeQuery.getSession());
        Object currentObjectsInDB = this.readPrivateOwnedForObject(writeQuery);
        if (currentObjectsInDB == null) {
            currentObjectsInDB = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(currentObjectsInDB, objects, writeQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        AbstractSession session = query.getSession();
        int index = 0;
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object wrappedObject;
            Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
            ContainerPolicy cp = this.getContainerPolicy();
            if (this.isCascadeOnDeleteSetOnDatabase && session.isUnitOfWork()) {
                Object iterator = cp.iteratorFor(objects);
                while (cp.hasNext(iterator)) {
                    wrappedObject = cp.nextEntry(iterator, session);
                    Object object = cp.unwrapIteratorResult(wrappedObject);
                    ((UnitOfWorkImpl)session).getCascadeDeleteObjects().add(object);
                }
            }
            Object iter = cp.iteratorFor(objects);
            while (cp.hasNext(iter)) {
                wrappedObject = cp.nextEntry(iter, session);
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                DatabaseRecord extraData = null;
                if (this.listOrderField != null) {
                    extraData = new DatabaseRecord(1);
                    extraData.put(this.listOrderField, index++);
                }
                this.prepareModifyQueryForDelete(query, deleteQuery, wrappedObject, extraData);
                session.executeQuery((DatabaseQuery)deleteQuery, deleteQuery.getTranslationRow());
                cp.propogatePreDelete(query, wrappedObject);
            }
            if (!session.isUnitOfWork()) {
                this.verifyDeleteForUpdate(query);
            }
        } else {
            this.deleteAll(query, session);
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        int index = 0;
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, query.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, object);
            ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession()), insertQuery.getModifyRow());
            if (this.listOrderField != null) {
                insertQuery.getModifyRow().add(this.listOrderField, index++);
            }
            this.executeEvent(0, insertQuery);
            this.executeEvent(4, insertQuery);
            this.getReferenceDescriptor(object.getClass(), query.getSession()).getQueryManager().preInsert(insertQuery);
            cp.propogatePreInsert(query, wrappedObject);
        }
    }

    protected InsertObjectQuery getInsertObjectQuery(AbstractSession session, ClassDescriptor desc) {
        InsertObjectQuery insertQuery = desc.getQueryManager().getInsertQuery();
        if (insertQuery == null) {
            insertQuery = new InsertObjectQuery();
            desc.getQueryManager().setInsertQuery(insertQuery);
        }
        if (insertQuery.getModifyRow() == null) {
            DatabaseRecord modifyRow = new DatabaseRecord();
            for (int i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
                DatabaseField field = this.getTargetForeignKeyFields().elementAt(i);
                modifyRow.put(field, (Object)null);
            }
            desc.getObjectBuilder().buildTemplateInsertRow(session, modifyRow);
            this.getContainerPolicy().addFieldsForMapKey(modifyRow);
            if (this.listOrderField != null) {
                modifyRow.put(this.listOrderField, (Object)null);
            }
            insertQuery.setModifyRow(modifyRow);
        }
        return insertQuery;
    }

    public InsertObjectQuery getAndPrepareModifyQueryForInsert(ObjectLevelModifyQuery originalQuery, Object object) {
        AbstractSession session = originalQuery.getSession();
        ClassDescriptor objReferenceDescriptor = this.getReferenceDescriptor(object.getClass(), session);
        InsertObjectQuery insertQueryFromDescriptor = this.getInsertObjectQuery(session, objReferenceDescriptor);
        insertQueryFromDescriptor.checkPrepare(session, insertQueryFromDescriptor.getModifyRow());
        InsertObjectQuery insertQuery = (InsertObjectQuery)insertQueryFromDescriptor.clone();
        insertQuery.setObject(object);
        insertQuery.setDescriptor(objReferenceDescriptor);
        DatabaseRecord targetForeignKeyRow = new DatabaseRecord();
        Vector referenceObjectKeys = this.getReferenceObjectKeys(originalQuery);
        for (int keyIndex = 0; keyIndex < this.getTargetForeignKeyFields().size(); ++keyIndex) {
            targetForeignKeyRow.put(this.getTargetForeignKeyFields().elementAt(keyIndex), referenceObjectKeys.elementAt(keyIndex));
        }
        insertQuery.setModifyRow(targetForeignKeyRow);
        insertQuery.setTranslationRow(targetForeignKeyRow);
        insertQuery.setSession(session);
        insertQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        insertQuery.dontMaintainCache();
        if (session.isUnitOfWork()) {
            Object backupAttributeValue = this.getReferenceDescriptor(object.getClass(), session).getObjectBuilder().buildNewInstance();
            insertQuery.setBackupClone(backupAttributeValue);
        }
        return insertQuery;
    }

    public void prepareModifyQueryForDelete(ObjectLevelModifyQuery originalQuery, ObjectLevelModifyQuery modifyQuery, Object wrappedObject, Map extraData) {
        Object object = this.getContainerPolicy().unwrapIteratorResult(wrappedObject);
        AbstractRecord aggregateRow = this.getAggregateRow(originalQuery, object);
        ContainerPolicy.copyMapDataToRow(this.containerPolicy.getKeyMappingDataForWriteQuery(wrappedObject, modifyQuery.getSession()), aggregateRow);
        if (this.listOrderField != null && extraData != null) {
            aggregateRow.put(this.listOrderField, extraData.get(this.listOrderField));
        }
        modifyQuery.setObject(object);
        modifyQuery.setDescriptor(this.getReferenceDescriptor(object.getClass(), originalQuery.getSession()));
        modifyQuery.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(aggregateRow, originalQuery.getSession()));
        modifyQuery.setModifyRow(aggregateRow);
        modifyQuery.setTranslationRow(aggregateRow);
        modifyQuery.setSession(originalQuery.getSession());
        if (originalQuery.shouldCascadeOnlyDependentParts()) {
            modifyQuery.setCascadePolicy(5);
        } else {
            modifyQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        }
        modifyQuery.dontMaintainCache();
    }

    public void prepareModifyQueryForUpdate(ObjectLevelModifyQuery originalQuery, ObjectLevelModifyQuery modifyQuery, Object object) {
        AbstractRecord aggregateRow = this.getAggregateRow(originalQuery, object);
        modifyQuery.setObject(object);
        modifyQuery.setDescriptor(this.getReferenceDescriptor(object.getClass(), originalQuery.getSession()));
        modifyQuery.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(aggregateRow, originalQuery.getSession()));
        modifyQuery.setTranslationRow(aggregateRow);
        modifyQuery.setSession(originalQuery.getSession());
        modifyQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        modifyQuery.dontMaintainCache();
    }

    @Override
    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.remoteReferenceDescriptor = this.referenceDescriptor = aDescriptor;
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setTargetForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetForeignKeyFields(fields);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> targetForeignKeyFields) {
        this.targetForeignKeyFields = targetForeignKeyFields;
    }

    protected void setTargetForeignKeyToSourceKeys(Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys) {
        this.targetForeignKeyToSourceKeys = targetForeignKeyToSourceKeys;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        return !this.isReadOnly();
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        AggregateCollectionChangeRecord collectionChangeRecord = (AggregateCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(cloneCollection, this.containerPolicy.containerInstance(), changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            collectionChangeRecord.getChangedValues().add(changeSetToAdd);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        AggregateCollectionChangeRecord collectionChangeRecord = (AggregateCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(cloneCollection, this.containerPolicy.containerInstance(), changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            collectionChangeRecord.getChangedValues().remove(changeSetToRemove);
        }
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    @Override
    public boolean isCandidateForPrivateOwnedRemoval() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return false;
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        super.remoteInitialization(session);
        this.getReferenceDescriptor().remoteInitialization(session);
    }

    public boolean isListOrderFieldUpdatable() {
        return this.isListOrderFieldUpdatable;
    }

    public void setIsListOrderFieldUpdatable(boolean isUpdatable) {
        this.isListOrderFieldUpdatable = isUpdatable;
    }
}

