/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.ReplicationPartitioningPolicy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinPartitioningPolicy
extends ReplicationPartitioningPolicy {
    protected volatile int currentIndex = 0;
    protected boolean replicateWrites = false;

    public RoundRobinPartitioningPolicy() {
    }

    public RoundRobinPartitioningPolicy(boolean replicateWrites) {
        this.replicateWrites = replicateWrites;
    }

    public RoundRobinPartitioningPolicy(String ... pools) {
        super(pools);
    }

    public RoundRobinPartitioningPolicy(List<String> pools) {
        super(pools);
    }

    public boolean getReplicateWrites() {
        return this.replicateWrites;
    }

    public void setReplicateWrites(boolean replicateWrites) {
        this.replicateWrites = replicateWrites;
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        if (this.replicateWrites && query.isModifyQuery()) {
            return super.getConnectionsForQuery(session, query, arguments);
        }
        ArrayList<Accessor> accessors = new ArrayList<Accessor>(1);
        if (session.isClientSession()) {
            ClientSession client = (ClientSession)session;
            if (client.hasWriteConnection() && (session.isExclusiveIsolatedClientSession() || session.isInTransaction())) {
                accessors.add(client.getWriteConnection());
                return accessors;
            }
            Accessor accessor = this.nextAccessor((ServerSession)session.getParent(), query);
            accessors.add(accessor);
            if (session.isExclusiveIsolatedClientSession() || session.isInTransaction()) {
                ((ClientSession)session).addWriteConnection(accessor.getPool().getName(), accessor);
            }
        } else if (session.isServerSession()) {
            Accessor accessor = this.nextAccessor((ServerSession)session, query);
            accessors.add(accessor);
        } else {
            throw QueryException.partitioningNotSupported(session, query);
        }
        return accessors;
    }

    public int nextIndex() {
        int index;
        if ((index = ++this.currentIndex) >= this.connectionPools.size()) {
            this.currentIndex = 0;
            index = 0;
        }
        return index;
    }

    public Accessor nextAccessor(ServerSession session, DatabaseQuery query) {
        int index = this.nextIndex();
        String poolName = (String)this.connectionPools.get(index);
        return this.acquireAccessor(poolName, session, query);
    }
}

