/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.quicksearch;

import org.netbeans.modules.jumpto.quicksearch.GoToTypeWorker;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.filesystems.FileObject;

public class JavaTypeSearchProvider
implements SearchProvider {
    private GoToTypeWorker worker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        GoToTypeWorker local;
        String text = JavaTypeSearchProvider.removeNonJavaChars(request.getText());
        if (text.length() == 0) {
            return;
        }
        JavaTypeSearchProvider javaTypeSearchProvider = this;
        synchronized (javaTypeSearchProvider) {
            if (this.worker != null) {
                this.worker.cancel();
            }
            local = this.worker = new GoToTypeWorker(text);
        }
        local.run();
        for (TypeDescriptor typeDescriptor : local.getTypes()) {
            String displayHint;
            FileObject fo = typeDescriptor.getFileObject();
            String string = displayHint = fo == null ? null : fo.getPath();
            String htmlDisplayName = typeDescriptor.getSimpleName() + typeDescriptor.getContextName();
            if (response.addResult((Runnable)new GoToTypeCommand(typeDescriptor), htmlDisplayName, displayHint, null)) continue;
            break;
        }
    }

    private static String removeNonJavaChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static class GoToTypeCommand
    implements Runnable {
        private TypeDescriptor command;

        public GoToTypeCommand(TypeDescriptor command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.command.open();
        }
    }
}

