/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.awt.Image;
import java.io.File;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.CallStackUISupport;
import org.netbeans.modules.dlight.core.stack.ui.FunctionCallNode;
import org.netbeans.modules.dlight.core.stack.ui.GoToSourceAction;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class PlainListFunctionCallNode
extends AbstractNode
implements GoToSourceAction.GoToSourceActionReadnessListener {
    private final FunctionCall functionCall;
    private final GoToSourceAction action;
    private String plainDisplayName = null;
    private String htmlDisplayName = null;
    private String functionName = null;
    private final boolean useHtmlFormat;

    PlainListFunctionCallNode(SourceFileInfoDataProvider sourceFileInfoDataProvider, FunctionCall functionCall, boolean useHMTL) {
        super(Children.LEAF);
        this.functionCall = functionCall;
        this.useHtmlFormat = useHMTL;
        this.action = new GoToSourceAction(sourceFileInfoDataProvider, functionCall, this);
        this.updateNames();
    }

    public Image getIcon(int type) {
        return ImageUtilities.mergeImages((Image)CallStackUISupport.functionIcon, (Image)CallStackUISupport.upBadge, (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this.action};
    }

    public Action getPreferredAction() {
        return this.action;
    }

    public synchronized String getDisplayName() {
        return this.useHtmlFormat ? this.htmlDisplayName : this.plainDisplayName;
    }

    public synchronized String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    private String toHtml(String plain) {
        plain = plain.replace("&", "&amp;");
        plain = plain.replace("<", "&lt;");
        plain = plain.replace(">", "&gt;");
        plain = plain.replace(" ", "&nbsp;");
        return plain;
    }

    private synchronized void updateNames() {
        int idx2;
        String funcName;
        this.plainDisplayName = this.functionCall.getDisplayedName();
        String name = FunctionNameUtils.getFunctionName(this.functionCall.getFunction().getName());
        int idx1 = name.indexOf(funcName = this.functionCall.getFunction().getQuilifiedName());
        if (idx1 < 0) {
            DLightLogger.getLogger(PlainListFunctionCallNode.class).log(Level.FINE, "Attention::::StringIndexOutOfBoundsException will  occurr as idx1=-1name={0} funcName={1}", new Object[]{name, funcName});
        }
        if ((idx2 = funcName.lastIndexOf(58)) > 0) {
            idx1 += idx2 + 1;
            funcName = funcName.substring(idx2 + 1);
        }
        this.functionName = funcName;
        String prefix = name.substring(0, idx1);
        String suffix = name.substring(idx1 + funcName.length());
        prefix = this.toHtml(prefix);
        funcName = this.toHtml(funcName);
        suffix = this.toHtml(suffix);
        funcName = "<b>" + funcName + "</b>";
        String dispName = prefix + funcName + suffix + "&nbsp;";
        StringBuilder result = new StringBuilder("<html>");
        String infoSuffix = null;
        if (this.action != null && this.action.isEnabled()) {
            result.append("<font color='#000000'>").append(dispName).append("</font>");
            SourceFileInfoProvider.SourceFileInfo sourceInfo = this.action.getSource();
            if (sourceInfo != null && sourceInfo.isSourceKnown()) {
                String fname = new File(sourceInfo.getFileName()).getName();
                int line = sourceInfo.getLine();
                String infoPrefix = line > 0 ? PlainListFunctionCallNode.getMessage("FunctionCallNode.prefix.withLine") : PlainListFunctionCallNode.getMessage("FunctionCallNode.prefix.withoutLine");
                infoSuffix = infoPrefix + "&nbsp;" + fname + (line > 0 ? ":" + line : "");
                result.append("<font color='#808080'>").append(infoSuffix).append("</font>");
            }
        } else {
            result.append("<font color='#808080'>").append(dispName).append("</font>");
        }
        result.append("</html>");
        this.htmlDisplayName = result.toString();
    }

    @Override
    public void ready() {
        this.updateNames();
        this.fireDisplayNameChange(this.getDisplayName() + "_", this.getDisplayName());
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(FunctionCallNode.class, (String)key);
    }
}

