/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanel;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanelFactory;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private ToolBarDesignEditor comp;
    private PersistenceView view;
    private PUDataObject puDataObject;
    private PersistenceUnitPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private Project project;
    private boolean needInit = true;
    private RequestProcessor.Task repaintingTask;

    public PersistenceToolBarMVElement(PUDataObject dObj) {
        super((XmlMultiViewDataObject)dObj);
        this.puDataObject = dObj;
        this.project = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        this.addAction = new AddAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Add"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Remove"));
        this.comp = new ToolBarDesignEditor();
        this.factory = new PersistenceUnitPanelFactory(this.comp, dObj);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PersistenceToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            if (!this.puDataObject.viewCanBeDisplayed()) {
                this.view = new PersistenceView();
                this.view.setRoot(Node.EMPTY);
                this.comp.setContentView((PanelView)this.view);
                return;
            }
            this.needInit = !this.repaintView();
        }
    }

    private boolean repaintView() {
        this.view = new PersistenceView();
        this.view.initialize(this.puDataObject);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            Node initialNode = this.view.getPersistenceUnitsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            this.view.selectNode(initialNode);
        }
        this.view.checkValidity();
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("persistence_unit_added_or_removed".equals(name)) {
            this.repaintingTask.schedule(100);
        } else if (("data modified".equals(name) || "data changed".equals(name)) && !this.equals(this.puDataObject.getActiveMultiViewElement0())) {
            this.needInit = true;
        } else if ("non ui pu classes modified".equals(name) && this.equals(this.puDataObject.getActiveMultiViewElement0())) {
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit pu;
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = pu = evt.getNewValue() instanceof org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit ? (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit)evt.getNewValue() : null;
            if (pu != null) {
                SectionContainer sc = this.view.getPersistenceUnitsCont();
                SectionContainerNode sn = (SectionContainerNode)sc.getNode();
                Children ch = sn.getChildren();
                NodeSectionPanel nsp = null;
                for (Node n : ch.getNodes()) {
                    PersistenceUnitNode pun = (PersistenceUnitNode)n;
                    String pusecname = pun.getDisplayName();
                    if (!pusecname.equals(pu.getName())) continue;
                    nsp = sc.getSection(n);
                    break;
                }
                if (nsp == null) {
                    this.needInit = true;
                } else {
                    SectionPanel sp = nsp != null && nsp instanceof SectionPanel ? (SectionPanel)nsp : null;
                    PersistenceUnitPanel up = (PersistenceUnitPanel)(sp.getInnerPanel() != null && sp.getInnerPanel() instanceof PersistenceUnitPanel ? sp.getInnerPanel() : null);
                    if (up != null) {
                        up.initEntityList();
                    } else {
                        this.needInit = true;
                    }
                }
            } else {
                this.needInit = true;
            }
        }
    }

    private void validateUnitName(PersistenceUnitWizardPanel panel) {
        try {
            if (!panel.isNameUnique()) {
                panel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
            } else {
                panel.setErrorMessage(null);
            }
        }
        catch (InvalidPersistenceXmlException ipx) {
            panel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)ipx.getPath()));
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit)sectionPanel.getKey();
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_ConfirmRemove", (Object)punit.getName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                PersistenceToolBarMVElement.this.puDataObject.removePersistenceUnit(punit);
            }
        }

        @Override
        public boolean isEnabled() {
            boolean disable = PersistenceToolBarMVElement.this.puDataObject.getPersistence().sizePersistenceUnit() <= 1 && PersistenceToolBarMVElement.this.puDataObject.getPersistence().getVersion().equals("2.0");
            return !disable;
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object result;
            boolean isContainer = Util.isSupportedJavaEEVersion(PersistenceToolBarMVElement.this.project);
            final PersistenceUnitWizardPanel panel = isContainer && ProviderUtil.isValidServerInstanceOrNone(PersistenceToolBarMVElement.this.project) ? new PersistenceUnitWizardPanelDS(PersistenceToolBarMVElement.this.project, null, true) : new PersistenceUnitWizardPanelJdbc(PersistenceToolBarMVElement.this.project, null, true);
            final NotifyDescriptor nd = new NotifyDescriptor((Object)new WrapperPanel(panel), NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_NewPersistenceUnit"), 2, -1, null, null);
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        PersistenceToolBarMVElement.this.validateUnitName(panel);
                        nd.setValid(((Boolean)newvalue).booleanValue());
                    }
                }
            });
            if (!panel.isValidPanel()) {
                PersistenceToolBarMVElement.this.validateUnitName(panel);
                nd.setValid(false);
            }
            if ((result = DialogDisplayer.getDefault().notify(nd)) == NotifyDescriptor.OK_OPTION) {
                Library mLib;
                String version = PersistenceToolBarMVElement.this.puDataObject.getPersistence().getVersion();
                org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = null;
                boolean useModelgen = false;
                String modelGenLib = null;
                if ("2.0".equals(version)) {
                    useModelgen = true;
                    punit = new PersistenceUnit();
                } else {
                    punit = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
                }
                if (isContainer) {
                    Library lib;
                    PersistenceUnitWizardPanelDS puPanel = (PersistenceUnitWizardPanelDS)panel;
                    if (puPanel.getDatasource() != null && !"".equals(puPanel.getDatasource().trim())) {
                        if (puPanel.isJTA()) {
                            punit.setJtaDataSource(puPanel.getDatasource());
                        } else {
                            punit.setNonJtaDataSource(puPanel.getDatasource());
                            punit.setTransactionType("RESOURCE_LOCAL");
                        }
                    }
                    Provider provider = puPanel.getSelectedProvider();
                    if (puPanel.isNonDefaultProviderEnabled()) {
                        punit.setProvider(puPanel.getNonDefaultProvider());
                        lib = PersistenceLibrarySupport.getLibrary(provider);
                        if (lib != null && !Util.isDefaultProvider(PersistenceToolBarMVElement.this.project, provider)) {
                            Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, lib);
                            modelGenLib = lib.getName() + "modelgen";
                            provider = null;
                        }
                    }
                    if (provider != null && provider.getAnnotationProcessor() != null && (lib = PersistenceLibrarySupport.getLibrary(provider)) != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, lib, "classpath/processor");
                        modelGenLib = lib.getName() + "modelgen";
                    }
                } else {
                    Library lib;
                    PersistenceUnitWizardPanelJdbc puJdbc = (PersistenceUnitWizardPanelJdbc)panel;
                    punit = ProviderUtil.buildPersistenceUnit(puJdbc.getPersistenceUnitName(), puJdbc.getSelectedProvider(), puJdbc.getPersistenceConnection(), version);
                    punit.setTransactionType("RESOURCE_LOCAL");
                    if (!Util.isJavaSE(PersistenceToolBarMVElement.this.project)) {
                        punit.setExcludeUnlistedClasses(false);
                    }
                    if ((lib = PersistenceLibrarySupport.getLibrary(puJdbc.getSelectedProvider())) != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, lib);
                        modelGenLib = lib.getName() + "modelgen";
                    }
                    JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(puJdbc.getPersistenceConnection().getDriverClass());
                    PersistenceLibrarySupport.addDriver(PersistenceToolBarMVElement.this.project, driver[0]);
                }
                punit.setName(panel.getPersistenceUnitName());
                ProviderUtil.setTableGeneration(punit, panel.getTableGeneration(), PersistenceToolBarMVElement.this.project);
                PersistenceToolBarMVElement.this.puDataObject.addPersistenceUnit(punit);
                PersistenceToolBarMVElement.this.comp.setLastActive((Object)punit);
                if (useModelgen && modelGenLib != null && (mLib = LibraryManager.getDefault().getLibrary(modelGenLib)) != null) {
                    Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, mLib, "classpath/processor");
                }
            }
        }
    }

    private class PersistenceUnitNode
    extends AbstractNode {
        PersistenceUnitNode(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
            super(Children.LEAF);
            this.setDisplayName(persistenceUnit.getName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("persistence_multiview_design_persistenceUnitNode");
        }
    }

    private class PersistenceView
    extends SectionView {
        private SectionContainer persistenceUnitsCont;
        private Node persistenceUnitsNode;

        public SectionContainer getPersistenceUnitsCont() {
            return this.persistenceUnitsCont;
        }

        public Node getPersistenceUnitsNode() {
            return this.persistenceUnitsNode;
        }

        PersistenceView() {
            super((InnerPanelFactory)PersistenceToolBarMVElement.this.factory);
        }

        void initialize(PUDataObject pudo) {
            Persistence persistence = pudo.getPersistence();
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] persistenceUnits = persistence.getPersistenceUnit();
            Node[] persistenceUnitNode = new Node[persistenceUnits.length];
            Children.Array ch = new Children.Array();
            for (int i = 0; i < persistenceUnits.length; ++i) {
                persistenceUnitNode[i] = new PersistenceUnitNode(persistenceUnits[i]);
            }
            ch.add(persistenceUnitNode);
            this.persistenceUnitsNode = new SectionContainerNode((Children)ch);
            this.persistenceUnitsNode.setDisplayName(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont = new SectionContainer((SectionView)this, this.persistenceUnitsNode, NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont.setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.addAction});
            Children.Array rootChildren = new Children.Array();
            rootChildren.add(new Node[]{this.persistenceUnitsNode});
            AbstractNode root = new AbstractNode((Children)rootChildren);
            SectionPanel[] pan = new SectionPanel[persistenceUnits.length];
            for (int i = 0; i < persistenceUnits.length; ++i) {
                pan[i] = new SectionPanel((SectionView)this, persistenceUnitNode[i], persistenceUnitNode[i].getDisplayName(), (Object)persistenceUnits[i], false, false);
                pan[i].setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.removeAction});
                this.persistenceUnitsCont.addSection((NodeSectionPanel)pan[i]);
            }
            this.addSection((NodeSectionPanel)this.persistenceUnitsCont);
            this.setRoot((Node)root);
        }

        public Error validateView() {
            PersistenceValidator validator = new PersistenceValidator((PUDataObject)PersistenceToolBarMVElement.this.dObj);
            List<Error> result = validator.validate();
            if (!result.isEmpty()) {
                return result.get(0);
            }
            return null;
        }
    }
}

