/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.api.HtmlParsingResult;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ParseException;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.editor.ext.html.parser.spi.ParseResult;
import org.netbeans.html.api.validation.ValidationContext;
import org.netbeans.html.api.validation.ValidationException;
import org.netbeans.html.api.validation.ValidationResult;
import org.netbeans.html.api.validation.Validator;
import org.netbeans.html.api.validation.ValidatorService;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HtmlParserResult
extends ParserResult
implements HtmlParsingResult {
    public static final String FALLBACK_DTD_PROPERTY_NAME = "fallbackDTD";
    private SyntaxAnalyzerResult result;
    private List<Error> errors;
    private boolean isValid = true;

    private HtmlParserResult(SyntaxAnalyzerResult result) {
        super(result.getSource().getSnapshot());
        this.result = result;
    }

    public SyntaxAnalyzerResult getSyntaxAnalyzerResult() {
        return this.result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public HtmlVersion getHtmlVersion() {
        return this.result.getHtmlVersion();
    }

    public HtmlVersion getDetectedHtmlVersion() {
        return this.result.getDetectedHtmlVersion();
    }

    public AstNode root() {
        try {
            return this.result.parseHtml().root();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public AstNode rootOfUndeclaredTagsParseTree() {
        try {
            return this.result.parseUndeclaredEmbeddedCode().root();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public AstNode root(String namespace) {
        try {
            ParseResult pr = this.result.parseEmbeddedCode(namespace);
            assert (pr != null) : "Cannot get ParseResult for " + namespace;
            return pr.root();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Map<String, AstNode> roots() {
        HashMap<String, AstNode> roots = new HashMap<String, AstNode>();
        for (String uri : this.getNamespaces().keySet()) {
            roots.put(uri, this.root(uri));
        }
        if (!roots.containsValue(this.root())) {
            roots.put(null, this.root());
        }
        return roots;
    }

    public Map<String, String> getNamespaces() {
        return this.result.getDeclaredNamespaces();
    }

    public AstNode findLeafTag(int offset, boolean forward, boolean physicalNodesOnly) {
        AstNode mostLeaf = AstNodeUtils.findNode((AstNode)this.root(), (int)offset, (boolean)forward, (boolean)physicalNodesOnly);
        for (String uri : this.getNamespaces().keySet()) {
            AstNode root = this.root(uri);
            AstNode leaf = AstNodeUtils.findNode((AstNode)root, (int)offset, (boolean)forward, (boolean)physicalNodesOnly);
            if (leaf == null) continue;
            if (mostLeaf == null) {
                mostLeaf = leaf;
                continue;
            }
            if (leaf.logicalStartOffset() <= mostLeaf.logicalStartOffset()) continue;
            mostLeaf = leaf;
        }
        return mostLeaf;
    }

    public synchronized List<? extends Error> getDiagnostics() {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
            this.errors.addAll(this.getValidationResults());
        }
        return this.errors;
    }

    protected void invalidate() {
        this.isValid = false;
    }

    private Collection<Error> getValidationResults() {
        FileObject file = this.getSnapshot().getSource().getFileObject();
        try {
            Validator validator = ValidatorService.getValidator((HtmlVersion)this.getHtmlVersion());
            if (validator == null) {
                return Collections.emptyList();
            }
            ValidationContext context = new ValidationContext(((Object)this.getSnapshot().getText()).toString(), this.getHtmlVersion(), file, this.result);
            context.enableFeature("filter.foreign.namespaces", true);
            ValidationResult res = validator.validate(context);
            ArrayList<Error> errs = new ArrayList<Error>();
            for (ProblemDescription pd : res.getProblems()) {
                DefaultError error = new DefaultError(pd.getKey(), "nu.validator issue", pd.getText(), res.getContext().getFile(), pd.getFrom(), pd.getTo(), false, HtmlParserResult.forProblemType(pd.getType()));
                errs.add((Error)error);
            }
            return errs;
        }
        catch (ValidationException ex) {
            Logger.getAnonymousLogger().log(Level.INFO, "An error occured during html code validation", ex);
            DefaultError error = new DefaultError("validator.error", "validator.error", "An internal error occured during validating the code: " + ex.getLocalizedMessage(), file, 0, 0, true, Severity.ERROR);
            return Collections.singletonList(error);
        }
    }

    private static Severity forProblemType(int problemtype) {
        switch (problemtype) {
            case 0: {
                return Severity.INFO;
            }
            case 1: {
                return Severity.WARNING;
            }
            case 2: 
            case 3: {
                return Severity.ERROR;
            }
        }
        throw new IllegalArgumentException("Invalid ProblemDescription type: " + problemtype);
    }

    public static AstNode getBoundAstNode(Error e) {
        if (e instanceof DefaultError && e.getParameters() != null && e.getParameters().length > 0 && e.getParameters()[0] instanceof AstNode) {
            return (AstNode)e.getParameters()[0];
        }
        return null;
    }

    static {
        HtmlParserResultAccessor.set(new Accessor());
    }

    private static class Accessor
    extends HtmlParserResultAccessor {
        private Accessor() {
        }

        @Override
        public HtmlParserResult createInstance(SyntaxAnalyzerResult result) {
            return new HtmlParserResult(result);
        }
    }
}

