/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PageFlowToolbarUtilities {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");
    private static Map<Scope, String> scope2String = new HashMap<Scope, String>();
    private static Map<String, Scope> string2Scope = new HashMap<String, Scope>();
    private static final String TT_SCOPE = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"TT_Scope_DropDown");
    private static final String LBL_SCOPE_FACESCONFIG = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"LBL_Scope_FacesConfig");
    private static final String LBL_SCOPE_PROJECT = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"LBL_Scope_Project");
    private static final String LBL_SCOPE_ALL_PROJECT = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"LBL_Scope_All_FacesConfig");
    private static final String TT_LAYOUTPAGES = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"TT_LayoutPages");
    private Scope currentScope = Scope.SCOPE_PROJECT;
    private static PageFlowToolbarUtilities instance;
    private static final Map<PageFlowView, PageFlowToolbarUtilities> map;
    private JComboBox scopeBox;
    private static final Image LAYOUT_ICON;
    private JButton layoutButton = null;
    private Reference<PageFlowView> pageFlowViewRef;

    public static final String getScopeLabel(Scope scope) {
        return scope2String.get((Object)scope);
    }

    public static final Scope getScope(String string) {
        return string2Scope.get(string);
    }

    private PageFlowToolbarUtilities(PageFlowView pageFlowView) {
        this.setPageFlowView(pageFlowView);
    }

    protected static boolean removePageFlowView(PageFlowView pageFlowView) {
        if (map.containsKey((Object)pageFlowView)) {
            map.remove((Object)pageFlowView);
            return true;
        }
        return false;
    }

    public static PageFlowToolbarUtilities getInstance(PageFlowView pageFlowView) {
        PageFlowToolbarUtilities pageFlowToolbarUtilities = map.get((Object)pageFlowView);
        if (pageFlowToolbarUtilities == null) {
            pageFlowToolbarUtilities = new PageFlowToolbarUtilities(pageFlowView);
            map.put(pageFlowView, pageFlowToolbarUtilities);
        }
        return pageFlowToolbarUtilities;
    }

    public static Set<PageFlowView> getViews() {
        return map.keySet();
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(Scope scope) {
        this.currentScope = scope;
        if (this.scopeBox != null && !this.scopeBox.getSelectedItem().equals(PageFlowToolbarUtilities.getScopeLabel(this.currentScope))) {
            this.scopeBox.setSelectedItem(PageFlowToolbarUtilities.getScopeLabel(this.currentScope));
        }
    }

    public JComboBox createScopeComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(PageFlowToolbarUtilities.getScopeLabel(Scope.SCOPE_FACESCONFIG));
        jComboBox.addItem(PageFlowToolbarUtilities.getScopeLabel(Scope.SCOPE_PROJECT));
        jComboBox.addItem(PageFlowToolbarUtilities.getScopeLabel(Scope.SCOPE_ALL_FACESCONFIG));
        Dimension dimension = jComboBox.getPreferredSize();
        jComboBox.setMinimumSize(dimension);
        jComboBox.setMaximumSize(dimension);
        jComboBox.setSelectedItem(PageFlowToolbarUtilities.getScopeLabel(this.currentScope));
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PageFlowView pageFlowView = PageFlowToolbarUtilities.this.getPageFlowView();
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)itemEvent.getItem();
                    pageFlowView.saveLocations();
                    LogRecord logRecord = new LogRecord(Level.FINE, "PageFLowEditor Scope Changed To:" + string);
                    logRecord.setSourceClassName("PageFlowUtilities.ItemListener");
                    logRecord.setSourceMethodName("itemStateChanged");
                    logRecord.setParameters(new Object[]{string, new Date()});
                    LOGGER.log(logRecord);
                    PageFlowToolbarUtilities.this.setCurrentScope(PageFlowToolbarUtilities.getScope(string));
                    pageFlowView.getPageFlowController().setupGraphNoSaveData();
                }
                pageFlowView.requestMultiViewActive();
            }
        });
        jComboBox.setToolTipText(TT_SCOPE);
        this.scopeBox = jComboBox;
        return jComboBox;
    }

    public JButton createLayoutButton() {
        if (this.layoutButton != null) {
            return this.layoutButton;
        }
        this.layoutButton = new JButton(new ImageIcon(LAYOUT_ICON));
        this.layoutButton.setToolTipText(TT_LAYOUTPAGES);
        this.layoutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PageFlowToolbarUtilities.this.getPageFlowView().layoutNodes();
                PageFlowToolbarUtilities.this.getPageFlowView().requestMultiViewActive();
            }
        });
        return this.layoutButton;
    }

    public final PageFlowView getPageFlowView() {
        return this.pageFlowViewRef.get();
    }

    public void setPageFlowView(PageFlowView pageFlowView) {
        this.pageFlowViewRef = new WeakReference<PageFlowView>(pageFlowView);
    }

    static {
        scope2String.put(Scope.SCOPE_FACESCONFIG, LBL_SCOPE_FACESCONFIG);
        scope2String.put(Scope.SCOPE_PROJECT, LBL_SCOPE_PROJECT);
        scope2String.put(Scope.SCOPE_ALL_FACESCONFIG, LBL_SCOPE_ALL_PROJECT);
        string2Scope.put(LBL_SCOPE_FACESCONFIG, Scope.SCOPE_FACESCONFIG);
        string2Scope.put(LBL_SCOPE_PROJECT, Scope.SCOPE_PROJECT);
        string2Scope.put(LBL_SCOPE_ALL_PROJECT, Scope.SCOPE_ALL_FACESCONFIG);
        map = new WeakHashMap<PageFlowView, PageFlowToolbarUtilities>();
        LAYOUT_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/resources/navigation.gif");
    }

    public static enum Scope {
        SCOPE_FACESCONFIG,
        SCOPE_PROJECT,
        SCOPE_ALL_FACESCONFIG;

    }
}

