/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.palette.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.vmd.api.io.javame.MidpProjectPropertiesSupport;
import org.netbeans.modules.vmd.midp.palette.wizard.AddToPaletteWizardPanel1;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class AddToPaletteVisualPanel1
extends JPanel {
    private static final String MSG_NO_PROJECTS = "MSG_ERR_NoOpenedProjects";
    private static final String MSG_WAIT_PROJECTS = "MSG_WaitOpenedProjects";
    private AddToPaletteWizardPanel1 wizardPanel;
    private JComboBox projectCombo;

    public AddToPaletteVisualPanel1(AddToPaletteWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"TITLE_SelectProject");
    }

    public Project getActiveProject() {
        Object item = this.projectCombo.getSelectedItem();
        if (item instanceof Project) {
            return (Project)item;
        }
        return null;
    }

    public int getProjectsCount() {
        if (this.projectCombo.getItemAt(0) == null || this.projectCombo.getItemAt(0).equals(MSG_NO_PROJECTS)) {
            return 0;
        }
        return this.projectCombo.getItemCount();
    }

    public void reload(Project project) {
        this.reload(project, false);
    }

    public void reload(final Project project, boolean loaded) {
        Future future = OpenProjects.getDefault().openProjects();
        Vector<String> projectsVector = new Vector<String>();
        if (!loaded && !future.isDone()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        OpenProjects.getDefault().openProjects().get();
                        this.reload();
                    }
                    catch (InterruptedException ex) {
                        this.reload();
                    }
                    catch (ExecutionException ex) {
                        this.reload();
                    }
                }

                private void reload() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AddToPaletteVisualPanel1.this.reload(project, true);
                        }
                    });
                }
            }.start();
            projectsVector.add(AddToPaletteVisualPanel1.getMessage(MSG_WAIT_PROJECTS));
            this.projectCombo.setEnabled(false);
            this.projectCombo.setRenderer(new DefaultListCellRenderer());
            this.projectCombo.setModel(new DefaultComboBoxModel(projectsVector));
            return;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (Project prj : projects) {
            if (!MidpProjectPropertiesSupport.isMobileProject((Project)prj)) continue;
            projectsVector.add((String)prj);
        }
        if (projectsVector.size() == 0) {
            projectsVector.add(AddToPaletteVisualPanel1.getMessage(MSG_NO_PROJECTS));
            this.projectCombo.setEnabled(false);
            this.projectCombo.setRenderer(new DefaultListCellRenderer());
            this.projectCombo.setModel(new DefaultComboBoxModel(projectsVector));
        } else {
            this.projectCombo.setEnabled(true);
            this.projectCombo.setRenderer(new ProjectListCellRenderer());
            this.projectCombo.setModel(new DefaultComboBoxModel(projectsVector));
            this.setProjectSelection(projects, project);
        }
    }

    private void setProjectSelection(Project[] openedProjects, Project project) {
        Project prj;
        if (project == null && MidpProjectPropertiesSupport.isMobileProject((Project)(prj = OpenProjects.getDefault().getMainProject()))) {
            project = prj;
        }
        if (project == null && openedProjects.length > 0) {
            project = openedProjects[0];
        }
        this.projectCombo.setSelectedItem(project);
    }

    private void initComponents() {
        this.projectCombo = new JComboBox();
        JLabel jLabel1 = new JLabel();
        this.projectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddToPaletteVisualPanel1.this.projectComboActionPerformed(evt);
            }
        });
        jLabel1.setLabelFor(this.projectCombo);
        Mnemonics.setLocalizedText((JLabel)jLabel1, (String)NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"DISP_SelectProject"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)jLabel1).add((Component)this.projectCombo, 0, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)jLabel1).addPreferredGap(0).add((Component)this.projectCombo, -2, -1, -2).addContainerGap(243, Short.MAX_VALUE)));
        this.projectCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_NAME_projectCombo"));
        this.projectCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_DESCRIPTION_projectCombo"));
        jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_NAME_jLabel1_2"));
        jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_DESCRIPTION_jLabel1_2"));
    }

    private void projectComboActionPerformed(ActionEvent evt) {
        this.wizardPanel.fireChangeEvent();
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)key);
    }

    public static class ProjectListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            ProjectInformation info = (ProjectInformation)((Project)value).getLookup().lookup(ProjectInformation.class);
            super.getListCellRendererComponent((JList<?>)list, info != null ? info.getDisplayName() : null, index, isSelected, cellHasFocus);
            if (info != null) {
                this.setIcon(info.getIcon());
            }
            return this;
        }
    }
}

