/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.PropertyValueSupport;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ControllersCategoryCD;
import org.netbeans.modules.vmd.midp.components.commands.CommandCD;
import org.netbeans.modules.vmd.midp.components.handlers.EventHandlerCD;
import org.netbeans.modules.vmd.midp.components.sources.CommandEventSourceCD;
import org.netbeans.modules.vmd.midp.components.sources.ItemCommandEventSourceCD;
import org.netbeans.modules.vmd.midp.general.AbstractEventHandlerCreatorPresenter;

public final class MidpDocumentSupport {
    public static final String PROJECT_TYPE_MIDP = "vmd-midp";
    public static final Comparator<DesignComponent> COMPONENT_DISPLAY_NAME_COMPARATOR = new Comparator<DesignComponent>(){

        @Override
        public int compare(DesignComponent component1, DesignComponent component2) {
            String name1 = (String)component1.readProperty("instanceName").getPrimitiveValue();
            String name2 = (String)component2.readProperty("instanceName").getPrimitiveValue();
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    };

    public static DesignComponent getCategoryComponent(DesignDocument document, TypeID categoryType) {
        List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)document.getRootComponent(), (TypeID)categoryType);
        if (list.size() == 0 && document.getTransactionManager().isWriteAccess()) {
            DesignComponent categoryComponent = document.createComponent(categoryType);
            document.getRootComponent().addComponent(categoryComponent);
            return categoryComponent;
        }
        assert (list.size() == 1);
        return (DesignComponent)list.get(0);
    }

    public static DesignComponent getSingletonCommand(DesignDocument document, TypeID typeID) {
        DesignComponent categoryComponent = MidpDocumentSupport.getCategoryComponent(document, CommandsCategoryCD.TYPEID);
        assert (categoryComponent != null);
        List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)categoryComponent, (TypeID)typeID);
        if (list.size() == 1) {
            return (DesignComponent)list.get(0);
        }
        if (list.size() == 0) {
            DesignComponent newComponent = document.createComponent(typeID);
            categoryComponent.addComponent(newComponent);
            return newComponent;
        }
        throw new IllegalStateException("Component " + typeID + " should be singelton per document");
    }

    public static DesignComponent attachCommandToDisplayable(DesignComponent displayable, DesignComponent command) {
        DesignComponent source = displayable.getDocument().createComponent(CommandEventSourceCD.TYPEID);
        MidpDocumentSupport.addEventSource(displayable, "commands", source);
        source.writeProperty("displayable", PropertyValue.createComponentReference((DesignComponent)displayable));
        source.writeProperty("command", PropertyValue.createComponentReference((DesignComponent)command));
        return source;
    }

    public static DesignComponent attachCommandToItem(DesignComponent item, DesignComponent command) {
        DesignComponent itemCommandEventSource = command.getDocument().createComponent(ItemCommandEventSourceCD.TYPEID);
        itemCommandEventSource.writeProperty("command", PropertyValue.createComponentReference((DesignComponent)command));
        itemCommandEventSource.writeProperty("item", PropertyValue.createComponentReference((DesignComponent)item));
        MidpArraySupport.append(item, "commands", itemCommandEventSource);
        item.addComponent(itemCommandEventSource);
        return itemCommandEventSource;
    }

    public static void addEventSource(DesignComponent component, String propertyName, DesignComponent eventSource) {
        component.addComponent(eventSource);
        PropertyValue sources = component.readProperty(propertyName);
        sources = PropertyValueSupport.addArrayValue((PropertyValue)sources, (PropertyValue)PropertyValue.createComponentReference((DesignComponent)eventSource));
        component.writeProperty(propertyName, sources);
    }

    public static boolean isCreatableEventHandlerTo(DesignComponent targetComponent) {
        return targetComponent == null || targetComponent.getPresenter(AbstractEventHandlerCreatorPresenter.class) != null;
    }

    public static DesignComponent updateEventHandlerFromTarget(DesignComponent eventSource, DesignComponent targetComponent) {
        assert (targetComponent == null || !targetComponent.getDocument().getDescriptorRegistry().isInHierarchy(EventHandlerCD.TYPEID, targetComponent.getType()));
        DesignComponent oldEventHandler = eventSource.readProperty("eventHandler").getComponent();
        AbstractEventHandlerCreatorPresenter targetPresenter = targetComponent != null ? (AbstractEventHandlerCreatorPresenter)targetComponent.getPresenter(AbstractEventHandlerCreatorPresenter.class) : null;
        DesignComponent newEventHandler = targetPresenter != null ? targetPresenter.createReuseEventHandler(eventSource, oldEventHandler, targetComponent) : null;
        return MidpDocumentSupport.updateEventHandlerWithNew(eventSource, newEventHandler);
    }

    public static DesignComponent updateEventHandlerWithNew(DesignComponent eventSource, DesignComponent newEventHandler) {
        assert (newEventHandler == null || newEventHandler.getDocument().getDescriptorRegistry().isInHierarchy(EventHandlerCD.TYPEID, newEventHandler.getType()));
        DesignComponent oldEventHandler = eventSource.readProperty("eventHandler").getComponent();
        if (oldEventHandler == newEventHandler) {
            return oldEventHandler;
        }
        if (oldEventHandler != null) {
            oldEventHandler.writeProperty("eventSource", PropertyValue.createNull());
            oldEventHandler.removeFromParentComponent();
        }
        if (newEventHandler != null) {
            eventSource.addComponent(newEventHandler);
            eventSource.writeProperty("eventHandler", PropertyValue.createComponentReference((DesignComponent)newEventHandler));
            newEventHandler.writeProperty("eventSource", PropertyValue.createComponentReference((DesignComponent)eventSource));
        } else {
            eventSource.writeProperty("eventHandler", PropertyValue.createNull());
        }
        return newEventHandler;
    }

    public static void updateEventHandlerWithAlert(DesignComponent eventHandler, DesignComponent alert) {
        if (alert != null) {
            eventHandler.writeProperty("alert", PropertyValue.createComponentReference((DesignComponent)alert));
        } else {
            eventHandler.writeProperty("alert", PropertyValue.createNull());
        }
    }

    public static void updateSwitchDisplayableEventHandler(DesignComponent eventHandler, DesignComponent alert, DesignComponent displayable) {
        eventHandler.writeProperty("displayable", PropertyValue.createComponentReference((DesignComponent)displayable));
        MidpDocumentSupport.updateEventHandlerWithAlert(eventHandler, alert);
    }

    public static String createDisplayNameFromTypeID(TypeID type) {
        String str = type.getString();
        int i = str.lastIndexOf(46);
        return i >= 0 ? str.substring(i + 1) : str;
    }

    public static Collection<DesignComponent> getAvailableCommandsForComponent(DesignComponent component) {
        Collection componentsUnderCommandCategory = MidpDocumentSupport.getCategoryComponent(component.getDocument(), CommandsCategoryCD.TYPEID).getComponents();
        DescriptorRegistry registry = component.getDocument().getDescriptorRegistry();
        ArrayList<DesignComponent> unusedCommands = null;
        HashSet<DesignComponent> usedCommands = null;
        for (PropertyValue propertyValue : component.readProperty("commands").getArray()) {
            DesignComponent currentComponent = propertyValue.getComponent();
            if (currentComponent == null) continue;
            if (usedCommands == null) {
                usedCommands = new HashSet<DesignComponent>();
            }
            usedCommands.add(currentComponent.readProperty("command").getComponent());
        }
        for (DesignComponent componentChild : componentsUnderCommandCategory) {
            if (usedCommands != null && usedCommands.contains(componentChild) || !registry.isInHierarchy(CommandCD.TYPEID, componentChild.getType()) || !((Boolean)componentChild.readProperty("ordinary").getPrimitiveValue()).booleanValue()) continue;
            if (unusedCommands == null) {
                unusedCommands = new ArrayList<DesignComponent>();
            }
            unusedCommands.add(componentChild);
        }
        if (unusedCommands != null) {
            Collections.sort(unusedCommands, COMPONENT_DISPLAY_NAME_COMPARATOR);
        }
        return unusedCommands;
    }

    public static DesignComponent getCommandListener(DesignDocument document, TypeID listenerType) {
        DesignComponent controllersCategory = MidpDocumentSupport.getCategoryComponent(document, ControllersCategoryCD.TYPEID);
        List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)controllersCategory, (TypeID)listenerType);
        if (list.isEmpty()) {
            DesignComponent commandListener = document.createComponent(listenerType);
            controllersCategory.addComponent(commandListener);
            return commandListener;
        }
        assert (list.size() == 1);
        return (DesignComponent)list.get(0);
    }

    public static int getMidpVersion(DesignDocument document) {
        PropertyValue propertyValue = document.getRootComponent().readProperty("version");
        return propertyValue.getKind() == PropertyValue.Kind.VALUE && "MIDP-2.0".equals(MidpTypes.getString(propertyValue)) ? 2 : 1;
    }
}

