/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.analyzer;

import java.awt.Dimension;
import java.awt.Image;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpVersionDescriptor;
import org.netbeans.modules.vmd.midp.components.MidpVersionable;
import org.netbeans.modules.vmd.midp.components.items.ImageItemCD;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.openide.util.NbBundle;

public class Midp1CompliantAnalyzer
implements Analyzer {
    public String getProjectType() {
        return "vmd-midp";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"Midp1CompliantAnalyzer.displayName");
    }

    public String getToolTip() {
        return NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"Midp1CompliantAnalyzer.toolTip");
    }

    public Image getIcon() {
        return null;
    }

    public JComponent createVisualRepresentation() {
        JList list = new JList(new DefaultListModel());
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(400, 150));
        return scrollPane;
    }

    public void update(JComponent visualRepresentation, final DesignDocument document) {
        if (visualRepresentation == null || document == null) {
            return;
        }
        final JList list = (JList)((JScrollPane)visualRepresentation).getViewport().getView();
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DefaultListModel model = (DefaultListModel)list.getModel();
                model.removeAllElements();
                DesignComponent rootComponent = document.getRootComponent();
                if (rootComponent != null) {
                    Midp1CompliantAnalyzer.this.analyze(model, rootComponent);
                }
            }
        });
    }

    private void analyze(DefaultListModel list, DesignComponent component) {
        ComponentDescriptor descriptor = component.getComponentDescriptor();
        if (descriptor == null) {
            return;
        }
        VersionDescriptor version = descriptor.getVersionDescriptor();
        if (!version.isCompatibleWith(MidpVersionDescriptor.MIDP_1)) {
            this.reportComponent(list, component);
            return;
        }
        for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
            if (!property.getVersionable().isCompatibleWith(MidpVersionable.MIDP_1) && !component.isDefaultValue(property.getName())) {
                this.reportComponentProperty(list, component, property.getName());
            }
            this.processComponentProperty(list, component, property);
        }
        for (DesignComponent child : component.getComponents()) {
            this.analyze(list, child);
        }
    }

    private void reportComponent(DefaultListModel list, DesignComponent component) {
        list.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatibleComponent", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)component)));
    }

    private void processComponentProperty(DefaultListModel list, DesignComponent component, PropertyDescriptor property) {
        DescriptorRegistry registry = component.getDocument().getDescriptorRegistry();
        if (registry.isInHierarchy(ItemCD.TYPEID, component.getType()) && "layout".equals(property.getName())) {
            if (!registry.isInHierarchy(ImageItemCD.TYPEID, component.getType())) {
                list.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatibleItemLayout", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)component)));
                return;
            }
            int value = MidpTypes.getInteger(component.readProperty("layout"));
            if ((value & 0x6C30) != 0) {
                list.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatibleItemLayout", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)component)));
                return;
            }
        }
    }

    private void reportComponentProperty(DefaultListModel list, DesignComponent component, String propertyName) {
        DescriptorRegistry registry = component.getDocument().getDescriptorRegistry();
        if (registry.isInHierarchy(ItemCD.TYPEID, component.getType())) {
            if ("itemCommandListener".equals(propertyName)) {
                return;
            }
            if ("commands".equals(propertyName)) {
                list.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_ItemsCommandsNotAllowed", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)component)));
                return;
            }
        }
        list.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatiblePropertyValue", (Object)propertyName, (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)component)));
    }
}

