/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.api.JspColoringData;
import org.netbeans.modules.web.core.syntax.IncludedJSPFileProcessor;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public abstract class JSPProcessor {
    protected Document doc;
    protected FileObject fobj;
    protected static final Logger logger = Logger.getLogger(JSPProcessor.class.getName());
    protected boolean processCalled = false;
    protected boolean processingSuccessful = true;
    private static final WeakHashMap<FileObject, ParserData> PARSER_DATA_CACHE = new WeakHashMap();
    private ParserData parserData;
    public static boolean ignoreLockFromUnitTest = false;

    private ParserData getParserData() {
        assert (this.parserData != null);
        return this.parserData;
    }

    private static ParserData getCachedParserData(FileObject file) {
        return PARSER_DATA_CACHE.get(file);
    }

    protected String createBeanVarDeclarations(List<String> localBeans) {
        StringBuilder beanDeclarationsBuff = new StringBuilder();
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            PageInfo.BeanData[] beanData = this.getBeanData();
            if (beanData != null) {
                for (PageInfo.BeanData beanData2 : beanData) {
                    if (localBeans.contains(beanData2.getId())) continue;
                    beanDeclarationsBuff.append(beanData2.getClassName() + " " + beanData2.getId() + ";\n");
                }
            }
            if (pageInfo.isTagFile()) {
                for (PageInfo.BeanData beanData3 : pageInfo.getTagInfo().getAttributes()) {
                    if (beanData3.getTypeName() == null || localBeans.contains(beanData3.getName())) continue;
                    beanDeclarationsBuff.append(beanData3.getTypeName() + " " + beanData3.getName() + ";\n");
                }
            }
        }
        JspSyntaxSupport syntaxSupport = JspSyntaxSupport.get(this.doc);
        JspColoringData coloringData = this.getParserData().getColoringData();
        if (coloringData != null && coloringData.getPrefixMapper() != null) {
            Set prefixes = coloringData.getPrefixMapper().keySet();
            TagData fooArg = new TagData((Object[][])null);
            for (String prefix : prefixes) {
                List tags = syntaxSupport.getAllTags(prefix, false);
                for (TagInfo tag : tags) {
                    VariableInfo[] vars;
                    if (tag == null || (vars = tag.getVariableInfo(fooArg)) == null) continue;
                    for (VariableInfo var : vars) {
                        if (var.getVarName() == null || var.getClassName() == null || !var.getDeclare()) continue;
                        String varDeclaration = var.getClassName() + " " + var.getVarName() + ";\n";
                        beanDeclarationsBuff.append(varDeclaration);
                    }
                }
            }
        }
        return beanDeclarationsBuff.toString();
    }

    protected PageInfo getPageInfo() {
        JspParserAPI.ParseResult result = this.getParserData().getParserResult();
        return result != null ? result.getPageInfo() : null;
    }

    private PageInfo.BeanData[] getBeanData() {
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            return pageInfo.getBeans();
        }
        return null;
    }

    protected void assureProcessCalled() {
        if (!this.processCalled) {
            throw new IllegalStateException("process() method must be called first!");
        }
    }

    protected void processIncludes() {
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo == null) {
            return;
        }
        final TreeSet<String> processedFiles = new TreeSet<String>(this.processedIncludes());
        processedFiles.add(this.fobj.getPath());
        if (pageInfo.getIncludePrelude() != null) {
            for (String preludePath : pageInfo.getIncludePrelude()) {
                this.processIncludedFile(preludePath, processedFiles);
            }
        }
        Node.Visitor visitor = new Node.Visitor(){

            public void visit(Node.IncludeDirective includeDirective) throws JspException {
                String fileName = includeDirective.getAttributeValue("file");
                JSPProcessor.this.processIncludedFile(fileName, processedFiles);
            }
        };
        try {
            JspParserAPI.ParseResult parseResult = this.getParserData().getParserResult();
            if (parseResult != null && parseResult.getNodes() != null) {
                parseResult.getNodes().visit(visitor);
            }
        }
        catch (JspException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void processIncludedFile(String filePath, Collection<String> processedFiles) {
        FileObject includedFile = JspUtils.getFileObject(this.doc, filePath);
        if (includedFile != null && includedFile.canRead() && !processedFiles.contains(includedFile.getPath())) {
            processedFiles.add(includedFile.getPath());
            try {
                EditorCookie editor;
                DataObject includedFileDO = DataObject.find((FileObject)includedFile);
                String mimeType = includedFile.getMIMEType();
                if (("text/x-jsp".equals(mimeType) || "text/x-tag".equals(mimeType)) && (editor = (EditorCookie)includedFileDO.getCookie(EditorCookie.class)) != null) {
                    IncludedJSPFileProcessor includedJSPFileProcessor = new IncludedJSPFileProcessor((BaseDocument)editor.openDocument(), processedFiles);
                    includedJSPFileProcessor.process();
                    this.processIncludedFile(includedJSPFileProcessor);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public synchronized void process() throws BadLocationException {
        this.processCalled = true;
        this.fobj = NbEditorUtilities.getFileObject((Document)this.doc);
        if (this.fobj == null) {
            this.processingSuccessful = false;
            return;
        }
        if (DocumentUtilities.isWriteLocked((Document)this.doc) && !ignoreLockFromUnitTest) {
            this.parserData = JSPProcessor.getCachedParserData(this.fobj);
            if (this.parserData == null) {
                this.processingSuccessful = false;
                return;
            }
        } else {
            JspParserAPI.ParseResult parseResult = JspUtils.getCachedParseResult(this.fobj, true, false);
            if (parseResult == null || !parseResult.isParsingSuccess()) {
                this.processingSuccessful = false;
                return;
            }
            JspColoringData coloringData = JspUtils.getJSPColoringData(this.fobj);
            this.parserData = new ParserData(parseResult, coloringData);
            PARSER_DATA_CACHE.put(this.fobj, this.parserData);
        }
        final AtomicReference ble = new AtomicReference();
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    JSPProcessor.this.renderProcess();
                }
                catch (BadLocationException ex) {
                    ble.set(ex);
                }
            }
        });
        if (ble.get() != null) {
            throw (BadLocationException)ble.get();
        }
    }

    protected abstract void processIncludedFile(IncludedJSPFileProcessor var1);

    protected abstract void renderProcess() throws BadLocationException;

    protected String createImplicitImportStatements(List<String> localImports) {
        StringBuilder importsBuff = new StringBuilder();
        String[] imports = this.getImportsFromJspParser();
        if (imports == null || imports.length == 0) {
            this.processingSuccessful = false;
        } else {
            for (String pckg : imports) {
                if (localImports.contains(pckg)) continue;
                importsBuff.append("import " + pckg + ";\n");
            }
        }
        return importsBuff.toString();
    }

    private String[] getImportsFromJspParser() {
        PageInfo pi = this.getPageInfo();
        if (pi == null) {
            return new String[]{"javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*"};
        }
        List imports = pi.getImports();
        return imports == null ? null : imports.toArray(new String[imports.size()]);
    }

    protected abstract Collection<String> processedIncludes();

    private static class ParserData {
        private JspParserAPI.ParseResult parserResult;
        private JspColoringData coloringData;

        public ParserData(JspParserAPI.ParseResult parserResult, JspColoringData coloringData) {
            assert (parserResult != null);
            this.parserResult = parserResult;
            this.coloringData = coloringData;
        }

        public JspColoringData getColoringData() {
            return this.coloringData;
        }

        public JspParserAPI.ParseResult getParserResult() {
            return this.parserResult;
        }
    }
}

