/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FastOpenInfoParser {
    private static final Logger LOGGER = Logger.getLogger(FastOpenInfoParser.class.getName());
    private final WebModule wm;
    private static final String PAGE = "page";
    private static final String ENCODING = "pageEncoding";
    private static final String CONTENTYPE = "contentType";
    private static final String CHARSET = "charset=";
    private static final int P_INIT = 0;
    private static final int P_LT = 1;
    private static final int P_LT_PER = 2;
    private static final int P_LT_PER_ATS = 3;
    private static final int P_PD = 4;
    private static final int P_APER = 5;
    private static final int P_ENC = 7;
    private static final int P_ENC_EQ = 8;
    private static final int P_ENC_EQ_VAL = 9;
    private static final int P_CT = 11;
    private static final int P_CT_EQ = 12;
    private static final int P_CT_EQ_VAL = 13;
    private static final int P_CT_VAL_CHS = 14;
    static final String JSP_PROPERTY_GROUP = "jsp-property-group";
    static final String PAGE_ENCODING = "page-encoding";
    static final String IS_XML = "is-xml";

    static FastOpenInfoParser get(WebModule wm) {
        return new FastOpenInfoParser(wm);
    }

    private FastOpenInfoParser(WebModule wm) {
        this.wm = wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject fo, boolean useEditor) {
        long start = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        try {
            FileObject dd;
            FileObject documentBase;
            if (this.wm != null && this.wm.getDocumentBase() != null && useEditor) {
                JspParserAPI.JspOpenInfo jspOpenInfo = null;
                return jspOpenInfo;
            }
            if (this.wm != null && (documentBase = this.wm.getDocumentBase()) != null && (dd = this.wm.getDeploymentDescriptor()) != null) {
                DDParseInfo ddParseInfo = FastOpenInfoParser.parse(new InputSource(dd.getInputStream()));
                if (ddParseInfo.definesEncoding || ddParseInfo.marksXMLDocuments) {
                    JspParserAPI.JspOpenInfo jspOpenInfo = null;
                    return jspOpenInfo;
                }
            }
            String enc = null;
            byte[] buffer = new byte[32768];
            InputStream _is = fo.getInputStream();
            int readed = _is.read(buffer);
            ByteArrayInputStream is = new ByteArrayInputStream(buffer, 0, readed);
            _is.close();
            enc = FastOpenInfoParser.isXMLSyntax(fo) ? EncodingUtil.detectEncoding((InputStream)is) : FastOpenInfoParser.parseEncodingFromFile(is);
            LOGGER.fine("[fast open parser] detected " + enc + " encoding.");
            JspParserAPI.JspOpenInfo jspOpenInfo = enc == null ? null : new JspParserAPI.JspOpenInfo(FastOpenInfoParser.isXMLSyntax(fo), enc);
            return jspOpenInfo;
        }
        catch (IOException e) {
        }
        catch (SAXException se) {
        }
        catch (ParserConfigurationException pce) {
        }
        finally {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("[fast open parser] taken " + (System.currentTimeMillis() - start) + "ms.");
            }
        }
        return null;
    }

    private static String parseEncodingFromFile(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        char[] buffer = new char[8192];
        int readed = isr.read(buffer);
        isr.close();
        return FastOpenInfoParser.parseJspText(buffer, readed);
    }

    private static boolean isXMLSyntax(FileObject fo) {
        String ext = fo.getExt();
        return ext != null && ("jspx".equalsIgnoreCase(ext) || "tagx".equalsIgnoreCase(ext));
    }

    private static String parseJspText(char[] buffer, int len) {
        String contentType = null;
        int state = 0;
        int i = 0;
        int pos = -1;
        while (i < len) {
            char c = buffer[i];
            switch (state) {
                case 0: {
                    if (c == '<') {
                        state = 1;
                    }
                    ++i;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '%': {
                            state = 2;
                            break;
                        }
                        default: {
                            state = 0;
                        }
                    }
                    ++i;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '@': {
                            state = 3;
                            break;
                        }
                        default: {
                            state = 0;
                        }
                    }
                    ++i;
                    break;
                }
                case 3: {
                    if (c == ' ' || c == '\t') {
                        ++i;
                        break;
                    }
                    if (FastOpenInfoParser.prescanFor(buffer, i, PAGE)) {
                        state = 4;
                        i += PAGE.length();
                        break;
                    }
                    state = 0;
                    ++i;
                    break;
                }
                case 4: {
                    if (FastOpenInfoParser.prescanFor(buffer, i, ENCODING)) {
                        state = 7;
                        i += ENCODING.length();
                        break;
                    }
                    if (FastOpenInfoParser.prescanFor(buffer, i, CONTENTYPE)) {
                        state = 11;
                        i += CONTENTYPE.length();
                        break;
                    }
                    if (c == '%') {
                        state = 5;
                    }
                    ++i;
                    break;
                }
                case 5: {
                    state = c == '>' ? 0 : 4;
                    ++i;
                    break;
                }
                case 7: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '=': {
                            state = 8;
                            break;
                        }
                        case '%': {
                            state = 5;
                            break;
                        }
                        default: {
                            state = 4;
                        }
                    }
                    ++i;
                    break;
                }
                case 8: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '\"': {
                            state = 9;
                            pos = i + 1;
                            break;
                        }
                        case '%': {
                            state = 5;
                            break;
                        }
                        default: {
                            state = 4;
                        }
                    }
                    ++i;
                    break;
                }
                case 9: {
                    switch (c) {
                        case '\"': {
                            return new String(buffer, pos, i - pos);
                        }
                    }
                    ++i;
                    break;
                }
                case 11: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '=': {
                            state = 12;
                            break;
                        }
                        case '%': {
                            state = 5;
                            break;
                        }
                        default: {
                            state = 4;
                        }
                    }
                    ++i;
                    break;
                }
                case 12: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '\"': {
                            state = 13;
                            break;
                        }
                        case '%': {
                            state = 5;
                            break;
                        }
                        default: {
                            state = 4;
                        }
                    }
                    ++i;
                    break;
                }
                case 13: {
                    if (FastOpenInfoParser.prescanFor(buffer, i, CHARSET)) {
                        state = 14;
                        pos = i += CHARSET.length();
                        break;
                    }
                    if (c == '\"') {
                        state = 4;
                        break;
                    }
                    ++i;
                    break;
                }
                case 14: {
                    switch (c) {
                        case '\"': {
                            contentType = new String(buffer, pos, i - pos);
                            state = 4;
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        return contentType;
    }

    private static boolean prescanFor(char[] buffer, int position, String text) {
        if (buffer.length - position < text.length()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (buffer[position + i] == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static DDParseInfo parse(InputSource src) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        DDParseInfo ddParseInfo = new DDParseInfo();
        class Handler
        extends DefaultHandler {
            private boolean inJspPropertyGroup = false;
            final /* synthetic */ DDParseInfo val$ddParseInfo;

            Handler(DDParseInfo dDParseInfo) {
                this.val$ddParseInfo = dDParseInfo;
            }

            @Override
            public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                String tagName = qname.toLowerCase();
                if (FastOpenInfoParser.JSP_PROPERTY_GROUP.equals(tagName)) {
                    this.inJspPropertyGroup = true;
                }
                if (this.inJspPropertyGroup) {
                    if (FastOpenInfoParser.PAGE_ENCODING.equals(tagName)) {
                        this.val$ddParseInfo.definesEncoding = true;
                    }
                    if (FastOpenInfoParser.IS_XML.equals(tagName)) {
                        this.val$ddParseInfo.marksXMLDocuments = true;
                    }
                }
            }

            @Override
            public void endElement(String uri, String localname, String qname) throws SAXException {
                String tagName = qname.toLowerCase();
                if (FastOpenInfoParser.JSP_PROPERTY_GROUP.equals(tagName)) {
                    this.inJspPropertyGroup = false;
                }
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        }
        parser.parse(src, (DefaultHandler)new Handler(ddParseInfo));
        return ddParseInfo;
    }

    private static final class DDParseInfo {
        public boolean definesEncoding;
        public boolean marksXMLDocuments;
    }
}

