/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MakefileFileFilter
extends FileFilterFactory.FileAndFileObjectFilter {
    private static MakefileFileFilter instance = null;
    private ResourceBundle bundle;

    public static MakefileFileFilter getInstance() {
        if (instance == null) {
            instance = new MakefileFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return this.getString("FILECHOOSER_MAKEFILE_FILEFILTER");
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            return this.checkMakefileName(f.getName());
        }
        return false;
    }

    @Override
    public boolean accept(FileObject f) {
        if (f != null) {
            if (f.isFolder()) {
                return true;
            }
            return this.checkMakefileName(f.getNameExt());
        }
        return false;
    }

    private boolean checkMakefileName(String name) {
        return name.indexOf("Makefile") >= 0 || name.indexOf("makefile") >= 0 || name.endsWith(".mk");
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MakefileFileFilter.class);
        }
        return this.bundle.getString(s);
    }
}

