/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MacOSXDynamicLibraryFileFilter
extends FileFilterFactory.FileAndFileObjectFilter {
    private static MacOSXDynamicLibraryFileFilter instance = null;
    private ResourceBundle bundle;

    public static MacOSXDynamicLibraryFileFilter getInstance() {
        if (instance == null) {
            instance = new MacOSXDynamicLibraryFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return this.getString("MACOSX_DYNAMIC_LIB_FILTER");
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".dylib");
        }
        return false;
    }

    @Override
    public boolean accept(FileObject f) {
        if (f != null) {
            if (f.isFolder()) {
                return true;
            }
            return f.getNameExt().equals("dylib");
        }
        return false;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MacOSXDynamicLibraryFileFilter.class);
        }
        return this.bundle.getString(s);
    }
}

