/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class CndFileSystemProvider {
    private static final CndFileSystemProvider DEFAULT = new DefaultProvider();

    private static CndFileSystemProvider getDefault() {
        return DEFAULT;
    }

    public static String getCaseInsensitivePath(CharSequence path) {
        return CndFileSystemProvider.getDefault().getCaseInsensitivePathImpl(path);
    }

    public static File toFile(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null && fileObject != null && !fileObject.isValid()) {
            file = new File(fileObject.getPath());
        }
        return file;
    }

    public static Boolean exists(CharSequence path) {
        return CndFileSystemProvider.getDefault().existsImpl(path);
    }

    public static Boolean canRead(CharSequence path) {
        return CndFileSystemProvider.getDefault().canReadImpl(path);
    }

    public static FileInfo[] getChildInfo(CharSequence path) {
        return CndFileSystemProvider.getDefault().getChildInfoImpl(path);
    }

    public static FileObject toFileObject(CharSequence absPath) {
        FileObject result = CndFileSystemProvider.getDefault().toFileObjectImpl(absPath);
        CndUtils.assertNotNull(result, "Null file object for " + absPath);
        return result;
    }

    public static FileObject urlToFileObject(CharSequence url) {
        return CndFileSystemProvider.getDefault().urlToFileObjectImpl(url);
    }

    public static CharSequence toUrl(FSPath fsPath) {
        return CndFileSystemProvider.getDefault().toUrlImpl(fsPath);
    }

    public static CharSequence toUrl(FileSystem fileSystem, CharSequence absPath) {
        return CndFileSystemProvider.getDefault().toUrlImpl(fileSystem, absPath);
    }

    public static CharSequence fileObjectToUrl(FileObject fileObject) {
        CharSequence result = CndFileSystemProvider.getDefault().fileObjectToUrlImpl(fileObject);
        CndUtils.assertNotNull(result, "Null URL for file object " + fileObject);
        return result;
    }

    public static CharSequence getCanonicalPath(FileSystem fileSystem, CharSequence absPath) throws IOException {
        CndUtils.assertAbsolutePathInConsole(((Object)absPath).toString());
        return CndFileSystemProvider.getDefault().getCanonicalPathImpl(fileSystem, absPath);
    }

    protected abstract Boolean existsImpl(CharSequence var1);

    protected abstract Boolean canReadImpl(CharSequence var1);

    protected abstract FileInfo[] getChildInfoImpl(CharSequence var1);

    protected abstract FileObject toFileObjectImpl(CharSequence var1);

    protected abstract CharSequence fileObjectToUrlImpl(FileObject var1);

    protected abstract CharSequence toUrlImpl(FSPath var1);

    protected abstract CharSequence toUrlImpl(FileSystem var1, CharSequence var2);

    protected abstract FileObject urlToFileObjectImpl(CharSequence var1);

    protected abstract String getCaseInsensitivePathImpl(CharSequence var1);

    protected abstract CharSequence getCanonicalPathImpl(FileSystem var1, CharSequence var2) throws IOException;

    private static class DefaultProvider
    extends CndFileSystemProvider {
        private CndFileSystemProvider[] cache;
        private FileSystem fileFileSystem;

        DefaultProvider() {
            Collection instances = Lookup.getDefault().lookupAll(CndFileSystemProvider.class);
            this.cache = instances.toArray(new CndFileSystemProvider[instances.size()]);
        }

        private synchronized FileSystem getFileFileSystem() {
            if (this.fileFileSystem == null) {
                File tmpDirFile = new File(System.getProperty("java.io.tmpdir"));
                FileObject tmpDirFo = FileUtil.toFileObject((File)(tmpDirFile = CndFileUtils.normalizeFile(tmpDirFile)));
                if (tmpDirFo != null) {
                    try {
                        this.fileFileSystem = tmpDirFo.getFileSystem();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
                if (this.fileFileSystem == null) {
                    this.fileFileSystem = InvalidFileObjectSupport.getDummyFileSystem();
                }
            }
            return this.fileFileSystem;
        }

        @Override
        public FileObject toFileObjectImpl(CharSequence absPath) {
            FileObject fo;
            for (CndFileSystemProvider provider : this.cache) {
                fo = provider.toFileObjectImpl(absPath);
                if (fo == null) continue;
                return fo;
            }
            File file = new File(FileUtil.normalizePath((String)((Object)absPath).toString()));
            fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((File)file);
            }
            return fo;
        }

        @Override
        protected Boolean canReadImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                Boolean result = provider.canReadImpl(path);
                if (result == null) continue;
                return result;
            }
            return new File(((Object)path).toString()).canRead();
        }

        @Override
        protected Boolean existsImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                Boolean result = provider.existsImpl(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        protected FileInfo[] getChildInfoImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                FileInfo[] result = provider.getChildInfoImpl(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        protected FileObject urlToFileObjectImpl(CharSequence url) {
            for (CndFileSystemProvider provider : this.cache) {
                FileObject fo = provider.urlToFileObjectImpl(url);
                if (fo == null) continue;
                return fo;
            }
            File file = new File(FileUtil.normalizePath((String)((Object)url).toString()));
            return FileUtil.toFileObject((File)file);
        }

        @Override
        protected CharSequence fileObjectToUrlImpl(FileObject fileObject) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence path = provider.fileObjectToUrlImpl(fileObject);
                if (path == null) continue;
                return path;
            }
            return fileObject.getPath();
        }

        @Override
        protected CharSequence toUrlImpl(FSPath fSPath) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence url = provider.toUrlImpl(fSPath);
                if (url == null) continue;
                return url;
            }
            return fSPath.getPath();
        }

        @Override
        protected CharSequence toUrlImpl(FileSystem fileSystem, CharSequence absPath) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence url = provider.toUrlImpl(fileSystem, absPath);
                if (url == null) continue;
                return url;
            }
            return absPath;
        }

        @Override
        public String getCaseInsensitivePathImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                String data = provider.getCaseInsensitivePathImpl(path);
                if (data == null) continue;
                return data;
            }
            return ((Object)path).toString();
        }

        @Override
        protected CharSequence getCanonicalPathImpl(FileSystem fileSystem, CharSequence absPath) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence canonical = provider.getCanonicalPathImpl(fileSystem, absPath);
                if (canonical == null) continue;
                return canonical;
            }
            return absPath;
        }
    }

    public static class FileInfo {
        public final String absolutePath;
        public final boolean directory;

        public FileInfo(String absolutePath, boolean directory) {
            this.absolutePath = absolutePath;
            this.directory = directory;
        }
    }
}

