/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.javame;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.mobility.editor.pub.J2MEDataObject;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.io.ProjectTypeInfo;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandlerSupport;
import org.netbeans.modules.vmd.io.javame.MEDesignDataObject;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MEDesignEditorSupport
extends J2MEDataObject.J2MEEditorSupport
implements EditorCookie.Observable,
OpenCookie,
EditCookie,
PrintCookie {
    private MEDesignDataObject dataObject;
    private CloseOperationHandler closeHandler;
    private TopComponent mvtc;
    private MultiViewDescription[] descriptions;
    private boolean useEditPriority;
    private GuardsEditor guardsEditor;
    private GuardedSectionsProvider sections;
    private UndoRedo.Manager undoRedoManager;
    private FileSystem.AtomicAction atomicSaveAction = new FileSystem.AtomicAction(){

        public void run() throws IOException {
            MEDesignEditorSupport.this.saveDocumentCore();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getClass().equals(obj.getClass());
        }
    };

    public MEDesignEditorSupport(MEDesignDataObject dataObject) {
        super((J2MEDataObject)dataObject, (CloneableEditorSupport.Env)new Env(dataObject));
        this.dataObject = dataObject;
        this.closeHandler = new CloseHandler(dataObject);
    }

    public void saveDocument() throws IOException {
        this.dataObject.getPrimaryFile().getFileSystem().runAtomicAction(this.atomicSaveAction);
    }

    public void saveDocumentCore() throws IOException {
        DocumentSerializer documentSerializer = IOSupport.getDocumentSerializer((DataObject)this.dataObject);
        documentSerializer.waitDocumentLoaded();
        IOSupport.forceUpdateCode((DataObject)this.dataObject);
        documentSerializer.saveDocument();
        super.saveDocument();
    }

    public boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.updateDisplayName();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.updateDisplayName();
    }

    protected void notifyClosed() {
        this.mvtc = null;
        super.notifyClosed();
        IOSupport.notifyDataObjectClosed((DataObject)this.dataObject);
    }

    public void open() {
        this.useEditPriority = false;
        DataObjectContext context = IOSupport.getDataObjectContext((DataObject)this.dataObject);
        Project project = ProjectUtils.getProject((DataObjectContext)context);
        if (project == null || !(project instanceof J2MEProject)) {
            DocumentErrorHandler errorHandler = new DocumentErrorHandler().addError(NbBundle.getMessage(MEDesignEditorSupport.class, (String)"MSG_ProjectMissing"));
            DocumentErrorHandlerSupport.showDocumentErrorHandlerDialog((DocumentErrorHandler)errorHandler, (FileObject)this.dataObject.getPrimaryFile());
            return;
        }
        String projectType = IOSupport.resolveProjectType((DataObjectContext)context);
        if (projectType == null) {
            return;
        }
        super.open();
        TopComponent mvtc = this.mvtc;
        if (mvtc != null) {
            MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)mvtc);
            int index = this.getIndex();
            if (index >= 0) {
                MultiViewPerspective perspective = handler.getPerspectives()[index];
                handler.requestActive(perspective);
                handler.requestVisible(perspective);
            }
        }
    }

    public void edit() {
        this.useEditPriority = true;
        DataObjectContext context = IOSupport.getDataObjectContext((DataObject)this.dataObject);
        if (context == null || ProjectUtils.getProject((DataObjectContext)context) == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MEDesignEditorSupport.class, (String)"MSG_Edit_Templates"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        String projectType = IOSupport.resolveProjectType((DataObjectContext)IOSupport.getDataObjectContext((DataObject)this.dataObject));
        if (projectType == null) {
            return;
        }
        super.open();
        TopComponent mvtc = this.mvtc;
        if (mvtc != null) {
            MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)mvtc);
            int index = this.getIndex();
            if (index >= 0) {
                MultiViewPerspective perspective = handler.getPerspectives()[index];
                handler.requestActive(perspective);
                handler.requestVisible(perspective);
            }
        }
    }

    private int getIndex() {
        MultiViewDescription[] descriptions = this.descriptions;
        if (descriptions == null) {
            return -1;
        }
        int bestPriority = Integer.MIN_VALUE;
        int bestIndex = -1;
        int index = 0;
        for (MultiViewDescription description : this.descriptions) {
            int priority;
            DataEditorView dataEditorView = IOSupport.getDataEditorView((MultiViewDescription)description);
            int n = priority = this.useEditPriority ? dataEditorView.getEditPriority() : dataEditorView.getOpenPriority();
            if (priority > bestPriority) {
                bestPriority = priority;
                bestIndex = index;
            }
            ++index;
        }
        return bestIndex;
    }

    public void initializeCloneableEditor(CloneableEditor editor) {
        super.initializeCloneableEditor(editor);
    }

    protected CloneableEditorSupport.Pane createPane() {
        String projectType = IOSupport.resolveProjectType((DataObjectContext)IOSupport.getDataObjectContext((DataObject)this.dataObject));
        if (projectType == null) {
            return super.createPane();
        }
        this.descriptions = IOSupport.createEditorSupportPane((DataObjectContext)IOSupport.getDataObjectContext((DataObject)this.dataObject));
        int index = this.getIndex();
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])this.descriptions, (MultiViewDescription)(index >= 0 ? this.descriptions[index] : null), (CloseOperationHandler)this.closeHandler);
    }

    public void setMVTC(TopComponent mvtc) {
        this.mvtc = mvtc;
        this.updateDisplayName();
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        CloneableTopComponent tc = super.createCloneableTopComponent();
        this.mvtc = tc;
        this.updateDisplayName();
        return tc;
    }

    public void updateDisplayName() {
        final TopComponent tc = this.mvtc;
        if (tc == null) {
            return;
        }
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectTypeInfo projectTypeInfo = ProjectTypeInfo.getProjectTypeInfoFor((String)IOSupport.getDataObjectContext((DataObject)MEDesignEditorSupport.this.dataObject).getProjectType());
                tc.setIcon(projectTypeInfo != null ? ImageUtilities.loadImage((String)projectTypeInfo.getIconResource()) : null);
                String displayName = MEDesignEditorSupport.this.messageHtmlName();
                if (!displayName.equals(tc.getDisplayName())) {
                    tc.setDisplayName(displayName);
                }
                tc.setToolTipText(MEDesignEditorSupport.this.dataObject.getPrimaryFile().getPath());
            }
        });
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.undoRedoManager = super.createUndoRedoManager();
        return this.undoRedoManager;
    }

    void discardAllEdits() {
        this.undoRedoManager.discardAllEdits();
    }

    FileSystem.AtomicAction getAtomicSaveAction() {
        return this.atomicSaveAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKitHook(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        if (this.sections == null) {
            this.guardsEditor = new GuardsEditor(doc);
            String mimeType = ((CloneableEditorSupport.Env)this.env).getMimeType();
            GuardedSectionsFactory factory = GuardedSectionsFactory.find((String)mimeType);
            this.sections = factory.create((GuardedEditorSupport)this.guardsEditor);
        } else {
            this.guardsEditor.setDocument(doc);
        }
        if (this.sections != null) {
            Reader reader = this.sections.createGuardedReader(stream, this.getEncoding());
            try {
                kit.read(reader, (Document)doc, 0);
            }
            finally {
                reader.close();
            }
        } else {
            super.loadFromStreamToKitHook(doc, stream, kit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStreamHook(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        if (this.sections != null) {
            Writer w = this.sections.createGuardedWriter(stream, this.getEncoding());
            try {
                kit.write(w, (Document)doc, 0, doc.getLength());
            }
            finally {
                w.close();
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    private class GuardsEditor
    implements GuardedEditorSupport {
        private StyledDocument document;

        public GuardsEditor(StyledDocument document) {
            this.document = document;
        }

        public StyledDocument getDocument() {
            return this.document;
        }

        public void setDocument(StyledDocument document) {
            this.document = document;
        }
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -1L;
        private MEDesignDataObject dataObject;

        public CloseHandler(MEDesignDataObject dataObject) {
            this.dataObject = dataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] elements) {
            MEDesignEditorSupport editorSupport = this.dataObject.getEditorSupport();
            boolean can = editorSupport.canClose();
            if (can) {
                editorSupport.notifyClosed();
            }
            return can;
        }
    }

    protected static class Env
    extends J2MEDataObject.J2MEEditorSupport.Environment {
        private static final long serialVersionUID = -1L;

        public Env(J2MEDataObject obj) {
            super(obj);
        }

        protected FileLock takeLock() throws IOException {
            try {
                FileLock l = super.takeLock();
                IOSupport.setDocumentUpdatingEnabled((DataObject)this.getDataObject(), (boolean)true);
                return l;
            }
            catch (IOException e) {
                IOSupport.setDocumentUpdatingEnabled((DataObject)this.getDataObject(), (boolean)false);
                throw e;
            }
        }
    }
}

