/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.netbeans.modules.cnd.dwarfdump.reader.MyRandomAccessFile;

public class ByteStreamReader
implements DataInput {
    private MyRandomAccessFile file = null;
    private String fileName;
    private int dataEncoding = 0;
    private int fileClass = 0;
    private byte address_size = (byte)-1;
    public static final int LSB = 1;
    public static final int MSB = 2;
    private final byte[] buffer = new byte[8];

    public ByteStreamReader(String fname, MyRandomAccessFile reader) {
        this.file = reader;
        this.fileName = fname;
    }

    public void dispose() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.file = null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDataEncoding(int encoding) {
        if (encoding == 1 || encoding == 2) {
            this.dataEncoding = encoding;
            if (encoding == 1) {
                this.file.getBuffer().order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.file.getBuffer().order(ByteOrder.BIG_ENDIAN);
            }
        } else {
            throw new IllegalArgumentException("Wrong Data Encoding specified (" + encoding + ").");
        }
    }

    public int getDataEncoding() {
        return this.dataEncoding;
    }

    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void setAddressSize(byte size) {
        this.address_size = size;
    }

    public byte getAddressSize() {
        return this.address_size;
    }

    public long readNumber(int size) throws IOException {
        assert (size <= 8);
        long n = 0L;
        this.file.readFully(this.buffer, 0, size);
        for (int i = 0; i < size; ++i) {
            long u = 0L;
            u = this.dataEncoding == 1 ? (long)(0xFF & this.buffer[i]) : (long)(0xFF & this.buffer[size - i - 1]);
            n |= u << i * 8;
        }
        return n;
    }

    public short readShort() throws IOException {
        return this.file.getBuffer().getShort();
    }

    public int readInt() throws IOException {
        return this.file.getBuffer().getInt();
    }

    public long readDWlen() throws IOException {
        long res = this.readInt();
        if (res == -1L) {
            res = this.readLong();
        }
        return res;
    }

    public long readLong() throws IOException {
        return this.file.getBuffer().getLong();
    }

    public byte[] read(byte[] b) throws IOException {
        this.readFully(b);
        return b;
    }

    public void readFully(byte[] b) throws IOException {
        this.file.getBuffer().get(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.file.getBuffer().get(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.file.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.file.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.file.getBuffer().get();
    }

    public int readUnsignedByte() throws IOException {
        return this.file.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.file.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.file.readChar();
    }

    public float readFloat() throws IOException {
        return this.file.readFloat();
    }

    public double readDouble() throws IOException {
        return this.file.readDouble();
    }

    public String readLine() throws IOException {
        return this.file.readLine();
    }

    public String readUTF() throws IOException {
        return this.file.readUTF();
    }

    public String readUTF(int len) throws IOException {
        byte[] bytes = new byte[len + 2];
        bytes[1] = (byte)(0xFF & len);
        bytes[0] = (byte)(0xFF & len >> 8);
        this.readFully(bytes, 2, len);
        return new DataInputStream(new ByteArrayInputStream(bytes)).readUTF();
    }

    private int readLEB128(boolean signed) throws IOException {
        int result = 0;
        int shift = 0;
        int b = 128;
        while ((0x80 & b) != 0) {
            b = this.file.readByte();
            result |= (0x7F & b) << shift;
            shift += 7;
        }
        if (signed && shift < 32 && (0x40 & b) != 0) {
            result |= -(1 << shift);
        }
        return result;
    }

    public int readUnsignedLEB128() throws IOException {
        return this.readLEB128(false);
    }

    public int readSignedLEB128() throws IOException {
        return this.readLEB128(true);
    }

    public int getFileClass() {
        return this.fileClass;
    }

    public void setFileClass(int fileClass) {
        if (fileClass != 1 && fileClass != 2) {
            throw new IllegalArgumentException("Wrong File Class specified (" + fileClass + ").");
        }
        this.fileClass = fileClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() throws IOException {
        StringBuilder str = new StringBuilder();
        long beg = this.getFilePointer();
        int b = -1;
        boolean isUTF = false;
        while (b != 0) {
            b = this.readByte() & 0xFF;
            if (b != 0) {
                str.append((char)b);
            }
            if (b <= 127) continue;
            isUTF = true;
        }
        if (isUTF) {
            long end = this.getFilePointer();
            this.seek(beg);
            try {
                String s;
                String string = s = this.readUTF(str.length());
                return string;
            }
            catch (IOException ex) {
                String string = str.toString();
                return string;
            }
            finally {
                this.seek(end);
            }
        }
        return str.toString();
    }

    public boolean is32Bit() {
        return this.fileClass == 1;
    }

    public boolean is64Bit() {
        return this.fileClass == 2;
    }

    public long read3264() throws IOException {
        return this.fileClass == 1 ? (long)this.readInt() : this.readLong();
    }
}

