/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.model.actions;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsPresenter;

public abstract class ActionsPresenterForwarder
extends ActionsPresenter {
    private Class actionToInherit;
    private WeakReference<DesignComponent> targetComponent;

    public static ActionsPresenterForwarder byReference(final String referencePropertyName, Class actionsToInherit) {
        return new ActionsPresenterForwarder(actionsToInherit){

            @Override
            protected DesignComponent getTargetComponent() {
                if (referencePropertyName == null) {
                    throw new IllegalArgumentException("Argument referencePropertyName is null");
                }
                return this.getComponent().readProperty(referencePropertyName).getComponent();
            }
        };
    }

    public static ActionsPresenterForwarder byParent(Class actionsToInherit) {
        return new ActionsPresenterForwarder(actionsToInherit){

            @Override
            protected DesignComponent getTargetComponent() {
                return this.getComponent().getParentComponent();
            }
        };
    }

    private ActionsPresenterForwarder(Class actionToInherit) {
        this.actionToInherit = actionToInherit;
    }

    @Override
    public List<Action> getActions() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ActionsPresenterForwarder.this.targetComponent = new WeakReference<DesignComponent>(ActionsPresenterForwarder.this.getTargetComponent());
            }
        });
        if (this.targetComponent == null) {
            throw new IllegalStateException(this.getComponent() + " has no target component");
        }
        ArrayList<Action> filteredActions = null;
        if (this.targetComponent.get() == null) {
            return Collections.emptyList();
        }
        Collection<ActionsPresenter> presenters = ((DesignComponent)this.targetComponent.get()).getPresenters(ActionsPresenter.class);
        for (ActionsPresenter presenter : presenters) {
            List<Action> pa = presenter.getActions();
            for (Action action : pa) {
                if (action == null || this.actionToInherit != action.getClass()) continue;
                if (filteredActions == null) {
                    filteredActions = new ArrayList<Action>();
                }
                filteredActions.add(action);
            }
        }
        return filteredActions;
    }

    @Override
    public DesignComponent getRelatedComponent() {
        return this.getComponent();
    }

    @Override
    public Integer getOrder() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ActionsPresenterForwarder.this.targetComponent = new WeakReference<DesignComponent>(ActionsPresenterForwarder.this.getTargetComponent());
            }
        });
        if (this.targetComponent == null) {
            throw new IllegalStateException(this.getComponent() + " has no target component");
        }
        Collection<ActionsPresenter> presenters = ((DesignComponent)this.targetComponent.get()).getPresenters(ActionsPresenter.class);
        for (ActionsPresenter presenter : presenters) {
            List<Action> pa = presenter.getActions();
            for (Action action : pa) {
                if (action == null || this.actionToInherit != action.getClass()) continue;
                return presenter.getOrder();
            }
        }
        return null;
    }

    protected abstract DesignComponent getTargetComponent();
}

