/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.EnumDescriptor;
import org.netbeans.modules.vmd.api.model.EnumDescriptorFactory;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Lookup;

final class EnumDescriptorFactoryRegistry {
    private static final Lookup.Result<EnumDescriptorFactory> factoriesLookupResult = Lookup.getDefault().lookupResult(EnumDescriptorFactory.class);

    EnumDescriptorFactoryRegistry() {
    }

    static EnumDescriptor getDescriptor(String projectType, TypeID type) {
        assert (Debug.isFriend(PropertyValue.class));
        assert (type.getKind() == TypeID.Kind.ENUM);
        assert (type.getDimension() == 0);
        for (EnumDescriptorFactory factory : factoriesLookupResult.allInstances()) {
            EnumDescriptor descriptor;
            if (projectType == null || !projectType.equals(factory.getProjectType()) || (descriptor = factory.getDescriptorForTypeIDString(type.getString())) == null) continue;
            return descriptor;
        }
        throw Debug.error("No EnumDescriptorFactory found", type);
    }
}

