/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.classpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassPathSupportCallbackImpl
implements ClassPathSupport.Callback {
    public static final String ELEMENT_INCLUDED_LIBRARIES = "included-library";
    private static String[] ejbjarElemOrder = new String[]{"name", "minimum-ant-version", "explicit-platform", "use-manifest", "included-library", "web-services", "source-roots", "test-roots"};
    private static final String ATTR_DIRS = "dirs";
    public static final String INCLUDE_IN_DEPLOYMENT = "includeInDeployment";
    private AntProjectHelper helper;

    public ClassPathSupportCallbackImpl(AntProjectHelper helper) {
        this.helper = helper;
    }

    private static List<String> getIncludedLibraries(AntProjectHelper antProjectHelper, String includedLibrariesElement, Map<String, String> destination) {
        assert (antProjectHelper != null);
        assert (includedLibrariesElement != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList libs = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", includedLibrariesElement);
        ArrayList<String> libraries = new ArrayList<String>(libs.getLength());
        for (int i = 0; i < libs.getLength(); ++i) {
            Element item = (Element)libs.item(i);
            String ref = "${" + XMLUtil.findText((Node)item) + "}";
            libraries.add(ref);
            String dirs = item.getAttribute(ATTR_DIRS);
            if (!"100".equals(dirs) && !"200".equals(dirs) && !"300".equals(dirs)) continue;
            destination.put(ref, dirs);
        }
        return libraries;
    }

    private static void putIncludedLibraries(List<ClassPathSupport.Item> classpath, AntProjectHelper antProjectHelper, String includedLibrariesElement) {
        assert (antProjectHelper != null);
        assert (includedLibrariesElement != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList libs = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", includedLibrariesElement);
        while (libs.getLength() > 0) {
            Node n = libs.item(0);
            n.getParentNode().removeChild(n);
        }
        Document doc = data.getOwnerDocument();
        for (ClassPathSupport.Item item : classpath) {
            if (!"true".equals(item.getAdditionalProperty(INCLUDE_IN_DEPLOYMENT))) continue;
            XMLUtil.appendChildElement((Element)data, (Element)ClassPathSupportCallbackImpl.createLibraryElement(antProjectHelper, doc, item, includedLibrariesElement), (String[])ejbjarElemOrder);
        }
        antProjectHelper.putPrimaryConfigurationData(data, true);
    }

    private static Element createLibraryElement(AntProjectHelper antProjectHelper, Document doc, ClassPathSupport.Item item, String includedLibrariesElement) {
        Element libraryElement = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", includedLibrariesElement);
        libraryElement.appendChild(doc.createTextNode(CommonProjectUtils.getAntPropertyName((String)item.getReference())));
        Util.updateDirsAttributeInCPSItem((ClassPathSupport.Item)item, (Element)libraryElement);
        return libraryElement;
    }

    public void readAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
        HashMap<String, String> destination = new HashMap<String, String>();
        List<String> l = ClassPathSupportCallbackImpl.getIncludedLibraries(this.helper, projectXMLElement, destination);
        for (ClassPathSupport.Item item : items) {
            boolean b = l.contains(item.getReference());
            item.setAdditionalProperty(INCLUDE_IN_DEPLOYMENT, Boolean.toString(b));
            String dest = (String)destination.get(item.getReference());
            if (!b || dest == null) continue;
            item.setAdditionalProperty("destinationDirectory", dest);
        }
    }

    public void storeAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
        ClassPathSupportCallbackImpl.putIncludedLibraries(items, this.helper, projectXMLElement);
    }
}

