/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public final class RepositoryInfo {
    static final String DEFAULT_INDEX_SUFFIX = ".index/";
    private String id;
    private String type;
    private String name;
    private String repositoryPath;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public RepositoryInfo(String id, String type, String name, String repositoryPath, String repositoryUrl) {
        this(id, type, name, repositoryPath, repositoryUrl, null);
    }

    public RepositoryInfo(String id, String type, String name, String repositoryPath, String repositoryUrl, String indexUpdateUrl) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.repositoryPath = repositoryPath;
        if (repositoryUrl != null && !repositoryUrl.endsWith("/")) {
            repositoryUrl = repositoryUrl + "/";
        }
        this.repositoryUrl = repositoryUrl;
        String string = this.indexUpdateUrl = indexUpdateUrl != null ? indexUpdateUrl : (repositoryUrl != null ? repositoryUrl + DEFAULT_INDEX_SUFFIX : null);
        if (!this.isLocal() ^ this.isRemoteDownloadable()) {
            throw new IllegalArgumentException("Cannot have both local and remote index fields filled in. Repository: " + id + " Path=" + repositoryPath + " Remote URL:" + indexUpdateUrl);
        }
    }

    public static RepositoryInfo createRepositoryInfo(FileObject fo) {
        String name;
        String type = (String)fo.getAttribute("provider");
        if (type == null) {
            type = "nexus";
        }
        String id = fo.getName();
        try {
            name = fo.getFileSystem().getStatus().annotateName(id, Collections.singleton(fo));
        }
        catch (FileStateInvalidException x) {
            name = id;
        }
        String path = (String)fo.getAttribute("path");
        String repourl = (String)fo.getAttribute("repoUrl");
        String indexurl = (String)fo.getAttribute("repoIndexUrl");
        return new RepositoryInfo(id, type, name, path, repourl, indexurl);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getIndexUpdateUrl() {
        return this.indexUpdateUrl;
    }

    public boolean isRemoteDownloadable() {
        return this.indexUpdateUrl != null;
    }

    public boolean isLocal() {
        return this.repositoryPath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeIndex() {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public String toString() {
        return this.id;
    }
}

