/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;

public final class QueryRequest
extends Observable {
    private List<QueryField> queryFields;
    private String className;
    private RepositoryInfo[] repositories;
    private boolean queryFinished;
    private final List<NBVersionInfo> results = new ArrayList<NBVersionInfo>();

    public QueryRequest(List<QueryField> fields, RepositoryInfo[] repos, Observer observer) {
        this.queryFields = fields;
        this.repositories = repos;
        this.addObserver(observer);
        this.queryFinished = false;
    }

    public QueryRequest(String classname, RepositoryInfo[] repos, Observer observer) {
        this.className = classname;
        this.repositories = repos;
        this.addObserver(observer);
        this.queryFinished = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeFields(List<QueryField> newFields) {
        List<NBVersionInfo> list = this.results;
        synchronized (list) {
            this.queryFields = newFields;
            this.queryFinished = false;
            this.results.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        List<NBVersionInfo> list = this.results;
        synchronized (list) {
            return this.queryFinished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NBVersionInfo> getResults() {
        List<NBVersionInfo> list = this.results;
        synchronized (list) {
            return this.results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(List<NBVersionInfo> newResults, boolean queryFinished) {
        List<NBVersionInfo> list = this.results;
        synchronized (list) {
            if (null != newResults) {
                this.results.addAll(newResults);
            }
            if (queryFinished) {
                this.queryFinished = true;
                Collections.sort(this.results);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public List<QueryField> getQueryFields() {
        assert (this.queryFields != null);
        return this.queryFields;
    }

    public String getClassName() {
        assert (this.className != null);
        return this.className;
    }

    public RepositoryInfo[] getRepositories() {
        return this.repositories;
    }
}

