/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStart;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStartManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Error;
import org.netbeans.modules.cnd.debugger.common2.debugger.EvalAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EvaluationWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.LocalModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.Location;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.MacroSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.SignalDialog;
import org.netbeans.modules.cnd.debugger.common2.debugger.StackModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.modules.cnd.debugger.common2.debugger.ThreadModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.VarContinuation;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Controller;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisFragModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblerWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.RegistersWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.StateModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerCommand;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerExpert;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.IOPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.debugger.common2.utils.FileMapper;
import org.netbeans.modules.cnd.debugger.common2.utils.InfoPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.ItemSelectorResult;
import org.netbeans.modules.cnd.debugger.common2.utils.ListMapItem;
import org.netbeans.modules.cnd.debugger.common2.utils.StopWatch;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionClient;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;
import org.netbeans.modules.cnd.debugger.gdb2.Disassembly;
import org.netbeans.modules.cnd.debugger.gdb2.Gdb;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerInfo;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.gdb2.GdbEngineCapabilityProvider;
import org.netbeans.modules.cnd.debugger.gdb2.GdbEngineProvider;
import org.netbeans.modules.cnd.debugger.gdb2.GdbError;
import org.netbeans.modules.cnd.debugger.gdb2.GdbFrame;
import org.netbeans.modules.cnd.debugger.gdb2.GdbHandlerExpert;
import org.netbeans.modules.cnd.debugger.gdb2.GdbLocal;
import org.netbeans.modules.cnd.debugger.gdb2.GdbThread;
import org.netbeans.modules.cnd.debugger.gdb2.GdbUtils;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVersionPeculiarity;
import org.netbeans.modules.cnd.debugger.gdb2.GdbWatch;
import org.netbeans.modules.cnd.debugger.gdb2.Log;
import org.netbeans.modules.cnd.debugger.gdb2.VariableBag;
import org.netbeans.modules.cnd.debugger.gdb2.actions.GdbStartActionProvider;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIUserInteraction;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.text.Line;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GdbDebuggerImpl
extends NativeDebuggerImpl
implements BreakpointProvider,
Gdb.Factory.Listener {
    private GdbEngineProvider engineProvider;
    private Gdb gdb;
    private GdbVersionPeculiarity peculiarity;
    private static final Logger LOG = Logger.getLogger(GdbDebuggerImpl.class.toString());
    private final GdbHandlerExpert handlerExpert;
    private MILocation homeLoc;
    private boolean dynamicType;
    private DisModel disModel = new DisModel();
    private DisController disController = new DisController();
    private final Disassembly disassembly;
    private boolean update_dis = true;
    private final VariableBag variableBag = new VariableBag();
    private GdbDebuggerInfo gdi;
    private Gdb.Factory factory;
    private static boolean warnUnsupported = false;
    private String firstBreakpointId = null;
    private static final int PRINT_REPEAT = Integer.getInteger("gdb.print.repeat", 0);
    private static final int STACK_MAX_DEPTH = Integer.getInteger("gdb.stack.maxdepth", 1024);
    private GdbThread[] threads = new GdbThread[0];
    private int current_thread_index;
    private boolean get_threads = false;
    private boolean get_frames = false;
    static String corrupt_stack = "Previous frame identical to this frame (corrupt stack?)";
    boolean try_one_more = false;
    private boolean get_watches = false;
    public static final String STRUCT_VALUE = "{...}";
    private boolean get_locals = false;
    private int local_count;
    private GdbVariable[] local_vars = new GdbVariable[0];
    private static final int MEMORY_READ_WIDTH = 16;
    private Map<Integer, String> regNames = null;
    private boolean get_registers = false;

    public GdbDebuggerImpl(ContextProvider ctxProvider) {
        super(ctxProvider);
        List l = this.debuggerEngine.lookup(null, DebuggerEngineProvider.class);
        for (int lx = 0; lx < l.size(); ++lx) {
            if (!(l.get(lx) instanceof GdbEngineProvider)) continue;
            this.engineProvider = (GdbEngineProvider)((Object)l.get(lx));
        }
        if (this.engineProvider == null) {
            throw new IllegalArgumentException("GdbDebuggerImpl not started via GdbEngineProvider");
        }
        this.state().capabAutoRun = false;
        this.profileBridge = new GdbDebuggerSettingsBridge((NativeDebugger)this);
        this.handlerExpert = new GdbHandlerExpert(this);
        this.disassembly = new Disassembly(this, (BreakpointModel)this.breakpointModel());
        this.disStateModel().addListener((StateModel.Listener)this.disassembly);
    }

    public String debuggerType() {
        return "gdb";
    }

    public Gdb gdb() {
        return this.gdb;
    }

    private boolean isConnected() {
        return this.gdb != null && this.gdb.connected() && !this.postedKillEngine;
    }

    public void rememberDDI(GdbDebuggerInfo gdi) {
        this.gdi = gdi;
    }

    public NativeDebuggerInfo getNDI() {
        return this.gdi;
    }

    boolean isShortName() {
        DebuggerOption option = DebuggerOption.OUTPUT_SHORT_FILE_NAME;
        return option.isEnabled((OptionSet)this.optionLayers());
    }

    public void start(GdbDebuggerInfo gdi) {
        ExternalStart xstart;
        if (Log.Start.debug) {
            int act = gdi.getAction();
            System.out.printf("START ==========\n\t", new Object[0]);
            if ((act & 1) != 0) {
                System.out.printf("RUN ", new Object[0]);
            }
            if ((act & 2) != 0) {
                System.out.printf("STEP ", new Object[0]);
            }
            if ((act & 4) != 0) {
                System.out.printf("ATTACH ", new Object[0]);
            }
            if ((act & 8) != 0) {
                System.out.printf("CORE ", new Object[0]);
            }
            if ((act & 0x10) != 0) {
                System.out.printf("LOAD ", new Object[0]);
            }
            if ((act & 0x20) != 0) {
                System.out.printf("CONNECT ", new Object[0]);
            }
            System.out.printf("\n", new Object[0]);
        }
        this.rememberDDI(gdi);
        this.session().setSessionHost(gdi.getHostName());
        this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
        final boolean connectExisting = (gdi.getAction() & 0x20) != 0;
        this.profileBridge.setup((NativeDebuggerInfo)gdi);
        if (!connectExisting) {
            int flags = 0;
            if (Log.Startup.nopty) {
                flags |= 1;
            }
            this.executor = Executor.getDefault((String)Catalog.get("Gdb"), (Host)this.getHost(), (int)flags);
        }
        final String[] additionalArgv = null;
        if (gdi.isCaptured() && (xstart = ExternalStartManager.getXstart((Host)this.getHost())) != null) {
            xstart.debuggerStarted();
        }
        if (DebuggerManager.isAsyncStart()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GdbDebuggerImpl.this.start2(GdbDebuggerImpl.this.executor, additionalArgv, GdbDebuggerImpl.this, connectExisting);
                }
            });
        } else {
            this.start2(this.executor, additionalArgv, this, connectExisting);
        }
    }

    private void start2(Executor executor, String[] additionalArgv, Gdb.Factory.Listener listener, boolean connectExisting) {
        String gdbInitFile = DebuggerOption.GDB_INIT_FILE.getCurrValue((OptionSet)this.optionLayers());
        String runDir = this.gdi.getProfile().getRunDirectory();
        runDir = this.localToRemote("gdbRunDirectory", runDir);
        this.factory = new Gdb.Factory(executor, additionalArgv, listener, false, this.isShortName(), gdbInitFile, this.getHost(), connectExisting, runDir, this.gdi);
        this.factory.start();
    }

    @Override
    public void assignGdb(Gdb tentativeGdb) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.assignGdb()\n", new Object[0]);
        }
        this.gdb = tentativeGdb;
        this.gdb.setDebugger(this);
        GdbStartActionProvider.succeeded();
        DebuggerManager.get().setCurrentDebugger((NativeDebugger)this);
    }

    @Override
    public void assignIOPack(IOPack ioPack) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.assignIOPack()\n", new Object[0]);
        }
        this.setIOPack(ioPack);
    }

    @Override
    public void connectFailed(String toWhom, String why, IOPack ioPack) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.connectFailed()\n", new Object[0]);
        }
        String msg = Catalog.format("ConnectionFailed", toWhom, why);
        Gdb.dyingWords(msg, ioPack);
        this.session.kill();
    }

    private void warnVersionUnsupported(double gdbVersion) {
        if (!warnUnsupported) {
            InfoPanel panel = new InfoPanel(Catalog.format("ERR_UnsupportedVersion", gdbVersion), Catalog.get("MSG_Do_Not_Show_Again_In_Session"));
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)panel, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            warnUnsupported = panel.dontShowAgain();
        }
    }

    void setGdbVersion(String version) {
        double gdbVersion = 6.8;
        try {
            gdbVersion = GdbUtils.parseVersionString(version);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to parse gdb version {0}", version);
        }
        this.peculiarity = GdbVersionPeculiarity.create(gdbVersion, this.getHost().getPlatform());
        if (!this.peculiarity.isSupported()) {
            this.warnVersionUnsupported(gdbVersion);
        }
    }

    public final void kill() {
        Disassembly.close();
        super.preKill();
        this.optionLayers().save();
        IOPack ioPack = this.getIOPack();
        if (ioPack != null) {
            ioPack.bringDown();
            ioPack.close();
        }
        this.session = null;
        this.state().isLoaded = false;
        this.stateChanged();
        this.postedKillEngine = true;
        this.engineProvider.getDestructor().killEngine();
    }

    public void postKill() {
        this.postedKill = true;
        if (this.gdb != null && this.gdb.connected()) {
            if (!this.pause(true)) {
                try {
                    this.executor.terminate();
                    this.kill();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return;
            }
            MiCommandImpl cmd = new MiCommandImpl("-gdb-exit"){

                protected void onError(MIRecord record) {
                    this.finish();
                }

                protected void onExit(MIRecord record) {
                    GdbDebuggerImpl.this.kill();
                    this.finish();
                }
            };
            this.gdb.sendCommand(cmd);
        } else {
            this.kill();
        }
    }

    public void shutDown() {
        this.postKill();
    }

    public final void stepInto() {
        this.sendResumptive("-exec-step");
    }

    public final void stepIntoMain() {
        this.send("-break-insert -t main");
        this.sendResumptive("-exec-run");
        this.sendPidCommand(false);
    }

    public final void stepOver() {
        this.sendResumptive("-exec-next");
    }

    public final void stepOut() {
        this.send("-stack-select-frame 0");
        this.execFinish();
    }

    private void execFinish() {
        this.sendResumptive("-exec-finish");
    }

    public final void pathmap(String pathmap) {
        this.send(pathmap);
    }

    private void notImplemented(String method) {
        System.out.printf("NOT IMPLEMENTED: GdbDebuggerImpl.%s()\n", method);
    }

    public final void stepTo(String function) {
        this.notImplemented("stepTo");
    }

    public final void go() {
        this.sendResumptive("-exec-continue");
    }

    public void doMIAttach(GdbDebuggerInfo gdi) {
        final long pid = gdi.getPid();
        String cmdString = "attach " + Long.toString(pid);
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.state().isProcess = true;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                GdbDebuggerImpl.this.session().setPid(pid);
                GdbDebuggerImpl.this.requestStack(null);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void doMICorefile(GdbDebuggerInfo gdi) {
        String corefile = gdi.getCorefile();
        String cmdString = "core " + corefile;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.state().isCore = true;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                GdbDebuggerImpl.this.requestStack(null);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void contAt(String src, int line) {
        this.notImplemented("-exec-jump");
    }

    public void runToCursor(String src, int line) {
        src = this.localToRemote("runToCursor", src);
        String cmdString = "-exec-until " + src + ":" + line;
        this.sendResumptive(cmdString);
    }

    public GdbVersionPeculiarity getGdbVersionPeculiarity() {
        return this.peculiarity;
    }

    public void pause() {
        this.pause(false);
    }

    public boolean pause(boolean silentStop) {
        int pid = (int)this.session().getPid();
        if (pid > 0) {
            return this.gdb.pause(pid, silentStop);
        }
        return false;
    }

    public void interrupt() {
        this.gdb.interrupt();
    }

    public void terminate() {
        this.notImplemented("terminate");
    }

    public void detach() {
        this.notImplemented("detach");
    }

    private static int extractPid1(MIRecord record) {
        StringTokenizer st = new StringTokenizer(record.command().getConsoleStream());
        int pid = 0;
        if (st.hasMoreTokens()) {
            st.nextToken();
            if (st.hasMoreTokens()) {
                int pidEnd;
                String pidStr = st.nextToken();
                for (pidEnd = 0; pidEnd < pidStr.length() && Character.isDigit(pidStr.charAt(pidEnd)); ++pidEnd) {
                }
                try {
                    pid = Integer.parseInt(pidStr.substring(0, pidEnd));
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)new Exception("Pid parsing error: " + record.command().getConsoleStream(), e));
                }
            }
        }
        return pid;
    }

    private int extractPid2(String console) {
        int pid = 0;
        if (Log.Gdb.pid) {
            System.out.printf("//////// '%s'\n", console);
        }
        if (console != null) {
            StringTokenizer st = new StringTokenizer(console);
            int ntokens = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (Log.Gdb.pid) {
                    System.out.printf("\t%d: '%s'\n", ntokens, token);
                }
                if (ntokens == 3) {
                    String pidStr = token;
                    pid = Integer.parseInt(pidStr);
                    break;
                }
                ++ntokens;
            }
        }
        if (Log.Gdb.pid) {
            System.out.printf("\\\\\\\\ pid %d\n", pid);
        }
        return pid;
    }

    private void sendPidCommand(boolean resume) {
        if (this.session().getPid() <= 0L) {
            if (this.getHost().getPlatform() == Platform.Windows_x86) {
                InfoThreadsMICmd findPidCmd = new InfoThreadsMICmd(resume);
                this.gdb.sendCommand(findPidCmd);
            } else if (this.getHost().getPlatform() != Platform.MacOSX_x86) {
                InfoProcMICmd findPidCmd = new InfoProcMICmd(resume);
                InfoThreadsMICmd findPidCmd2 = new InfoThreadsMICmd(resume);
                findPidCmd.chain(null, findPidCmd2);
                this.gdb.sendCommand(findPidCmd);
            }
        } else if (resume) {
            this.go();
        }
    }

    private void setFirstBreakpointId(MIRecord record) {
        MIValue numberValue;
        MIValue bkptValue = record.results().valueOf("bkpt");
        if (bkptValue != null && (numberValue = bkptValue.asTList().valueOf("number")) != null) {
            this.firstBreakpointId = numberValue.asConst().value();
        }
    }

    public void rerun() {
        MiCommandImpl breakStartCmd = new MiCommandImpl("-break-insert -t _start"){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setFirstBreakpointId(record);
                super.onDone(record);
            }
        };
        breakStartCmd.setEmptyDoneIsError();
        MiCommandImpl breakMainCmd = new MiCommandImpl("-break-insert -t main"){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setFirstBreakpointId(record);
                super.onDone(record);
            }
        };
        breakMainCmd.setEmptyDoneIsError();
        MIResumptiveCommand runCmd = new MIResumptiveCommand("-exec-run"){

            protected void onRunning(MIRecord record) {
                GdbDebuggerImpl.this.state().isProcess = true;
                super.onRunning(record);
            }
        };
        breakStartCmd.chain(runCmd, breakMainCmd);
        breakMainCmd.chain(runCmd, null);
        if (this.getHost().getPlatform() == Platform.MacOSX_x86) {
            this.gdb.sendCommand(breakMainCmd);
        } else {
            this.gdb.sendCommand(breakStartCmd);
        }
    }

    public void makeCalleeCurrent() {
        GdbFrame frame = this.getCurrentFrame();
        if (frame != null) {
            String number = frame.getNumber();
            this.makeFrameCurrent(this.getStack()[Integer.valueOf(number) - 1]);
        }
    }

    public void makeCallerCurrent() {
        GdbFrame frame = this.getCurrentFrame();
        if (frame != null) {
            String number = frame.getNumber();
            this.makeFrameCurrent(this.getStack()[Integer.valueOf(number) + 1]);
        }
    }

    public void popToHere(Frame frame) {
        String number = frame.getNumber();
        this.makeFrameCurrent(this.getStack()[Integer.valueOf(number) - 1]);
        this.execFinish();
    }

    public void popTopmostCall() {
        this.stepOut();
    }

    public void popLastDebuggerCall() {
    }

    public void popToCurrentFrame() {
        this.makeCalleeCurrent();
        this.execFinish();
    }

    public void initializeGdb(FileMapper fmap) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.initializeGdb()\n", new Object[0]);
        }
        assert (this.isConnected()) : "initializeGdb() called when gdb wasn't ready";
        if (this.getHost().isRemote()) {
            this.fmap = FileMapper.getDefault((FileMapper.Type)FileMapper.Type.NULL);
        } else if (fmap != null) {
            this.fmap = fmap;
        }
        this.manager().initialUnsavedFiles((NativeDebugger)this);
        if (this.gdi.isCaptured()) {
            this.setCaptureState(NativeDebuggerImpl.CaptureState.INITIAL);
            this.setCaptureInfo(this.gdi.getCaptureInfo());
        } else assert (this.getCaptureState() == NativeDebuggerImpl.CaptureState.NONE);
        this.send("-gdb-set print repeat " + PRINT_REPEAT);
        this.send("-gdb-set backtrace limit " + STACK_MAX_DEPTH);
        if (this.getHost().getPlatform() == Platform.Windows_x86 && this.getIOPack().isExternal()) {
            this.send("set new-console");
        }
        this.debug(this.gdi);
        this.manager().setCurrentSession(null);
        this.manager().setCurrentSession(this.session.coreSession());
    }

    private void initialAction() {
        if (DebuggerManager.isStartModel() && this.gdi != null) {
            if ((this.gdi.getAction() & 1) != 0) {
                this.rerun();
                this.gdi.removeAction(1);
            }
            if ((this.gdi.getAction() & 4) != 0) {
                this.doMIAttach(this.gdi);
                this.gdi.removeAction(4);
            }
            if ((this.gdi.getAction() & 8) != 0) {
                this.doMICorefile(this.gdi);
                this.gdi.removeAction(8);
            }
            if ((this.gdi.getAction() & 2) != 0) {
                this.stepIntoMain();
                this.gdi.removeAction(2);
            }
        }
    }

    void noteProgLoaded(String progname) {
        this.profileBridge().noteProgLoaded(progname);
        this.manager().formatStatusText("ReadyToRun", null);
        DebuggerManager.get().addRecentDebugTarget(progname, false);
        if (Log.Bpt.fix6810534) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GdbDebuggerImpl.this.initialAction();
                }
            });
        } else {
            this.initialAction();
        }
    }

    public OptionClient getOptionClient() {
        return null;
    }

    public String getDebuggingOption(String name) {
        this.notImplemented("getDebuggingOption");
        return null;
    }

    public void setOption(String name, String value) {
        this.notImplemented("setOption() " + name + " " + value);
    }

    public void setAccessChecking(boolean enable) {
    }

    public void setMemuseChecking(boolean enable) {
    }

    public void setLeaksChecking(boolean enable) {
    }

    private void overrideOptions() {
    }

    private String getErrMsg(MIRecord record) {
        String errMsg = null;
        if (record.isError()) {
            errMsg = record.error();
        } else if (!record.isEmpty()) {
            MIValue value = record.results().valueOf("msg");
            errMsg = value.asConst().value();
        } else {
            if (record.command() != null) {
                errMsg = record.command().getLogStream();
            }
            if (errMsg == null) {
                errMsg = Catalog.get("MSG_UnknownFailure");
            }
        }
        return errMsg;
    }

    private void genericFailure(MIRecord record) {
        String errMsg = this.getErrMsg(record);
        this.manager().error(record.command().routingToken(), (Error)new GdbError(errMsg), (NativeDebugger)this);
    }

    private void unexpected(String what, String command) {
        System.out.println("Unexpcted callback '" + what + "' on '" + command + "'");
    }

    void genericRunning() {
        this.clearFiredEvents();
        this.deleteMarkLocations();
        this.deliverSignal = -1;
        this.stateSetRunning(true);
        this.stateChanged();
        this.session().setSessionState(this.state());
        this.setStatusText(Catalog.get("MSG_running"));
    }

    private boolean dontKillOnExit() {
        return !DebuggerOption.FINISH_SESSION.isEnabled((OptionSet)this.optionLayers()) || (this.gdi.getAction() & 0x10) != 0;
    }

    private void noteProcGone(String reason, MITList results) {
        this.session().setPid(-1L);
        this.session().setCorefile(null);
        this.session().update();
        this.session().setSessionEngine(null);
        this.state().isProcess = false;
        this.state().isCore = false;
        this.stateSetRunning(false);
        this.stateChanged();
        this.session().setSessionState(this.state());
        this.clearFiredEvents();
        String msg = "";
        boolean skipkill = false;
        if ("exited-normally".equals(reason)) {
            String exitcodeString = "0";
            msg = Catalog.format("ProgCompletedExit", "0");
            skipkill = this.dontKillOnExit();
        } else if ("exited".equals(reason)) {
            MIValue exitcodeValue = results.valueOf("exit-code");
            String exitcodeString = exitcodeValue.asConst().value();
            msg = Catalog.format("ProgCompletedExit", exitcodeString);
            skipkill = this.dontKillOnExit();
        } else if ("exited-signalled".equals(reason)) {
            MIValue signalnameValue = results.valueOf("signal-name");
            String signalnameString = signalnameValue.asConst().value();
            msg = Catalog.format("ProgAborted", signalnameString);
        } else {
            msg = "Stopped for unrecognized reason: " + reason;
        }
        this.setStatusText(msg);
        if (!skipkill && DebuggerManager.isStartModel()) {
            this.postKill();
        }
        this.resetCurrentLine();
    }

    public boolean isMultiThreading() {
        return false;
    }

    public void registerThreadModel(ThreadModel model) {
        if (Log.Variable.mi_threads) {
            System.out.println("registerThreadModel " + model);
        }
        this.threadUpdater.setListener((ModelListener)model);
        if (model != null) {
            this.get_threads = true;
            if (this.state().isProcess && !this.state().isRunning) {
                this.showThreads();
            }
        } else {
            this.get_threads = false;
        }
    }

    public Thread[] getThreads() {
        return this.threads;
    }

    public void makeThreadCurrent(Thread thread) {
        if (!thread.isCurrent()) {
            String tid = ((GdbThread)thread).getId();
            this.selectThread(-1, tid, true);
        }
    }

    private void getAllThreads(MIRecord thread) {
        MITList threadresults = thread.results();
        MITList thread_ids = (MITList)threadresults.valueOf("thread-ids");
        MIValue tid = threadresults.valueOf("number-of-threads");
        String current_tid_no = tid.asConst().value();
        if (Log.Variable.mi_threads) {
            System.out.println("threads " + threadresults.toString());
            System.out.println("thread_ids " + thread_ids.toString());
        }
        int size = thread_ids.size();
        this.threads = new GdbThread[size];
        for (int vx = 0; vx < size; ++vx) {
            MIResult thread_id = (MIResult)thread_ids.get(vx);
            String id_no = thread_id.value().asConst().value();
            if (Log.Variable.mi_threads) {
                System.out.println("threads_id " + thread_id.toString());
                System.out.println("thread_ id " + id_no);
            }
            if (id_no.equals(current_tid_no)) {
                this.current_thread_index = vx;
                continue;
            }
            this.selectThread(vx, id_no, false);
        }
        this.selectThread(this.current_thread_index, current_tid_no, true);
    }

    private void updateLocalsForSelectFrame() {
        if (this.get_locals) {
            this.getMILocals(false);
        }
    }

    private void setCurrentThread(int index, MIRecord threadframe, boolean isCurrent) {
        MITList threadresults = threadframe.results();
        MIValue tid = threadresults.valueOf("new-thread-id");
        String tid_no = tid.asConst().value();
        MIValue frame = threadresults.valueOf("frame");
        if (Log.Variable.mi_threads) {
            System.out.println("threadframe " + threadresults.toString());
            System.out.println("tid_no " + tid);
            System.out.println("frame " + frame.toString());
        }
        GdbFrame f = new GdbFrame(this, frame, null);
        if (index != -1) {
            this.threads[index] = new GdbThread((NativeDebugger)this, this.threadUpdater, tid_no, f);
        }
        if (isCurrent) {
            this.selectFrame(f.getNumber());
            if (!f.getLineNo().equals("")) {
                this.getFullPath(f);
            }
            for (int tx = 0; tx < this.threads.length; ++tx) {
                if (this.threads[tx].getId().equals(tid_no)) {
                    this.threads[tx].setCurrent(true);
                    continue;
                }
                this.threads[tx].setCurrent(false);
            }
        }
        if (isCurrent || index == this.threads.length - 1) {
            this.threadUpdater.treeChanged();
        }
    }

    private void selectThread(final int index, String id_no, final boolean isCurrent) {
        MiCommandImpl cmd = new MiCommandImpl("-thread-select " + id_no){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setCurrentThread(index, record, isCurrent);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void showThreads() {
        MiCommandImpl cmd = new MiCommandImpl("-thread-list-ids"){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.getAllThreads(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void registerStackModel(StackModel model) {
        if (Log.Variable.mi_frame) {
            System.out.println("registerStackModel " + model);
        }
        this.stackUpdater.setListener((ModelListener)model);
        this.get_frames = model != null;
    }

    public Frame[] getStack() {
        if (this.guiStackFrames == null) {
            return new GdbFrame[0];
        }
        return this.guiStackFrames;
    }

    public void postVerboseStack(boolean v) {
    }

    public GdbFrame getCurrentFrame() {
        if (this.guiStackFrames != null) {
            for (Frame frame : this.guiStackFrames) {
                if (!frame.isCurrent()) continue;
                return (GdbFrame)frame;
            }
            return (GdbFrame)this.guiStackFrames[0];
        }
        return null;
    }

    public void moreFrame() {
    }

    public void makeFrameCurrent(Frame f) {
        String fno = f.getNumber();
        boolean changed = false;
        if (this.guiStackFrames != null) {
            for (Frame frame : this.guiStackFrames) {
                if (frame.getNumber().equals(fno)) {
                    changed = true;
                    frame.setCurrent(true);
                    continue;
                }
                frame.setCurrent(false);
            }
        }
        if (changed) {
            this.selectFrame(fno);
            this.getFullPath((GdbFrame)f);
        }
        this.stackUpdater.treeChanged();
    }

    private void visitCurrentSrc(GdbFrame f, MIRecord srcRecord) {
        MITList srcTuple = srcRecord.results();
        if (f == null) {
            f = new GdbFrame(this, null, null);
        }
        MILocation l = MILocation.make((NativeDebugger)this, f.getMIframe(), srcTuple, false, this.getStack().length, null);
        if (this.homeLoc == null) {
            this.homeLoc = l;
        }
        boolean visited = this.state().isProcess ? !l.equals((Object)this.homeLoc) : true;
        this.visitedLocation = MILocation.make(l, visited);
        this.setVisitedLocation(this.visitedLocation);
        this.state().isUpAllowed = !l.bottomframe();
        this.state().isDownAllowed = !l.topframe();
        this.stateChanged();
    }

    private void getFullPath(final GdbFrame f) {
        MiCommandImpl cmd = new MiCommandImpl("-file-list-exec-source-file"){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.visitCurrentSrc(f, record);
                this.finish();
            }
        };
        cmd.dontReportError();
        this.gdb.sendCommand(cmd);
    }

    private void selectFrame(Object fno) {
        MiCommandImpl cmd = new MiCommandImpl("-stack-select-frame " + fno){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateLocalsForSelectFrame();
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void setStackWithArgs(MIRecord framerecords, MIRecord args) {
        MITList args_list = null;
        if (args != null) {
            MITList argsresults = args.results();
            args_list = (MITList)argsresults.valueOf("stack-args");
            String stringframes = args_list.toString();
            if (Log.Variable.mi_frame) {
                System.out.println("args_list " + stringframes);
            }
        }
        MITList results = framerecords.results();
        MITList stack_list = (MITList)results.valueOf("stack");
        int size = stack_list.size();
        this.guiStackFrames = new GdbFrame[size];
        for (int vx = 0; vx < size; ++vx) {
            MIResult frame = (MIResult)stack_list.get(vx);
            MIResult frameArgs = null;
            if (args_list != null && vx <= args_list.size()) {
                frameArgs = (MIResult)args_list.get(vx);
            }
            this.guiStackFrames[vx] = new GdbFrame(this, frame.value(), frameArgs);
            if (vx != 0) continue;
            this.guiStackFrames[vx].setCurrent(true);
        }
        if (this.get_locals) {
            this.getMILocals(true);
        }
        this.stackUpdater.treeChanged();
    }

    private void setStack(final MIRecord framerecords) {
        String args_command = "-stack-list-arguments 1";
        MiCommandImpl cmd = new MiCommandImpl(args_command){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onDone(MIRecord record) {
                try {
                    GdbDebuggerImpl.this.setStackWithArgs(framerecords, record);
                }
                finally {
                    this.finish();
                }
            }

            protected void onError(MIRecord record) {
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (errMsg.equals(corrupt_stack)) {
                    GdbDebuggerImpl.this.setStack(framerecords);
                } else {
                    GdbDebuggerImpl.this.setStackWithArgs(framerecords, null);
                }
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void balloonEvaluate(int pos, String text) {
        if (this.gdb == null || !this.gdb.connected()) {
            return;
        }
        if (this.state().isProcess && this.state().isRunning) {
            return;
        }
        String expr = pos == -1 ? text : EvalAnnotation.extractExpr((int)pos, (String)text);
        if (expr != null) {
            this.dataMIEval(expr);
        }
    }

    public void postExprQualify(String expr, NativeDebugger.QualifiedExprListener qeListener) {
    }

    private void dataMIEval(final String expr) {
        String expandedExpr = MacroSupport.expandMacro((NativeDebugger)this, (String)expr);
        String cmdString = "-data-evaluate-expression \"" + expandedExpr + "\"";
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpEvalResult(expr, record);
                this.finish();
            }

            protected void onError(MIRecord record) {
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void interpEvalResult(String expr, MIRecord record) {
        MITList value = record.results();
        if (Log.Variable.mi_vars) {
            System.out.println("value " + value.toString());
        }
        String value_string = value.valueOf("value").asConst().value();
        EvalAnnotation.postResult((int)0, (int)0, (int)0, (String)expr, (String)value_string, null, null);
    }

    public void postCreateWatch(int routingToken, NativeWatch newWatch) {
    }

    public boolean watchError(int rt, Error error) {
        return false;
    }

    public WatchVariable[] getWatches() {
        return (WatchVariable[])this.watches.toArray((ListMapItem[])new WatchVariable[this.watches.size()]);
    }

    public void replaceWatch(NativeWatch original, String replacewith) {
        original.postDelete(false);
        this.manager().createWatch(replacewith.trim());
    }

    protected void restoreWatch(NativeWatch template) {
        GdbWatch gdbWatch;
        NativeWatch nativeWatch = template;
        String key = nativeWatch.getExpression();
        if (this.watches.byKey((Object)key) != null) {
            gdbWatch = new GdbWatch((NativeDebugger)this, this.watchUpdater(), nativeWatch.getExpression());
            String msg = String.format("Duplicate of %d", 999);
            gdbWatch.setAsText(msg);
        } else {
            gdbWatch = new GdbWatch((NativeDebugger)this, this.watchUpdater(), nativeWatch.getExpression());
            this.createMIVar(gdbWatch);
        }
        this.updateMIVar();
        nativeWatch.setSubWatchFor((WatchVariable)gdbWatch, (NativeDebugger)this);
        this.watches.add((ListMapItem)gdbWatch);
        this.manager().bringDownDialog();
        this.watchUpdater().treeChanged();
    }

    public void postDeleteAllWatches() {
    }

    public void postDeleteWatch(final WatchVariable variable, final boolean spreading) {
        if (!(variable instanceof GdbWatch)) {
            return;
        }
        GdbWatch watch = (GdbWatch)variable;
        if (watch.getMIName() == null) {
            this.deleteWatch(variable, spreading);
        } else {
            DeleteMIVarCommand cmd = new DeleteMIVarCommand(watch){

                protected void onDone(MIRecord record) {
                    super.onDone(record);
                    GdbDebuggerImpl.this.deleteWatch(variable, spreading);
                }

                protected void onError(MIRecord record) {
                    super.onDone(record);
                    GdbDebuggerImpl.this.deleteWatch(variable, spreading);
                }
            };
            this.gdb.sendCommand(cmd);
        }
    }

    public void postDynamicWatch(Variable variable) {
    }

    public void postInheritedWatch(Variable watch) {
    }

    public void deleteVar(Variable var, MIRecord record) {
        this.variableBag.remove_count = 0;
        this.variableBag.remove(var);
        if (Log.Variable.mi_vars) {
            System.out.println("variableBag.remove_count " + this.variableBag.remove_count);
        }
        this.variableBag.remove_count = 0;
    }

    public void registerWatchModel(WatchModel model) {
        if (Log.Variable.mi_vars) {
            System.out.println("registerWatchModel " + model);
        }
        this.watchUpdater().setListener((ModelListener)model);
        if (model != null) {
            this.get_watches = true;
            if (this.state().isProcess && !this.state().isRunning) {
                this.updateWatches();
            }
        } else {
            this.get_watches = false;
        }
    }

    private void retryWatches() {
        for (WatchVariable wv : this.watches) {
            GdbWatch w = (GdbWatch)wv;
            this.createMIVar(w);
        }
    }

    private void updateWatches() {
        this.retryWatches();
        this.updateMIVar();
    }

    private void updateVarAttr(GdbVariable v, MIRecord attr, boolean evalValue) {
        MITList attr_results = attr.results();
        String value = attr_results.valueOf("attr").asConst().value();
        v.setEditable(value);
        if (v.isEditable() && evalValue) {
            this.evalMIVar(v);
        }
    }

    private void updateValue(GdbVariable v, MIRecord varvalue) {
        MITList value_results = varvalue.results();
        MIValue miValue = value_results.valueOf("value");
        String value = null;
        if (miValue != null) {
            value = miValue.asConst().value();
        }
        value = GdbDebuggerImpl.processValue(value);
        v.setAsText(value);
        if (v.isWatch()) {
            this.watchUpdater().treeNodeChanged((Object)v);
        } else {
            this.localUpdater.treeNodeChanged((Object)v);
        }
    }

    private static String processValue(String value) {
        if (value == null) {
            return STRUCT_VALUE;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return STRUCT_VALUE;
        }
        return value;
    }

    private void interpMIChildren(GdbVariable parent, MIRecord miRecord, int level) {
        MITList results = miRecord.results();
        String count = results.valueOf("numchild").asConst().value();
        MITList children_list = (MITList)results.valueOf("children");
        int size = Integer.parseInt(count);
        ArrayList<GdbVariable> children = new ArrayList<GdbVariable>();
        for (int vx = 0; vx < size; ++vx) {
            MIResult childresult = (MIResult)children_list.get(vx);
            String qname = childresult.value().asTuple().valueOf("name").asConst().value();
            String exp = childresult.value().asTuple().valueOf("exp").asConst().value();
            String numchild = childresult.value().asTuple().valueOf("numchild").asConst().value();
            String value = childresult.value().asTuple().valueOf("value").asConst().value();
            MIValue mitype = childresult.value().asTuple().valueOf("type");
            String type = "";
            if (mitype != null) {
                type = mitype.asConst().value();
            }
            if (exp.equals("private") || exp.equals("public") || exp.equals("protected")) {
                this.getMIChildren(parent, qname, level + 1);
                continue;
            }
            try {
                Integer.parseInt(exp);
                exp = parent.getVariableName() + '[' + exp + ']';
            }
            catch (Exception e) {
                // empty catch block
            }
            GdbVariable childvar = new GdbVariable(this, parent.getUpdater(), parent, exp, null, null, parent.isWatch());
            value = GdbDebuggerImpl.processValue(value);
            childvar.setAsText(value);
            childvar.setType(type);
            childvar.setMIName(qname);
            childvar.setNumChild(numchild);
            this.variableBag.add(childvar);
            children.add(childvar);
            this.attrMIVar(childvar, false);
        }
        GdbVariable[] vars = new GdbVariable[children.size()];
        if (level == 0) {
            parent.setChildren(children.toArray(vars), true);
        } else {
            parent.addChildren(children.toArray(vars), true);
        }
    }

    private void interpUpdate(MIRecord var) {
        MITList varsresults = var.results();
        MITList update_list = (MITList)varsresults.valueOf("changelist");
        if (Log.Variable.mi_vars) {
            System.out.println("update_list " + update_list.toString());
        }
        for (MITListItem item : update_list) {
            GdbVariable wv;
            MIValue updatevar;
            if (update_list.isResultList()) {
                MIResult result = (MIResult)item;
                assert (result.variable().equals("varobj"));
                updatevar = result.value();
            } else {
                updatevar = (MIValue)item;
            }
            String mi_name = updatevar.asTuple().valueOf("name").asConst().value();
            String in_scope = updatevar.asTuple().valueOf("in_scope").asConst().value();
            if (Log.Variable.mi_vars) {
                System.out.println("update name " + mi_name + " in_scope " + in_scope);
            }
            if ((wv = this.variableBag.get(mi_name, true, 3)) == null) continue;
            if (wv instanceof GdbWatch && in_scope != null) {
                GdbWatch w = (GdbWatch)wv;
                w.setInScope(Boolean.parseBoolean(in_scope));
            }
            this.evalMIVar(wv);
        }
    }

    public void setDynamicType(boolean b) {
        String cmdString = b ? "-gdb-set print object on" : "-gdb-set print object off";
        this.send(cmdString);
        this.dynamicType = b;
    }

    public boolean isDynamicType() {
        return this.dynamicType;
    }

    public boolean isStaticMembers() {
        return true;
    }

    public void setStaticMembers(boolean b) {
    }

    public boolean isInheritedMembers() {
        return true;
    }

    public void setInheritedMembers(boolean b) {
    }

    public String[] formatChoices() {
        return new String[]{"binary", "octal", "decimal", "hexadecimal", "natural"};
    }

    private void interpVarFormat(GdbVariable v, MIRecord record) {
        MITList format_results = record.results();
        String format = format_results.valueOf("format").asConst().value();
        v.setFormat(format);
        this.evalMIVar(v);
    }

    void postVarFormat(final GdbVariable v, String format) {
        String expr = v.getMIName();
        String cmdString = "-var-set-format " + expr + " " + format;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpVarFormat(v, record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void interpVar(GdbVariable v, MIRecord var) {
        MITList results = var.results();
        String mi_name = results.valueOf("name").asConst().value();
        String type = results.valueOf("type").asConst().value();
        String numchild = results.valueOf("numchild").asConst().value();
        v.setMIName(mi_name);
        v.setType(type);
        v.setNumChild(numchild);
        GdbVariable wv = this.variableBag.get(mi_name, true, 3);
        if (wv == null) {
            this.variableBag.add(v);
        }
        this.attrMIVar(v, true);
    }

    private void attrMIVar(final GdbVariable v, final boolean evalValue) {
        String expr = v.getMIName();
        String cmdString = "-var-show-attributes " + expr;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateVarAttr(v, record, evalValue);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void updateMIVar() {
        String cmdString = "-var-update * ";
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpUpdate(record);
                this.finish();
            }

            protected void onError(MIRecord record) {
                String out_of_scope;
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (GdbDebuggerImpl.this.try_one_more && errMsg.equals(corrupt_stack)) {
                    GdbDebuggerImpl.this.try_one_more = true;
                }
                if (!errMsg.equals(out_of_scope = "mi_cmd_var_assign: Could not assign expression to varible object")) {
                    GdbDebuggerImpl.this.genericFailure(record);
                    this.finish();
                }
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void evalMIVar(final GdbVariable v) {
        String mi_name = v.getMIName();
        String cmdString = "-var-evaluate-expression " + mi_name;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateValue(v, record);
                this.finish();
            }

            protected void onError(MIRecord record) {
                String out_of_scope;
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (!errMsg.equals(out_of_scope = "mi_cmd_var_assign: Could not assign expression to varible object")) {
                    GdbDebuggerImpl.this.genericFailure(record);
                    this.finish();
                }
            }
        };
        this.gdb.sendCommand(cmd);
    }

    void getMIChildren(final GdbVariable parent, String expr, final int level) {
        String cmdString = "-var-list-children --all-values " + expr;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpMIChildren(parent, record, level);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void createMIVar(final GdbVariable v) {
        String expr = MacroSupport.expandMacro((NativeDebugger)this, (String)v.getVariableName());
        String cmdString = "-var-create - * " + expr;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                v.setAsText(GdbDebuggerImpl.STRUCT_VALUE);
                v.setInScope(true);
                GdbDebuggerImpl.this.updateValue(v, record);
                GdbDebuggerImpl.this.interpVar(v, record);
                this.finish();
            }

            protected void onError(MIRecord record) {
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                v.setAsText(errMsg);
                v.setInScope(false);
                this.finish();
                GdbDebuggerImpl.this.watchUpdater().treeChanged();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void registerLocalModel(LocalModel model) {
        if (Log.Variable.mi_vars) {
            System.out.println("registerLocalModel " + model);
        }
        this.localUpdater.setListener((ModelListener)model);
        if (model != null) {
            this.get_locals = true;
            if ((this.state().isProcess || this.state().isCore) && !this.state().isRunning) {
                this.getMILocals(false);
            }
        } else {
            this.get_locals = false;
        }
    }

    public Variable[] getLocals() {
        return this.local_vars;
    }

    public int getLocalsCount() {
        return this.local_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> requestAutos() {
        Set autoNames = super.requestAutos();
        LinkedList<GdbVariable> res = new LinkedList<GdbVariable>();
        for (String auto : autoNames) {
            GdbVariable var = this.variableBag.get(auto, false, 3);
            if (var == null) {
                var = new GdbWatch((NativeDebugger)this, this.watchUpdater(), auto);
                this.createMIVar(var);
            }
            res.add(var);
        }
        ArrayList arrayList = this.autos;
        synchronized (arrayList) {
            this.autos.clear();
            this.autos.addAll(res);
        }
        return autoNames;
    }

    public void setShowAutos(boolean showAutos) {
        super.setShowAutos(showAutos);
        if (this.gdb != null && this.gdb.connected() && showAutos) {
            this.requestAutos();
        }
    }

    private void setLocals(boolean update_var, MIRecord locals) {
        GdbLocal loc;
        int vx;
        int size;
        MITList localsresults = locals.results();
        MITList locals_list = (MITList)localsresults.valueOf("locals");
        this.local_count = size = locals_list.size();
        MITList param_list = null;
        int params_count = 0;
        GdbFrame cf = this.getCurrentFrame();
        if (cf != null && (param_list = cf.getMIArgs()) != null) {
            params_count = param_list.size();
        }
        this.local_count += params_count;
        if (Log.Variable.mi_vars) {
            System.out.println("locals " + locals_list.toString());
            System.out.println("args " + param_list.toString());
            System.out.println("local_count " + this.local_count);
            System.out.println("update_var " + update_var);
        }
        this.local_vars = new GdbVariable[this.local_count];
        for (vx = 0; vx < size; ++vx) {
            MIValue localvar = (MIValue)locals_list.get(vx);
            loc = new GdbLocal(localvar);
            String var_name = loc.getName();
            GdbVariable gv = this.variableBag.get(var_name, false, 1);
            if (gv == null) {
                this.local_vars[vx] = new GdbVariable(this, this.localUpdater, null, var_name, loc.getType(), loc.getValue(), false);
                this.createMIVar(this.local_vars[vx]);
                continue;
            }
            gv.setValue(loc.getValue());
            this.local_vars[vx] = gv;
        }
        for (vx = 0; vx < params_count; ++vx) {
            MIValue param = (MIValue)param_list.get(vx);
            loc = new GdbLocal(param);
            GdbVariable gv = null;
            String var_name = loc.getName();
            String var_value = loc.getValue();
            if (var_name.equals("this")) {
                int index = var_value.indexOf("0x");
                if (var_value != null) {
                    String value_only = var_value.substring(index);
                    gv = this.variableBag.byAddr(var_name, value_only, 1);
                }
            } else {
                gv = this.variableBag.get(var_name, false, 1);
                if (gv != null) {
                    gv.setValue(var_value);
                }
            }
            if (gv == null) {
                this.local_vars[size + vx] = new GdbVariable(this, this.localUpdater, null, var_name, loc.getType(), loc.getValue(), false);
                this.createMIVar(this.local_vars[size + vx]);
                continue;
            }
            this.local_vars[size + vx] = gv;
        }
        if (update_var) {
            this.updateMIVar();
        }
        this.localUpdater.treeChanged();
    }

    private void getMILocals(final boolean update_var) {
        MiCommandImpl cmd = new MiCommandImpl("-stack-list-locals --simple-values"){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setLocals(update_var, record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void getMIDis(String command) {
        MiCommandImpl cmd = new MiCommandImpl(command){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setDis(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    protected void openDis() {
        Disassembly.open();
    }

    private void genericStoppedWithSrc(MIRecord record, MIRecord srcRecord) {
        MIValue reasonValue;
        String reason;
        MITList results;
        MITList srcResults = srcRecord == null ? null : srcRecord.results();
        MITList mITList = results = record == null ? null : record.results();
        if (results != null && results.isEmpty()) {
            results = null;
        }
        if ((reason = (reasonValue = results == null ? null : results.valueOf("reason")) == null ? "breakpoint-hit" : reasonValue.asConst().value()).equals("exited-normally")) {
            this.noteProcGone(reason, results);
            return;
        }
        if (reason.equals("exited")) {
            this.noteProcGone(reason, results);
            return;
        }
        if (reason.equals("exited-signalled")) {
            this.noteProcGone(reason, results);
            return;
        }
        if (reason.equals("breakpoint-hit") || reason.equals("end-stepping-range") || reason.equals("location-reached") || reason.equals("signal-received") || reason.equals("function-finished")) {
            MIValue frameValue;
            MIValue bkptnoValue;
            NativeBreakpoint breakpoint = null;
            MIValue mIValue = bkptnoValue = results != null ? results.valueOf("bkptno") : null;
            if (bkptnoValue != null) {
                String bkptnoString = bkptnoValue.asConst().value();
                int bkptno = Integer.parseInt(bkptnoString);
                Handler handler = this.bm().findHandler(bkptno);
                if (handler != null) {
                    handler.setFired(true);
                    breakpoint = handler.breakpoint();
                }
            }
            MIValue mIValue2 = frameValue = results != null ? results.valueOf("frame") : null;
            if (this.get_locals && frameValue != null) {
                this.guiStackFrames = new GdbFrame[1];
                this.guiStackFrames[0] = new GdbFrame(this, frameValue, null);
            }
            if (srcResults != null) {
                MITList stack = srcResults.valueOf("stack").asList();
                frameValue = ((MIResult)stack.asList().get(0)).value();
                MITList frameTuple = frameValue.asTuple();
                this.homeLoc = MILocation.make((NativeDebugger)this, frameTuple, null, false, stack.size(), breakpoint);
                this.visitedLocation = MILocation.make(this.homeLoc, false);
                this.setVisitedLocation(this.visitedLocation);
                this.state().isUpAllowed = !this.homeLoc.bottomframe();
                this.state().isDownAllowed = !this.homeLoc.topframe();
                this.setStack(srcRecord);
            }
            if (this.get_threads) {
                this.showThreads();
            }
            if (this.get_watches) {
                this.updateWatches();
            }
            if (this.get_registers) {
                this.requestRegisters();
            }
            this.state().isProcess = true;
        }
        if (record != null) {
            this.explainStop(reason, record);
        }
        this.stateSetRunning(false);
        this.stateChanged();
        this.session().setSessionState(this.state());
    }

    private boolean haveCountingBreakpoints() {
        for (Handler h : this.bm().getHandlers()) {
            NativeBreakpoint b = h.breakpoint();
            if (b == null || !b.hasCountLimit()) continue;
            return true;
        }
        return false;
    }

    private void adjustIgnore(NativeBreakpoint b, MITList props) {
        assert (b.hasCountLimit()) : "adjustIgnore() called on a bpt w/o a count limit";
        MIValue ignore = props.valueOf("ignore");
        if (ignore != null) {
            return;
        }
        long limit = b.getCountLimit();
        int newIgnore = limit == -1L ? GdbHandlerExpert.infinity : (int)limit - 1;
        this.send("-break-after " + b.getId() + ' ' + newIgnore);
    }

    private void updateCounts(MIRecord record) {
        MITList bptresults = record.results();
        MITList table = bptresults.valueOf("BreakpointTable").asTuple();
        MITList bpts = table.valueOf("body").asList();
        System.out.printf("updateCounts: %d bpts\n", bpts.size());
        for (int bx = 0; bx < bpts.size(); ++bx) {
            MIResult b = (MIResult)bpts.get(bx);
            MITList props = b.value().asTuple();
            MIValue number = props.valueOf("number");
            int hid = Integer.parseInt(number.asConst().value());
            Handler h = this.bm().findHandler(hid);
            if (h == null || !h.breakpoint().hasCountLimit()) continue;
            MIValue times = props.valueOf("times");
            int count = Integer.parseInt(times.asConst().value());
            h.setCount(count);
            this.adjustIgnore(h.breakpoint(), props);
        }
        System.out.printf("............................................\n", new Object[0]);
    }

    void genericStopped(MIRecord stopRecord) {
        MIValue signalValue;
        MIValue reasonValue;
        MIValue bkptnoValue;
        MITList results = stopRecord.results();
        if (this.firstBreakpointId != null && ((bkptnoValue = results.valueOf("bkptno")) == null || bkptnoValue != null && this.firstBreakpointId.equals(bkptnoValue.asConst().value()))) {
            this.firstBreakpointId = null;
            this.sendPidCommand(true);
            return;
        }
        if (this.gdb.isSignalled() && (reasonValue = results.valueOf("reason")) != null && "signal-received".equals(reasonValue.asConst().value()) && (signalValue = results.valueOf("signal-name")) != null) {
            String signal = signalValue.asConst().value();
            if ("SIGCONT".equals(signal)) {
                this.gdb.resetSignalled();
                this.go();
                return;
            }
            if ("SIGINT".equals(signal)) {
                if (this.gdb.isSilentStop()) {
                    this.gdb.resetSilentStop();
                    this.state().isRunning = false;
                    return;
                }
            } else if ("SIGTRAP".equals(signal) && (this.getHost().getPlatform() == Platform.Windows_x86 || this.getHost().getPlatform() == Platform.MacOSX_x86)) {
                if (this.gdb.isSilentStop()) {
                    this.gdb.resetSignalled();
                    this.state().isRunning = false;
                    return;
                }
            } else {
                this.gdb.resetSignalled();
            }
        }
        this.requestStack(stopRecord);
        if (this.haveCountingBreakpoints()) {
            MiCommandImpl cmd = new MiCommandImpl("-break-list"){

                protected void onDone(MIRecord record) {
                    GdbDebuggerImpl.this.updateCounts(record);
                    this.finish();
                }
            };
            this.gdb.sendCommand(cmd);
        }
    }

    protected void requestStack(final MIRecord stopRecord) {
        MiCommandImpl cmd = new MiCommandImpl("-stack-list-frames"){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.genericStoppedWithSrc(stopRecord, record);
                this.finish();
            }

            protected void onError(MIRecord record) {
                GdbDebuggerImpl.this.genericStoppedWithSrc(stopRecord, null);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void showSignalPopup(String description, String sigName) {
        boolean signalDiscarded;
        SignalDialog sd = new SignalDialog();
        String signame = "?";
        String signum = "?";
        String usercodename = "?";
        String usercodenum = "?";
        String senderpid = "?";
        signame = sigName;
        String signalInfo = Catalog.format("FMT_SignalInfo", signame, signum, usercodename, usercodenum);
        sd.setSignalInfo(signalInfo);
        sd.setSenderInfo(senderpid);
        if (this.session != null) {
            sd.setReceiverInfo(this.session.getShortName(), this.session.getPid());
        } else {
            sd.setReceiverInfo("", 0L);
        }
        Signals.InitialSignalInfo dsii = null;
        int signo = 0;
        int index = 0;
        DbgProfile debugProfile = this.getNDI().getDbgProfile();
        dsii = debugProfile.signals().getSignal(index);
        boolean wasIgnored = false;
        if (dsii != null) {
            wasIgnored = !dsii.isCaught();
            sd.setIgnore(true, wasIgnored);
        } else {
            sd.setIgnore(true, false);
        }
        sd.show();
        if (dsii != null && sd.isIgnore() != wasIgnored) {
            String cmd = sd.isIgnore() ? "ignore signal " + sigName : "catch signal " + sigName;
            this.send(cmd);
        }
        this.deliverSignal = (signalDiscarded = sd.discardSignal()) ? -1 : signo;
        if (sd.shouldContinue()) {
            this.go();
        }
    }

    private void explainStop(String reason, MIRecord record) {
        MITList results = record.results();
        String stateMsg = reason;
        String signalName = "<UNKNOWN>";
        if (reason.equals("end-stepping-range")) {
            stateMsg = Catalog.get("Dbx_program_stopped");
        } else if (reason.equals("signal-received")) {
            MIValue signalNameValue = results.valueOf("signal-name");
            if (signalNameValue != null) {
                signalName = signalNameValue.asConst().value();
            }
            stateMsg = Catalog.get("Dbx_signal") + " " + signalName;
        } else {
            stateMsg = reason.equals("function-finished") ? Catalog.get("Dbx_program_stopped") : (reason.equals("breakpoint-hit") ? Catalog.get("Dbx_program_stopped") : "Stopped for unrecognized reason: " + reason);
        }
        if (stateMsg != null) {
            this.setStatusText(stateMsg);
        }
        if (reason.equals("signal-received") && !this.gdb.isSignalled()) {
            this.showSignalPopup(stateMsg, signalName);
        }
    }

    private static String toCString(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block3: for (int sx = 0; sx < s.length(); ++sx) {
            char c = s.charAt(sx);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public void reuse(NativeDebuggerInfo di) {
        this.debug((GdbDebuggerInfo)di);
    }

    private void debug(GdbDebuggerInfo gdi) {
        String program = gdi.getTarget();
        long pid = gdi.getPid();
        String corefile = gdi.getCorefile();
        final boolean isCore = corefile != null;
        this.profileBridge.setup((NativeDebuggerInfo)gdi);
        if (corefile != null) {
            if (program == null) {
                program = "-";
            }
        } else if (pid != -1L) {
            if (program == null) {
                program = "-";
            }
        } else if (program == null) {
            return;
        }
        String outputFile = ((MakeConfiguration)gdi.getConfiguration()).getAbsoluteOutputValue();
        if (!CndPathUtilitities.sameString((String)program, (String)(outputFile = this.localToRemote("symbol-file", outputFile)))) {
            this.send("-file-symbol-file " + GdbDebuggerImpl.toCString(outputFile), false);
        }
        String tmp_cmd = isCore || pid != -1L ? "-file-symbol-file " : "-file-exec-and-symbols ";
        String mi_command = tmp_cmd;
        final String fprogram = program;
        String mprogram = GdbDebuggerImpl.toCString(program);
        MiCommandImpl cmd = new MiCommandImpl(mi_command + ' ' + mprogram){

            protected void onDone(MIRecord record) {
                if (isCore) {
                    GdbDebuggerImpl.this.state().isCore = true;
                } else {
                    GdbDebuggerImpl.this.getFullPath(null);
                }
                GdbDebuggerImpl.this.gdb.startProgressManager().finishProgress();
                GdbDebuggerImpl.this.session().setTarget(fprogram);
                GdbDebuggerImpl.this.session().update();
                GdbDebuggerImpl.this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
                GdbDebuggerImpl.this.state().isLoaded = true;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                GdbDebuggerImpl.this.noteProgLoaded(fprogram);
                this.finish();
            }

            protected void onError(MIRecord record) {
                GdbDebuggerImpl.this.gdb.startProgressManager().finishProgress();
                GdbDebuggerImpl.this.state().isLoaded = false;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                GdbDebuggerImpl.this.genericFailure(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public HandlerExpert handlerExpert() {
        return this.handlerExpert;
    }

    public void postRestoreHandler(int rt, HandlerCommand hc) {
        final MIRestoreBreakCommand cmd = new MIRestoreBreakCommand(rt, hc.toString());
        if (Log.Bpt.fix6810534) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GdbDebuggerImpl.this.gdb.sendCommand(cmd);
                    GdbDebuggerImpl.this.gdb.tap().inject("1\n");
                }
            });
        } else {
            this.gdb.sendCommand(cmd);
            this.gdb.tap().inject("1\n");
        }
    }

    public void registerDisassemblerWindow(DisassemblerWindow w) {
        boolean makeAsmVisible;
        assert (w == null || w == this.disassemblerWindow());
        boolean bl = makeAsmVisible = w != null;
        if (makeAsmVisible == this.isAsmVisible()) {
            return;
        }
        if (this.postedKillEngine) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (!this.viaShowLocation) {
            if (makeAsmVisible) {
                this.requestDisassembly();
            } else {
                this.requestSource(false);
            }
        }
        if (makeAsmVisible) {
            this.setAsmVisible(true);
        } else {
            this.setAsmVisible(false);
        }
    }

    protected DisFragModel disModel() {
        return this.disModel;
    }

    protected Controller disController() {
        return this.disController;
    }

    Disassembly getDisassembly() {
        return this.disassembly;
    }

    private void requestDisFromGdb(String cmd) {
        if (this.postedKill || this.postedKillEngine || this.gdb == null || cmd == null) {
            return;
        }
        this.getMIDis(cmd);
    }

    private void setDis(MIRecord record) {
        this.disModel.parseRecord(record);
        this.disassembly.update(record.toString());
        if (this.update_dis) {
            this.disStateModel().updateStateModel(this.visitedLocation, false);
        }
    }

    public void requestDisassembly() {
        Disassembly.open();
    }

    public void requestMems(String start, String length, String format, int index) {
        int lines;
        try {
            lines = (Integer.valueOf(length) - 1) / 16 + 1;
        }
        catch (Exception e) {
            return;
        }
        MiCommandImpl cmd = new MiCommandImpl("-data-read-memory " + start + " x 1 " + lines + " " + 16 + " ."){

            protected void onDone(MIRecord record) {
                if (GdbDebuggerImpl.this.memoryWindow != null) {
                    LinkedList<String> res = new LinkedList<String>();
                    for (MITListItem elem : record.results().valueOf("memory").asList()) {
                        StringBuilder sb = new StringBuilder();
                        MITList line = (MITList)elem;
                        String addr = line.valueOf("addr").asConst().value();
                        sb.append(addr).append(':');
                        MIValue dataValue = line.valueOf("data");
                        for (MITListItem dataElem : dataValue.asList()) {
                            sb.append(' ').append(((MIConst)dataElem).value());
                        }
                        String ascii = line.valueOf("ascii").asConst().value();
                        sb.append(" \"").append(ascii).append("\"");
                        res.add(sb.toString() + "\n");
                    }
                    GdbDebuggerImpl.this.memoryWindow.updateData(res);
                }
                this.finish();
            }
        };
        if (this.gdb != null) {
            this.gdb.sendCommand(cmd);
        }
    }

    public void requestRegisters() {
        MiCommandImpl cmd;
        if (this.regNames == null) {
            cmd = new MiCommandImpl("-data-list-register-names"){

                protected void onDone(MIRecord record) {
                    HashMap<Integer, String> res = new HashMap<Integer, String>();
                    int idx = 0;
                    for (MITListItem elem : record.results().valueOf("register-names").asList()) {
                        res.put(idx++, ((MIConst)elem).value());
                    }
                    GdbDebuggerImpl.this.regNames = res;
                    this.finish();
                }
            };
            if (this.gdb != null) {
                this.gdb.sendCommand(cmd);
            }
        }
        cmd = new MiCommandImpl("-data-list-register-values x"){

            protected void onDone(MIRecord record) {
                if (GdbDebuggerImpl.this.registersWindow != null) {
                    LinkedList<String> res = new LinkedList<String>();
                    for (MITListItem elem : record.results().valueOf("register-values").asList()) {
                        StringBuilder sb = new StringBuilder();
                        MITList line = (MITList)elem;
                        String number = line.valueOf("number").asConst().value();
                        try {
                            number = (String)GdbDebuggerImpl.this.regNames.get(Integer.valueOf(number));
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                        sb.append(number).append(' ');
                        String value = line.valueOf("value").asConst().value();
                        sb.append(value);
                        res.add(sb.toString());
                    }
                    GdbDebuggerImpl.this.registersWindow.updateData(res);
                }
                this.finish();
            }
        };
        if (this.gdb != null) {
            this.gdb.sendCommand(cmd);
        }
    }

    public void registerEvaluationWindow(EvaluationWindow w) {
        this.notImplemented("registerEvaluationWindow()");
    }

    private void newHandlers(int rt, MIBreakCommand cmd, MIRecord record) {
        MITList results = record.results();
        for (int tx = 0; tx < results.size(); ++tx) {
            MIResult result = (MIResult)results.get(tx);
            if (!result.matches("bkpt")) continue;
            this.newHandler(rt, cmd, result);
        }
    }

    private void newHandler(int rt, MIBreakCommand cmd, MIResult result) {
        if (Log.Bpt.pathway) {
            System.out.printf("GdbDebuggerImpl.newHandler(%s)\n", result);
        }
        Handler handler = null;
        try {
            BreakpointManager.BreakpointPlan bp = this.bm().getBreakpointPlan(rt, BreakpointManager.BreakpointMsg.NEW);
            NativeBreakpoint template = bp.template();
            switch (bp.op()) {
                case NEW: {
                    handler = this.handlerExpert.newHandler(template, result, null);
                    if (template.isEnabled()) break;
                    this.postEnableHandler(rt, handler.getId(), false);
                    break;
                }
                case RESTORE: {
                    handler = this.handlerExpert.newHandler(template, result, bp.restored());
                    if (!template.isEnabled()) {
                        this.postEnableHandler(rt, handler.getId(), false);
                    }
                    assert (handler.breakpoint() == bp.restored());
                    break;
                }
                case MODIFY: {
                    handler = bp.originalHandler();
                    handler = this.handlerExpert.replaceHandler(template, handler, result);
                }
            }
            this.handlerExpert.addAnnotations(handler, handler.breakpoint(), template, result);
            this.bm().noteNewHandler(rt, bp, handler);
        }
        catch (Exception x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    private void deleteForReplace(int rt, Handler targetHandler) {
        final int hid = targetHandler.getId();
        MIBreakCommand deleteCmd = new MIBreakCommand(rt, "-break-delete " + hid){

            protected void onDone(MIRecord record) {
                Handler h = GdbDebuggerImpl.this.bm().findHandler(hid);
                GdbDebuggerImpl.this.bm().simpleRemove(h);
                this.finish();
            }
        };
        this.gdb.sendCommand(deleteCmd);
    }

    private void replaceHandler(MIChangeBreakCommand cmd, int rt, MIResult result) {
        BreakpointManager.BreakpointPlan bp = this.bm().getBreakpointPlan(rt, BreakpointManager.BreakpointMsg.REPLACE);
        assert (bp.op() == BreakpointManager.BreakpointOp.MODIFY) : "replaceHandler(): bpt plan not CHANGE for rt " + rt;
        NativeBreakpoint targetBreakpoint = bp.target();
        assert (targetBreakpoint.isSubBreakpoint());
        assert (!targetBreakpoint.isEditable()) : "targetBreakpoint is editable";
        Handler targetHandler = targetBreakpoint.getHandler();
        assert (targetHandler == bp.originalHandler());
        Handler replacementHandler = this.handlerExpert.replaceHandler(targetBreakpoint, targetHandler, result);
        this.handlerExpert.addAnnotations(replacementHandler, null, targetBreakpoint, result);
        this.deleteForReplace(rt, targetHandler);
        this.bm().noteReplacedHandler(bp, replacementHandler);
    }

    public void runFailed() {
        this.setStatusText(Catalog.get("RunFailed"));
        this.stateSetRunning(false);
        this.stateChanged();
        this.session().setSessionState(this.state());
    }

    private boolean userInteraction(int rt, MIUserInteraction ui, boolean isBreakpoint) {
        String returnValue;
        ItemSelectorResult result;
        boolean overloadCancelled = false;
        int nitems = ui.items().length;
        String[] item = ui.items();
        if (isBreakpoint) {
            assert (rt == 0 || RoutingToken.BREAKPOINTS.isSameSubsystem(rt));
            String title = "Overloaded breakpoint";
            result = this.bm().noteMultipleBreakpoints(rt, title, nitems, item);
        } else {
            String cookie = null;
            String title = "Ambiguous symbol";
            boolean cancelable = ui.hasCancel();
            boolean multiple_selection = true;
            result = this.manager().popup(rt, cookie, (NativeDebugger)this, title, nitems, item, cancelable, multiple_selection);
        }
        if (result.isCancelled()) {
            overloadCancelled = true;
            returnValue = "" + ui.cancelChoice();
        } else if (result.nSelected() == nitems) {
            returnValue = "" + ui.allChoice();
        } else {
            returnValue = "";
            for (int sx = 0; sx < result.nSelected(); ++sx) {
                returnValue = returnValue + " " + (result.selections()[sx] + ui.firstChoice());
            }
        }
        this.gdb.tap().inject(returnValue + "\n");
        return overloadCancelled;
    }

    public void postEnableAllHandlersImpl(final boolean enable) {
        final Handler[] handlers = this.bm().getHandlers();
        if (handlers.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder();
        if (enable) {
            command.append("-break-enable");
        } else {
            command.append("-break-disable");
        }
        for (Handler h : handlers) {
            command.append(' ');
            command.append(h.getId());
        }
        MIBreakCommand cmd = new MIBreakCommand(0, command.toString()){

            protected void onDone(MIRecord record) {
                for (Handler h : handlers) {
                    h.setEnabled(enable);
                }
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void postDeleteAllHandlersImpl() {
        final Handler[] handlers = this.bm().getHandlers();
        if (handlers.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder("-break-delete");
        for (Handler h : handlers) {
            command.append(' ');
            command.append(h.getId());
        }
        MIBreakCommand cmd = new MIBreakCommand(0, command.toString()){

            protected void onDone(MIRecord record) {
                for (Handler h : handlers) {
                    GdbDebuggerImpl.this.bm().deleteHandlerById(0, h.getId());
                }
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void postDeleteHandlerImpl(final int rt, final int hid) {
        this.pause(true);
        MIBreakCommand cmd = new MIBreakCommand(rt, "-break-delete " + hid){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.bm().deleteHandlerById(rt, hid);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void postCreateHandlerImpl(int routingToken, HandlerCommand hc) {
        MIBreakLineCommand cmd = new MIBreakLineCommand(routingToken, hc.toString());
        this.pause(true);
        this.gdb.sendCommand(cmd);
    }

    public void postChangeHandlerImpl(int rt, HandlerCommand hc) {
        MIReplaceBreakLineCommand cmd = new MIReplaceBreakLineCommand(rt, hc.toString());
        this.pause(true);
        this.gdb.sendCommand(cmd);
    }

    public void postRepairHandlerImpl(int rt, HandlerCommand hc) {
        MIRepairBreakLineCommand cmd = new MIRepairBreakLineCommand(rt, hc.toString());
        this.pause(true);
        this.gdb.sendCommand(cmd);
    }

    public void setHandlerCountLimit(int hid, long countLimit) {
        this.notImplemented("setHandlerCountLimit()");
    }

    public void postEnableHandler(int rt, final int hid, final boolean enable) {
        String cmdString = enable ? "-break-enable " : "-break-disable ";
        MIBreakCommand cmd = new MIBreakCommand(rt, cmdString + hid){

            protected void onDone(MIRecord record) {
                Handler handler = GdbDebuggerImpl.this.bm().findHandler(hid);
                if (handler != null) {
                    handler.setEnabled(enable);
                }
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void postVarContinuation(VarContinuation vc) {
        this.notImplemented("postVarContinuation");
    }

    protected void postVarContinuation(int rt, VarContinuation vc) {
        this.notImplemented("postVarContinuation");
    }

    public void runArgs(String args) {
        this.sendSilent("-exec-arguments " + args);
    }

    public void runDir(String dir) {
        dir = this.localToRemote("runDir", dir);
        String cmdString = "cd " + dir;
        this.sendSilent(cmdString);
    }

    void setEnv(String envVar) {
        this.sendSilent("-gdb-set environment " + envVar);
    }

    private static String quoteValue(String value) {
        int length = value.length();
        if (length > 1 && value.charAt(0) == '\"' && value.charAt(length - 1) == '\"') {
            return value.replace("\"", "\\\"");
        }
        return value;
    }

    void assignVar(GdbVariable var, String value, boolean miVar) {
        String cmdString = miVar ? "-var-assign " + var.getMIName() + " " + value : "-data-evaluate-expression \"" + var.getFullName() + '=' + GdbDebuggerImpl.quoteValue(value) + '\"';
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateMIVar();
                this.finish();
            }

            protected void onError(MIRecord record) {
                String out_of_scope;
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (GdbDebuggerImpl.this.try_one_more && errMsg.equals(corrupt_stack)) {
                    GdbDebuggerImpl.this.try_one_more = true;
                }
                if (!errMsg.equals(out_of_scope = "mi_cmd_var_assign: Could not assign expression to varible object")) {
                    GdbDebuggerImpl.this.genericFailure(record);
                    this.finish();
                }
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void activate(boolean redundant) {
        if (this.isConnected()) {
            super.activate(redundant);
            if (this.memoryWindow != null) {
                this.memoryWindow.setDebugger((NativeDebugger)this);
            }
        } else {
            this.updateActions();
        }
        if (redundant) {
            return;
        }
    }

    public void deactivate(boolean redundant) {
        super.deactivate(redundant);
        if (redundant) {
            return;
        }
    }

    public void setCurrentDisLine(Line l) {
        this.notImplemented("setCurrentDisLine");
    }

    public Line getCurrentDisLine() {
        return null;
    }

    public void notifyUnsavedFiles(String[] file) {
    }

    public void stepOutInst() {
        this.execFinish();
    }

    public void stepOverInst() {
        this.sendResumptive("-exec-next-instruction");
    }

    public void stepInst() {
        this.sendResumptive("-exec-step-instruction");
    }

    public void runToCursorInst(String addr) {
        this.notImplemented("runToCursorInst");
    }

    public void postRestoring(boolean restoring) {
    }

    public void forkThisWay(DebuggerManager.FollowForkInfo ffi) {
        this.notImplemented("forkThisWay");
    }

    public void fix() {
        this.notImplemented("fix");
    }

    public void exprEval(String format, String expr) {
        this.notImplemented("exprEval");
    }

    public void execute(String cmd) {
        this.notImplemented("execute");
    }

    protected void stopUpdates() {
    }

    protected void startUpdates() {
    }

    private void send(String commandStr, boolean reportError) {
        MiCommandImpl cmd = new MiCommandImpl(commandStr);
        if (!reportError) {
            cmd.dontReportError();
        }
        this.gdb.sendCommand(cmd);
    }

    private void sendSilent(String commandStr) {
        this.send(commandStr, false);
    }

    private void send(String commandStr) {
        this.send(commandStr, true);
    }

    private void sendResumptive(String commandStr) {
        MIResumptiveCommand cmd = new MIResumptiveCommand(commandStr);
        this.gdb.sendCommand(cmd);
    }

    public void registerRegistersWindow(RegistersWindow w) {
        super.registerRegistersWindow(w);
        if (!this.get_registers && w != null) {
            this.requestRegisters();
        }
        this.get_registers = w != null;
    }

    private class MIRepairBreakLineCommand
    extends MIChangeBreakCommand {
        MIRepairBreakLineCommand(int rt, String cmdString) {
            super(rt, cmdString);
        }

        protected void onDone(MIRecord record) {
            if (record.isEmpty()) {
                this.onError(record);
            } else {
                GdbDebuggerImpl.this.newHandlers(this.routingToken(), this, record);
                GdbDebuggerImpl.this.manager().bringDownDialog();
            }
            this.finish();
        }
    }

    private class MIReplaceBreakLineCommand
    extends MIChangeBreakCommand {
        MIReplaceBreakLineCommand(int rt, String cmdString) {
            super(rt, cmdString);
        }

        protected void onDone(MIRecord record) {
            if (record.isEmpty()) {
                this.onError(record);
            } else {
                MITList results = record.results();
                MIValue bkptValue = results.valueOf("bkpt");
                MIResult result = (MIResult)results.get(0);
                GdbDebuggerImpl.this.replaceHandler(this, this.routingToken(), result);
                GdbDebuggerImpl.this.manager().bringDownDialog();
            }
            this.finish();
        }
    }

    private abstract class MIChangeBreakCommand
    extends MIBreakCommand {
        MIChangeBreakCommand(int rt, String cmdString) {
            super(rt, cmdString);
        }
    }

    private class MIBreakLineCommand
    extends MIBreakCommand {
        private int newRT;
        private boolean overloadCancelled;

        MIBreakLineCommand(int rt, String cmdString) {
            super(rt, cmdString);
            this.newRT = 0;
            this.overloadCancelled = false;
        }

        protected void onDone(MIRecord record) {
            if (record.isEmpty()) {
                this.onError(record);
            } else {
                GdbDebuggerImpl.this.newHandlers(this.newRT == 0 ? this.routingToken() : this.newRT, this, record);
                GdbDebuggerImpl.this.manager().bringDownDialog();
            }
            this.finish();
        }

        protected void onError(MIRecord record) {
            if (this.overloadCancelled) {
                this.finish();
            } else {
                super.onError(record);
            }
        }

        protected void onUserInteraction(MIUserInteraction ui) {
            if (ui == null || ui.isEmpty()) {
                return;
            }
            this.overloadCancelled = GdbDebuggerImpl.this.userInteraction(this.routingToken(), ui, true);
        }
    }

    private class MIRestoreBreakCommand
    extends MIBreakCommand {
        private boolean overloadCancelled;

        MIRestoreBreakCommand(int rt, String cmdString) {
            super(rt, cmdString);
            this.overloadCancelled = false;
        }

        protected void onDone(MIRecord record) {
            if (record.isEmpty()) {
                this.onError(record);
            } else {
                GdbDebuggerImpl.this.newHandlers(this.routingToken(), this, record);
            }
            this.finish();
        }

        protected void onError(MIRecord record) {
            if (this.overloadCancelled) {
                this.finish();
            } else {
                super.onError(record);
            }
        }

        protected void onUserInteraction(MIUserInteraction ui) {
            if (ui == null || ui.isEmpty()) {
                return;
            }
            this.overloadCancelled = GdbDebuggerImpl.this.userInteraction(this.routingToken(), ui, true);
        }
    }

    abstract class MIBreakCommand
    extends MiCommandImpl {
        private final boolean wasRunning;

        protected MIBreakCommand(int rt, String cmdString) {
            super(rt, cmdString);
            this.wasRunning = GdbDebuggerImpl.this.state().isRunning;
        }

        protected abstract void onDone(MIRecord var1);

        protected void finish() {
            if (this.wasRunning) {
                GdbDebuggerImpl.this.go();
            }
            super.finish();
        }
    }

    private class MIResumptiveCommand
    extends MiCommandImpl {
        protected MIResumptiveCommand(String cmdString) {
            super(cmdString);
        }

        protected void onRunning(MIRecord record) {
            GdbDebuggerImpl.this.genericRunning();
        }

        protected void onError(MIRecord record) {
            GdbDebuggerImpl.this.stateSetRunning(false);
            GdbDebuggerImpl.this.stateChanged();
            GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
            GdbDebuggerImpl.this.genericFailure(record);
            this.finish();
        }

        protected void onStopped(MIRecord record) {
            GdbDebuggerImpl.this.genericStopped(record);
            this.finish();
        }
    }

    private class DisController
    extends NativeDebuggerImpl.ControllerSupport {
        private DisController() {
            super((NativeDebuggerImpl)GdbDebuggerImpl.this);
        }

        protected void setBreakpointHelp(String address) {
            NativeBreakpoint b = NativeBreakpoint.newInstructionBreakpoint((String)address);
            if (b != null) {
                int routingToken = RoutingToken.BREAKPOINTS.getUniqueRoutingTokenInt();
                Handler.postNewHandler((NativeDebugger)GdbDebuggerImpl.this, (NativeBreakpoint)b, (int)routingToken);
            }
        }

        public void requestDis() {
            if (GdbDebuggerImpl.this.visitedLocation == null) {
                return;
            }
            String cmd = "-data-disassemble";
            if (GdbDebuggerImpl.this.visitedLocation.hasSource()) {
                if (GdbDebuggerImpl.this.visitedLocation.line() <= 0) {
                    GdbDebuggerImpl.this.visitedLocation = GdbDebuggerImpl.this.visitedLocation.line(1);
                }
                String file = GdbDebuggerImpl.this.visitedLocation.src();
                file = GdbDebuggerImpl.this.localToRemote("requestDis", file);
                cmd = cmd + " -f " + file;
                cmd = cmd + " -l " + GdbDebuggerImpl.this.visitedLocation.line();
                cmd = cmd + " -- 1";
            } else {
                cmd = cmd + " -s $pc -e \"$pc+1000\" -- 1";
            }
            GdbDebuggerImpl.this.requestDisFromGdb(cmd);
        }

        public void requestDis(String start, int count) {
            if (start == null) {
                return;
            }
            String cmd = "-data-disassemble";
            cmd = cmd + " -s " + start;
            cmd = cmd + " -e " + start + "+" + count;
            cmd = cmd + " -- 1";
            GdbDebuggerImpl.this.requestDisFromGdb(cmd);
        }
    }

    private final class DisModel
    extends NativeDebuggerImpl.DisModelSupport {
        private DisModel() {
            super((NativeDebuggerImpl)GdbDebuggerImpl.this);
        }

        private void parseDisasm(MITList inss) {
            for (int ix = 0; ix < inss.size(); ++ix) {
                String fname;
                MITList ins = ((MIValue)inss.get(ix)).asTuple();
                String address = ins.valueOf("address").asConst().value();
                MIValue fnameValue = ins.valueOf("func-name");
                String offset = null;
                if (fnameValue != null) {
                    fname = fnameValue.asConst().value();
                    offset = ins.valueOf("offset").asConst().value();
                } else {
                    fname = Catalog.get("MSG_UnknownFunction");
                }
                String inst = ins.valueOf("inst").asConst().value();
                if (offset != null) {
                    this.add(address + ":", fname + "+" + offset + ":\t" + inst);
                    continue;
                }
                this.add(address + ":", fname + ":\t" + inst);
            }
        }

        public void parseRecord(MIRecord record) {
            this.clear();
            StopWatch sw = new StopWatch("Parse MI instructions");
            sw.start();
            MITList asm_insnsR = record.results();
            MITList lines = asm_insnsR.valueOf("asm_insns").asList();
            if (lines.isValueList()) {
                this.parseDisasm(lines);
            } else {
                for (int lx = 0; lx < lines.size(); ++lx) {
                    MIResult src_and_asm_lineR = (MIResult)lines.get(lx);
                    MITList src_and_asm_line = src_and_asm_lineR.value().asTuple();
                    String line = src_and_asm_line.valueOf("line").asConst().value();
                    String file = src_and_asm_line.valueOf("file").asConst().value();
                    MITList inss = src_and_asm_line.valueOf("line_asm_insn").asList();
                    this.add(line, file);
                    this.parseDisasm(inss);
                }
            }
            sw.stop();
            this.update();
        }
    }

    private class DeleteMIVarCommand
    extends MiCommandImpl {
        private final GdbVariable v;

        public DeleteMIVarCommand(GdbVariable v) {
            super("-var-delete " + v.getMIName());
            this.v = v;
        }

        protected void onDone(MIRecord record) {
            GdbDebuggerImpl.this.deleteVar(this.v, record);
            this.finish();
        }
    }

    private final class InfoProcMICmd
    extends MiCommandImpl {
        final boolean resume;

        public InfoProcMICmd(boolean resume) {
            super("info proc");
            this.resume = resume;
        }

        protected void onDone(MIRecord record) {
            if (Log.Gdb.pid) {
                System.out.printf("FindPidMICmd.onDone(): record: %s\n", record);
                System.out.printf("                      command: %s\n", record.command());
                System.out.printf("                      console: %s\n", record.command().getConsoleStream());
            }
            int pid = GdbDebuggerImpl.extractPid1(record);
            GdbDebuggerImpl.this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
            if (pid != 0) {
                GdbDebuggerImpl.this.session().setPid((long)pid);
            }
            if (this.resume) {
                GdbDebuggerImpl.this.go();
            }
            this.finish();
        }
    }

    private final class InfoThreadsMICmd
    extends MiCommandImpl {
        final boolean resume;

        public InfoThreadsMICmd(boolean resume) {
            super("info threads");
            this.resume = resume;
        }

        protected void onDone(MIRecord record) {
            int pos2;
            int pid = 0;
            String msg = record.command().getConsoleStream();
            int pos1 = msg.toLowerCase().indexOf("* 1 thread ");
            if (pos1 >= 0 && (pos2 = msg.indexOf(46, pos1)) > 0) {
                try {
                    pid = Integer.valueOf(msg.substring(pos1 + 11, pos2));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            GdbDebuggerImpl.this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
            if (pid != 0) {
                GdbDebuggerImpl.this.session().setPid((long)pid);
            }
            if (this.resume) {
                GdbDebuggerImpl.this.go();
            }
            this.finish();
        }
    }

    private class MiCommandImpl
    extends MICommand {
        private MICommand successChain;
        private MICommand failureChain;
        private boolean emptyDoneIsError;
        private boolean reportError;

        protected MiCommandImpl(String cmd) {
            super(0, cmd);
            this.successChain = null;
            this.failureChain = null;
            this.emptyDoneIsError = false;
            this.reportError = true;
        }

        protected MiCommandImpl(int rt, String cmd) {
            super(rt, cmd);
            this.successChain = null;
            this.failureChain = null;
            this.emptyDoneIsError = false;
            this.reportError = true;
        }

        public void chain(MICommand successChain, MICommand failureChain) {
            this.successChain = successChain;
            this.failureChain = failureChain;
        }

        public void setEmptyDoneIsError() {
            this.emptyDoneIsError = true;
        }

        public void dontReportError() {
            this.reportError = false;
        }

        protected void onDone(MIRecord record) {
            if (this.emptyDoneIsError && record.isEmpty()) {
                this.onError(record);
            } else {
                this.finish();
                if (this.successChain != null) {
                    GdbDebuggerImpl.this.gdb.sendCommand(this.successChain);
                }
            }
        }

        protected void onRunning(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("running", this.command());
        }

        protected void onError(MIRecord record) {
            if (this.failureChain == null && this.reportError) {
                GdbDebuggerImpl.this.genericFailure(record);
            }
            this.finish();
            if (this.failureChain != null) {
                GdbDebuggerImpl.this.gdb.sendCommand(this.failureChain);
            }
        }

        protected void onExit(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("exit", this.command());
            GdbDebuggerImpl.this.kill();
            this.finish();
        }

        protected void onStopped(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("stopped", this.command());
        }

        protected void onOther(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("other", this.command());
        }

        protected void onUserInteraction(MIUserInteraction ui) {
            GdbDebuggerImpl.this.unexpected("userinteraction", this.command());
        }
    }

    private static class MILocation
    extends Location {
        public static MILocation make(NativeDebugger debugger, MITList frameTuple, MITList srcTuple, boolean visited, int stackSize, NativeBreakpoint breakpoint) {
            String src = null;
            int line = 0;
            String func = null;
            long pc = 0L;
            int level = 0;
            if (frameTuple != null) {
                MIValue lineValue;
                MIValue addrValue = frameTuple.valueOf("addr");
                if (addrValue != null) {
                    String addr = addrValue.asConst().value();
                    pc = Address.parseAddr((String)addr);
                }
                MIValue funcValue = frameTuple.valueOf("func");
                func = funcValue.asConst().value();
                MIValue fullnameValue = frameTuple.valueOf("fullname");
                if (fullnameValue != null) {
                    src = fullnameValue.asConst().value();
                } else if (srcTuple != null && (fullnameValue = srcTuple.valueOf("fullname")) != null) {
                    src = fullnameValue.asConst().value();
                }
                MIValue levelValue = frameTuple.valueOf("level");
                if (levelValue != null) {
                    String lineString = levelValue.asConst().value();
                    level = Integer.parseInt(lineString);
                }
                if ((lineValue = frameTuple.valueOf("line")) != null) {
                    String lineString = lineValue.asConst().value();
                    line = Integer.parseInt(lineString);
                }
            } else {
                MIValue lineValue;
                MIValue fullnameValue = srcTuple.valueOf("fullname");
                if (fullnameValue != null) {
                    src = fullnameValue.asConst().value();
                }
                if ((lineValue = srcTuple.valueOf("line")) != null) {
                    String lineString = lineValue.asConst().value();
                    line = Integer.parseInt(lineString);
                }
            }
            src = debugger.remoteToLocal("MILocation", src);
            return new MILocation(src, line, func, pc, 1 | (visited ? 2 : 0) | (level == 0 ? 8 : 0) | (level >= stackSize - 1 ? 16 : 0), breakpoint);
        }

        public static MILocation make(MILocation h, boolean visited) {
            return new MILocation(h.src(), h.line(), h.func(), h.pc(), 1 | (visited ? 2 : 0) | (h.topframe() ? 8 : 0) | (h.bottomframe() ? 16 : 0), h.getBreakpoint());
        }

        private MILocation(String src, int line, String func, long pc, int flags, NativeBreakpoint breakpoint) {
            super(src, line, func, pc, flags, breakpoint);
        }
    }
}

