/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CadT1
extends CadDevice {
    byte[] sendBuffer = new byte[40];
    byte[] recvBuffer = new byte[40];
    protected static final int MAX_IFS_SIZE = 32;
    private static final byte BLOCKPROTOCOL_POWERUP = -16;
    private static final byte BLOCKPROTOCOL_POWERDOWN = -32;
    private static final byte BLOCKPROTOCOL_COMMAND = -128;
    private static final int BLOCKPROTOCOL_OFFSET_OPCODE = 0;
    private static final int BLOCKPROTOCOL_OFFSET_LENGTH = 1;
    private static final int BLOCKPROTOCOL_OFFSET_MESSAGE = 3;
    private static final int BLOCKPROTOCOL_HEADER_SIZE = 3;
    private static final int BLOCKPROTOCOL_OVERHEAD_SIZE = 4;

    public CadT1(InputStream in, OutputStream out) {
        super((byte)1, in, out);
    }

    synchronized void sendBlockProtocolMessage(int msgLen) throws IOException, T1Exception {
        this.out.write(this.sendBuffer, 0, msgLen);
        this.out.flush();
    }

    synchronized int receiveBlockProtocolMessage() throws IOException, T1Exception {
        int recvLen = this.in.read(this.recvBuffer, 0, 3);
        int maxLen = this.recvBuffer[1] << 8 | this.recvBuffer[2];
        recvLen += this.in.read(this.recvBuffer, 3, maxLen + 1);
        if (this.recvBuffer[0] == -32) {
            return -1;
        }
        if (this.recvBuffer[0] != -128) {
            throw new T1Exception(-126);
        }
        return recvLen;
    }

    public synchronized boolean exchangeBlock(T1Block blockTo, T1Block blockFrom) throws IOException, T1Exception {
        byte[] blockData = blockTo.toByteArray();
        int blockLen = blockData.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(blockLen >> 8);
        this.sendBuffer[2] = (byte)blockLen;
        System.arraycopy(blockData, 0, this.sendBuffer, 3, blockLen);
        this.sendBuffer[blockLen + 3] = this.computeLRC(this.sendBuffer, 0, blockLen + 3);
        this.sendBlockProtocolMessage(blockLen + 4);
        blockLen = this.receiveBlockProtocolMessage();
        if (blockLen == -1) {
            return false;
        }
        blockFrom.readBlockInstance(this.recvBuffer, 3, blockLen - 4);
        return true;
    }

    public synchronized boolean receiveBlock(T1Block blockFrom) throws IOException, T1Exception {
        int blockLen = this.receiveBlockProtocolMessage();
        blockFrom.readBlockInstance(this.recvBuffer, 3, blockLen - 4);
        return true;
    }

    public boolean sendATR(byte[] atrData) throws IOException, T1Exception {
        int blockLen = atrData.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(blockLen >> 8);
        this.sendBuffer[2] = (byte)blockLen;
        System.arraycopy(atrData, 0, this.sendBuffer, 3, blockLen);
        this.sendBuffer[blockLen + 3] = this.computeLRC(this.sendBuffer, 0, blockLen + 3);
        this.sendBlockProtocolMessage(blockLen + 4);
        return true;
    }

    public int getMaxIFSSize() {
        return 32;
    }

    public byte[] retrieveATR() throws IOException, T1Exception {
        int recvLen = this.in.read(this.recvBuffer, 0, 3);
        if (recvLen < 0) {
            throw new EOFException();
        }
        if (this.recvBuffer[0] != -128) {
            return null;
        }
        int lenATR = this.recvBuffer[1] << 8 | this.recvBuffer[2];
        if (lenATR <= 0) {
            return null;
        }
        recvLen = this.in.read(this.recvBuffer, 3, lenATR + 1);
        if (this.computeLRC(this.recvBuffer, 0, lenATR + 4) != 0) {
            return null;
        }
        byte[] theATR = new byte[lenATR];
        System.arraycopy(this.recvBuffer, 3, theATR, 0, lenATR);
        return theATR;
    }

    public synchronized boolean receivePowerUp() throws IOException, T1Exception {
        int recvLen = this.in.read(this.recvBuffer, 0, 3);
        int maxLen = this.recvBuffer[1] << 8 | this.recvBuffer[2];
        recvLen = this.in.read(this.recvBuffer, 3, maxLen + 1);
        return this.recvBuffer[0] == -16;
    }

    public synchronized void sendPowerUp() throws IOException, T1Exception {
        this.sendBuffer[0] = -16;
        this.sendBuffer[1] = 0;
        this.sendBuffer[2] = 0;
        this.sendBuffer[3] = this.computeLRC(this.sendBuffer, 0, 3);
        this.sendBlockProtocolMessage(4);
    }

    public synchronized void sendPowerDown() throws IOException, T1Exception {
        this.sendBuffer[0] = -32;
        this.sendBuffer[1] = 0;
        this.sendBuffer[2] = 0;
        this.sendBuffer[3] = this.computeLRC(this.sendBuffer, 0, 3);
        this.sendBlockProtocolMessage(4);
    }

    private byte computeLRC(byte[] buffer, int offset, int len) {
        byte lrcVal = 0;
        for (int i = 0; i < len; ++i) {
            lrcVal = (byte)(lrcVal ^ buffer[offset + i]);
        }
        return lrcVal;
    }
}

