/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.core.osgi.OSGiClassLoader;
import org.netbeans.core.osgi.OSGiInstalledFileLocator;
import org.netbeans.core.osgi.OSGiLifecycleManager;
import org.netbeans.core.osgi.OSGiRepository;
import org.netbeans.core.startup.CoreBridge;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class OSGiMainLookup
extends ProxyLookup {
    private static BundleContext context;
    private ClassLoader classLoader;
    private final List<Lookup> nonClassLoaderDelegates = new ArrayList<Lookup>();
    private final InstanceContent moduleInfoContent = new InstanceContent();
    private static final InstanceContent.Convertor<Bundle, ModuleInfo> moduleInfoConvertor;

    private static OSGiMainLookup get() {
        Lookup l = Lookup.getDefault();
        assert (l instanceof OSGiMainLookup) : "mismatch between " + OSGiMainLookup.class.getClassLoader() + " vs. " + l.getClass().getClassLoader();
        return (OSGiMainLookup)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(BundleContext _context) throws Exception {
        OSGiMainLookup lkp;
        System.setProperty(Lookup.class.getName(), OSGiMainLookup.class.getName());
        context = _context;
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OSGiMainLookup.class.getClassLoader());
        try {
            lkp = OSGiMainLookup.get();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        lkp.postInit();
    }

    static void bundlesAdded(List<Bundle> bundles) {
        OSGiMainLookup.get().setClassLoader();
        for (Bundle bundle : bundles) {
            OSGiMainLookup.get().moduleInfoContent.add((Object)bundle, moduleInfoConvertor);
        }
    }

    static void bundlesRemoved(List<Bundle> bundles) {
        OSGiMainLookup.get().setClassLoader();
        for (Bundle bundle : bundles) {
            OSGiMainLookup.get().moduleInfoContent.remove((Object)bundle, moduleInfoConvertor);
        }
    }

    static void loadServicesFolder() {
        OSGiMainLookup.get().nonClassLoaderDelegates.add(CoreBridge.getDefault().lookupCacheLoad());
        OSGiMainLookup.get().setDelegates();
    }

    private void postInit() {
        this.nonClassLoaderDelegates.add(Lookups.fixed((Object[])new Object[]{OSGiRepository.DEFAULT, new OSGiLifecycleManager(context), new OSGiInstalledFileLocator(context)}));
        this.nonClassLoaderDelegates.add((Lookup)new AbstractLookup((AbstractLookup.Content)this.moduleInfoContent));
        this.setClassLoader();
    }

    private void setClassLoader() {
        this.classLoader = new OSGiClassLoader(context);
        this.setDelegates();
    }

    private void setDelegates() {
        Lookup[] delegates = new Lookup[this.nonClassLoaderDelegates.size() + 2];
        this.nonClassLoaderDelegates.toArray(delegates);
        delegates[delegates.length - 2] = Lookups.metaInfServices((ClassLoader)this.classLoader);
        delegates[delegates.length - 1] = Lookups.singleton((Object)this.classLoader);
        this.setLookups(delegates);
    }

    static {
        moduleInfoConvertor = new InstanceContent.Convertor<Bundle, ModuleInfo>(){

            public ModuleInfo convert(Bundle b) {
                return new BundleModuleInfo(b);
            }

            public Class<? extends ModuleInfo> type(Bundle b) {
                return ModuleInfo.class;
            }

            public String id(Bundle b) {
                return b.getSymbolicName();
            }

            public String displayName(Bundle b) {
                return this.id(b);
            }
        };
    }

    private static final class BundleModuleInfo
    extends ModuleInfo {
        private final Bundle b;
        private ClassLoader loader;

        public BundleModuleInfo(Bundle b) {
            this.b = b;
        }

        public String getCodeNameBase() {
            return this.b.getSymbolicName();
        }

        public int getCodeNameRelease() {
            return this.b.getVersion().getMajor() / 100;
        }

        public String getCodeName() {
            int r = this.getCodeNameRelease();
            String s = this.getCodeNameBase();
            return r > 0 ? s + "/" + r : s;
        }

        public SpecificationVersion getSpecificationVersion() {
            Version v = this.b.getVersion();
            return new SpecificationVersion(v.getMajor() % 100 + "." + v.getMinor() + "." + v.getMicro());
        }

        public boolean isEnabled() {
            switch (this.b.getState()) {
                case 4: 
                case 8: 
                case 16: 
                case 32: {
                    return true;
                }
            }
            return false;
        }

        public Object getAttribute(String attr) {
            return this.b.getHeaders().get(attr);
        }

        public Object getLocalizedAttribute(String attr) {
            return this.getAttribute(attr);
        }

        public Set<Dependency> getDependencies() {
            return Collections.emptySet();
        }

        public boolean owns(Class<?> clazz) {
            return FrameworkUtil.getBundle(clazz) == this.b;
        }

        public synchronized ClassLoader getClassLoader() throws IllegalArgumentException {
            if (this.loader == null) {
                this.loader = new OSGiClassLoader(this.b);
            }
            return this.loader;
        }

        public String getImplementationVersion() {
            return this.b.getVersion().getQualifier();
        }

        public String getDisplayName() {
            return (String)this.getLocalizedAttribute("Bundle-Name");
        }
    }
}

