/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public class WebServiceClassPathProvider
implements ClassPathProvider {
    protected Project webProject;
    private ClassPath cp;

    public ClassPath findClassPath(FileObject file, String type) {
        if ("classpath/source".equals(type)) {
            assert (file != null);
            this.webProject = FileOwnerQuery.getOwner((FileObject)file);
            assert (this.webProject != null);
            this.cp = ClassPathFactory.createClassPath((ClassPathImplementation)new WSProjectClassPathImpl());
            return this.cp;
        }
        return null;
    }

    private class WSProjectClassPathImpl
    implements ClassPathImplementation {
        protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
        private transient ArrayList<PropertyChangeListener> propertyChangeListenerList;

        WSProjectClassPathImpl() {
        }

        public List<PathResourceImplementation> getResources() {
            return Arrays.asList(new PathResourceImplementation(){

                public ClassPathImplementation getContent() {
                    return null;
                }

                public URL[] getRoots() {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    FileObject fo = WebServiceClassPathProvider.this.webProject.getProjectDirectory().getFileObject("build/generated/wsclient/");
                    if (fo != null) {
                        try {
                            urls.add(fo.getURL());
                        }
                        catch (FileStateInvalidException ex) {
                            // empty catch block
                        }
                    }
                    if ((fo = WebServiceClassPathProvider.this.webProject.getProjectDirectory().getFileObject("build/generated/wsbinary/")) != null) {
                        try {
                            urls.add(fo.getURL());
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            // empty catch block
                        }
                    }
                    return urls.toArray(new URL[urls.size()]);
                }

                public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
                    WSProjectClassPathImpl.this.support.addPropertyChangeListener(listener);
                }

                public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
                    WSProjectClassPathImpl.this.support.removePropertyChangeListener(listener);
                }
            });
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerList == null) {
                this.propertyChangeListenerList = new ArrayList();
            }
            this.propertyChangeListenerList.add(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerList != null) {
                this.propertyChangeListenerList.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChangeListenerPropertyChange(PropertyChangeEvent event) {
            ArrayList<PropertyChangeListener> list;
            WSProjectClassPathImpl wSProjectClassPathImpl = this;
            synchronized (wSProjectClassPathImpl) {
                if (this.propertyChangeListenerList == null) {
                    return;
                }
                list = new ArrayList<PropertyChangeListener>(this.propertyChangeListenerList);
            }
            for (PropertyChangeListener cl : list) {
                cl.propertyChange(event);
            }
        }
    }
}

