/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentContext {
    private Document document;
    private XMLSyntaxSupport syntaxSupport;
    private int caretOffset = -1;
    private SyntaxElement element;
    private TokenItem token;
    private HashMap<String, String> declaredNamespaces = new HashMap();

    public static DocumentContext create(Document document, int caretOffset) {
        try {
            return new DocumentContext(document, caretOffset);
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private DocumentContext(Document document, int caretOffset) throws BadLocationException {
        this.document = document;
        this.syntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
        this.caretOffset = caretOffset;
        this.initialize();
    }

    private void initialize() throws BadLocationException {
        this.element = this.syntaxSupport.getElementChain(this.caretOffset);
        this.token = this.syntaxSupport.getTokenChain(this.caretOffset, Math.min(this.document.getLength(), this.caretOffset + 1));
        this.populateNamespaces();
    }

    public int getCurrentTokenId() {
        return this.token.getTokenID().getNumericID();
    }

    public TokenItem getCurrentToken() {
        return this.token;
    }

    public String getCurrentTokenImage() {
        return this.token.getImage();
    }

    public SyntaxElement getCurrentElement() {
        return this.element;
    }

    public String lookupNamespacePrefix(String prefix) {
        return this.declaredNamespaces.get(prefix);
    }

    public String getNamespacePrefix(String namespace) {
        for (Map.Entry<String, String> entry : this.declaredNamespaces.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<String> getDeclaredNamespaces() {
        return this.declaredNamespaces.values();
    }

    public Map<String, String> getDeclaredNamespacesMap() {
        return this.declaredNamespaces;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    private void populateNamespaces() {
        SyntaxElement element;
        for (element = this.element; element != null && !(element instanceof StartTag) && !(element instanceof EmptyTag); element = element.getPrevious()) {
        }
        if (element == null) {
            return;
        }
        for (Node node = (Node)element; node != null; node = node.getParentNode()) {
            if (!(node instanceof StartTag) && !(node instanceof EmptyTag)) continue;
            NamedNodeMap attributes = ((Tag)node).getAttributes();
            for (int index = 0; index < attributes.getLength(); ++index) {
                String prefix;
                Attr attr = (Attr)attributes.item(index);
                String attrName = attr.getName();
                String attrValue = attr.getValue();
                if (attrName == null || attrValue == null || (prefix = ContextUtilities.getPrefixFromNamespaceDeclaration(attrName)) == null || this.declaredNamespaces.containsKey(prefix)) continue;
                this.declaredNamespaces.put(prefix, attrValue);
            }
        }
    }
}

