/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;

public final class ContextUtilities {
    public static final String P_NAMESPACE = "http://www.springframework.org/schema/p";

    private ContextUtilities() {
    }

    public static boolean isPNamespaceName(DocumentContext context, String nodeName) {
        String namespaceUri;
        String prefix = ContextUtilities.getPrefixFromNodeName(nodeName);
        return prefix != null && P_NAMESPACE.equals(namespaceUri = context.lookupNamespacePrefix(prefix));
    }

    public static boolean isValueToken(TokenItem currentToken) {
        return currentToken != null && currentToken.getTokenID().getNumericID() == 7;
    }

    public static boolean isTagToken(TokenItem currentToken) {
        return currentToken != null && currentToken.getTokenID().getNumericID() == 4;
    }

    public static boolean isAttributeToken(TokenItem currentToken) {
        return currentToken != null && currentToken.getTokenID().getNumericID() == 5;
    }

    public static TokenItem getAttributeToken(TokenItem currentToken) {
        if (ContextUtilities.isValueToken(currentToken)) {
            TokenItem equalsToken = currentToken.getPrevious();
            while (equalsToken.getTokenID().getNumericID() != 6) {
                equalsToken = equalsToken.getPrevious();
            }
            TokenItem argumentToken = equalsToken.getPrevious();
            while (argumentToken.getTokenID().getNumericID() != 5) {
                argumentToken = argumentToken.getPrevious();
            }
            return argumentToken;
        }
        return null;
    }

    public static Tag getCurrentTagElement(DocumentContext context) {
        SyntaxElement element = context.getCurrentElement();
        if (element instanceof StartTag) {
            return (StartTag)element;
        }
        if (element instanceof EmptyTag) {
            return (EmptyTag)element;
        }
        return null;
    }

    public static TokenItem getAttributeToken(DocumentContext context) {
        if (ContextUtilities.isValueToken(context.getCurrentToken())) {
            TokenItem equalsToken = context.getCurrentToken().getPrevious();
            while (equalsToken.getTokenID().getNumericID() != 6) {
                equalsToken = equalsToken.getPrevious();
            }
            TokenItem argumentToken = equalsToken.getPrevious();
            while (argumentToken.getTokenID().getNumericID() != 5) {
                argumentToken = argumentToken.getPrevious();
            }
            return argumentToken;
        }
        return null;
    }

    public static String getAttributeTokenImage(DocumentContext context) {
        TokenItem tok = ContextUtilities.getAttributeToken(context);
        if (tok != null) {
            return tok.getImage();
        }
        return null;
    }

    public static String getPrefixFromTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return tagName.indexOf(":") == -1 ? null : tagName.substring(0, tagName.indexOf(":"));
    }

    public static String getLocalNameFromTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return tagName.indexOf(":") == -1 ? tagName : tagName.substring(tagName.indexOf(":") + 1, tagName.length());
    }

    public static String getPrefixFromNamespaceDeclaration(String namespace) {
        if (!namespace.startsWith("xmlns")) {
            return null;
        }
        int xmlnsLength = "xmlns".length();
        if (namespace.length() == xmlnsLength) {
            return "";
        }
        if (namespace.charAt(xmlnsLength) == ':') {
            return namespace.substring(xmlnsLength + 1);
        }
        return null;
    }

    public static String getPrefixFromNodeName(String nodeName) {
        int colonIndex = nodeName.indexOf(58);
        if (colonIndex <= 0) {
            return null;
        }
        return nodeName.substring(0, colonIndex);
    }

    public static StartTag getRoot(SyntaxElement se) {
        StartTag root = null;
        while (se != null) {
            if (se instanceof StartTag) {
                root = (StartTag)se;
            }
            se = se.getPrevious();
        }
        return root;
    }

    public static boolean isPNamespaceAdded(DocumentContext dc) {
        return dc.getDeclaredNamespaces().contains(P_NAMESPACE);
    }
}

