/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.filesystems.FileObject;

public class FQNImporter {
    private FileObject javaFile;
    private boolean handleInitComponents;
    private String formListener;
    private Collection<String> variableNames;
    private Collection<String> eventHandlers;

    FQNImporter(FileObject javaFile) {
        this.javaFile = javaFile;
    }

    void setHandleInitComponents(boolean handleInitComponents) {
        this.handleInitComponents = handleInitComponents;
    }

    void setHandleVariables(Collection<String> variableNames) {
        this.variableNames = variableNames;
    }

    void setHandleFormListener(String formListener) {
        this.formListener = formListener;
    }

    void setHandleEventHandlers(Collection<String> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    void importFQNs() {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)this.javaFile);
            CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    MethodTree method;
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = wc.getCompilationUnit();
                    ClassTree clazz = null;
                    String fileName = FQNImporter.this.javaFile.getName();
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree classTree;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !fileName.equals((classTree = (ClassTree)tree).getSimpleName().toString())) continue;
                        clazz = classTree;
                        break;
                    }
                    if (clazz == null) {
                        return;
                    }
                    GeneratorUtilities utils = GeneratorUtilities.get((WorkingCopy)wc);
                    if (FQNImporter.this.handleInitComponents) {
                        for (Tree tree : clazz.getMembers()) {
                            if (Tree.Kind.METHOD != tree.getKind() || !"initComponents".equals((method = (MethodTree)tree).getName().toString())) continue;
                            BlockTree oldBody = method.getBody();
                            Tree tree2 = utils.importFQNs((Tree)oldBody);
                            wc.rewrite((Tree)oldBody, tree2);
                        }
                    }
                    if (FQNImporter.this.formListener != null) {
                        for (Tree tree : clazz.getMembers()) {
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                            ClassTree klass = (ClassTree)tree;
                            if (!FQNImporter.this.formListener.equals(klass.getSimpleName().toString())) continue;
                            Tree newTree = utils.importFQNs((Tree)klass);
                            wc.rewrite((Tree)klass, newTree);
                        }
                    }
                    if (FQNImporter.this.variableNames != null) {
                        for (Tree tree : clazz.getMembers()) {
                            if (Tree.Kind.VARIABLE != tree.getKind()) continue;
                            VariableTree variable = (VariableTree)tree;
                            if (!FQNImporter.this.variableNames.contains(variable.getName().toString())) continue;
                            Tree type = variable.getType();
                            Tree tree3 = utils.importFQNs(type);
                            wc.rewrite(type, tree3);
                            ExpressionTree initializer = variable.getInitializer();
                            if (initializer == null) continue;
                            Tree tree4 = utils.importFQNs((Tree)initializer);
                            wc.rewrite((Tree)initializer, tree4);
                        }
                    }
                    if (FQNImporter.this.eventHandlers != null) {
                        for (Tree tree : clazz.getMembers()) {
                            if (Tree.Kind.METHOD != tree.getKind()) continue;
                            method = (MethodTree)tree;
                            if (!FQNImporter.this.eventHandlers.contains(method.getName().toString())) continue;
                            for (VariableTree variableTree : method.getParameters()) {
                                Tree newTree = utils.importFQNs((Tree)variableTree);
                                wc.rewrite((Tree)variableTree, newTree);
                            }
                        }
                    }
                }

                public void cancel() {
                }
            };
            ModificationResult result = source.runModificationTask((Task)task);
            List diffs = result.getDifferences(this.javaFile);
            if (diffs != null) {
                for (ModificationResult.Difference diff : diffs) {
                    diff.setCommitToGuards(true);
                }
                result.commit();
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, e.getMessage(), e);
        }
    }
}

