/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.model;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.model.ModuleImpl;
import org.netbeans.modules.j2ee.earproject.model.WebImpl;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.xml.sax.SAXParseException;

public class ApplicationImpl
implements Application {
    private final EarProject earProject;
    private List<Module> modules;
    private volatile boolean runReadActionRunning = false;

    public ApplicationImpl(EarProject earProject) {
        this.earProject = earProject;
    }

    protected void enterRunReadAction() {
        this.runReadActionRunning = true;
    }

    protected void leaveRunReadAction() {
        this.runReadActionRunning = false;
        this.clearModules();
    }

    private void clearModules() {
        this.modules = null;
    }

    private List<Module> getModules() {
        if (!ProjectManager.mutex().isWriteAccess() || !this.runReadActionRunning) {
            throw new IllegalStateException("Cannot read modules outside runReadAction()");
        }
        if (this.modules != null) {
            return this.modules;
        }
        List<ClassPathSupport.Item> vcpis = EarProjectProperties.getJarContentAdditional(this.earProject);
        this.modules = new ArrayList<Module>(vcpis.size());
        for (ClassPathSupport.Item vcpi : vcpis) {
            this.addModuleFromVcpi(vcpi);
        }
        return this.modules;
    }

    private void addModuleFromVcpi(ClassPathSupport.Item vcpi) {
        Module mod = null;
        String path = EarProjectProperties.getCompletePathInArchive(this.earProject, vcpi);
        if (vcpi.getType() == 2) {
            mod = this.getModFromAntArtifact(vcpi.getArtifact(), path);
        } else if (vcpi.getType() == 0) {
            mod = this.getModFromFile(vcpi.getResolvedFile(), path);
        }
        Module prevMod = this.searchForModule(path);
        if (prevMod == null && mod != null) {
            this.modules.add(mod);
        }
    }

    private Module getModFromAntArtifact(AntArtifact aa, String path) {
        Project p = aa.getProject();
        ModuleImpl mod = null;
        J2eeModuleProvider jmp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        if (jmp != null) {
            String connector = null;
            String ejb = null;
            String car = null;
            WebImpl web = null;
            jmp.setServerInstanceID(this.earProject.getServerInstanceID());
            J2eeModule jm = jmp.getJ2eeModule();
            if (jm == null) {
                return null;
            }
            this.earProject.getAppModule().addModuleProvider(jmp, path);
            if (J2eeModule.Type.EJB.equals(jm.getType())) {
                ejb = path;
            } else if (J2eeModule.Type.WAR.equals(jm.getType())) {
                FileObject tmp = aa.getScriptFile();
                if (tmp != null) {
                    tmp = tmp.getParent().getFileObject("web/WEB-INF/web.xml");
                }
                WebModule wm = null;
                if (tmp != null) {
                    wm = WebModule.getWebModule((FileObject)tmp);
                }
                String contextPath = null;
                if (wm != null) {
                    contextPath = wm.getContextPath();
                }
                if (contextPath == null) {
                    int endex = path.length() - 4;
                    if (endex < 1) {
                        endex = path.length();
                    }
                    contextPath = path.substring(0, endex);
                }
                web = new WebImpl(path, contextPath);
            } else if (J2eeModule.Type.RAR.equals(jm.getType())) {
                connector = path;
            } else if (J2eeModule.Type.CAR.equals(jm.getType())) {
                car = path;
            }
            mod = new ModuleImpl(connector, ejb, car, web);
        }
        return mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module getModFromFile(File f, String path) {
        ZipFile jar = null;
        ModuleImpl mod = null;
        try {
            String connector = null;
            String ejb = null;
            String car = null;
            WebImpl web = null;
            boolean found = false;
            jar = new JarFile(f);
            JarEntry ddf = ((JarFile)jar).getJarEntry("META-INF/ejb-jar.xml");
            if (ddf != null) {
                ejb = path;
                found = true;
            }
            if ((ddf = ((JarFile)jar).getJarEntry("META-INF/ra.xml")) != null && !found) {
                connector = path;
                found = true;
            } else if (ddf != null && found) {
                Module module = null;
                return module;
            }
            ddf = ((JarFile)jar).getJarEntry("META-INF/application-client.xml");
            if (ddf != null && !found) {
                car = path;
                found = true;
            } else if (ddf != null && found) {
                Module module = null;
                return module;
            }
            ddf = ((JarFile)jar).getJarEntry("WEB-INF/web.xml");
            if (ddf != null && !found) {
                int endex = path.length() - 4;
                if (endex < 1) {
                    endex = path.length();
                }
                String contextPath = "/" + path.substring(0, endex);
                web = new WebImpl(path, contextPath);
                found = true;
            } else if (ddf != null && found) {
                Module module = null;
                return module;
            }
            ddf = ((JarFile)jar).getJarEntry("META-INF/application.xml");
            if (ddf != null) {
                Module module = null;
                return module;
            }
            mod = new ModuleImpl(connector, ejb, car, web);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ioe) {}
        }
        return mod;
    }

    private Module searchForModule(String path) {
        assert (path != null);
        for (Module m : this.getModules()) {
            String val = m.getEjb();
            if (path.equals(val)) {
                return m;
            }
            val = m.getConnector();
            if (path.equals(val)) {
                return m;
            }
            val = m.getJava();
            if (path.equals(val)) {
                return m;
            }
            Web w = m.getWeb();
            val = null;
            if (null != w) {
                val = w.getWebUri();
            }
            if (!path.equals(val)) continue;
            return m;
        }
        return null;
    }

    public String getDefaultDisplayName() {
        return ProjectUtils.getInformation((Project)this.earProject).getDisplayName();
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigDecimal getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SAXParseException getError() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getStatus() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setModule(int index, Module value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Module getModule(int index) {
        if (index < 0 || index >= this.getModules().size()) {
            return null;
        }
        return this.getModules().get(index);
    }

    public int sizeModule() {
        return this.getModules().size();
    }

    public void setModule(Module[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Module[] getModule() {
        return this.getModules().toArray(new Module[this.getModules().size()]);
    }

    public int addModule(Module value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeModule(Module value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Module newModule() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSecurityRole(int index, SecurityRole value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SecurityRole getSecurityRole(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sizeSecurityRole() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSecurityRole(SecurityRole[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SecurityRole[] getSecurityRole() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addSecurityRole(SecurityRole value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeSecurityRole(SecurityRole value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SecurityRole newSecurityRole() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIcon(int index, Icon value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Icon getIcon(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sizeIcon() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIcon(Icon[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addIcon(Icon value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeIcon(Icon value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Icon newIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(FileObject fo) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(RootInterface root, int mode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getValue(String propertyName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDescription(String locale, String description) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDescription(String description) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAllDescriptions(Map descriptions) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDescription(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDefaultDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map getAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDescriptionForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDisplayName(String locale, String displayName) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDisplayName(String displayName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAllDisplayNames(Map displayNames) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDisplayName(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map getAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDisplayNameForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean createBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean addBean(String beanName, String[] propertyNames, Object[] propertyValues, String keyProperty) throws ClassNotFoundException, NameAlreadyUsedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean addBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean findBeanByName(String beanName, String propertyName, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSmallIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSmallIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLargeIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLargeIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAllIcons(String[] locales, String[] smallIcons, String[] largeIcons) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Icon getDefaultIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map getAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        sb.append(this.getClass().getName() + " Object {");
        sb.append(newLine);
        sb.append(" Name: ");
        sb.append(this.getDefaultDisplayName());
        sb.append(newLine);
        sb.append(" Number of modules: ");
        sb.append(this.getModules().size());
        sb.append(newLine);
        sb.append(" Modules: ");
        sb.append(this.getModules());
        sb.append(newLine);
        sb.append("}");
        return sb.toString();
    }
}

