/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.EnumSet;
import java.util.ResourceBundle;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.i18n.HelpStringCustomEditor;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.i18n.java.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JavaReplacePanel
extends JPanel {
    private JavaI18nSupport javaI18nSupport;
    private final ResourceBundle bundle;
    private JRadioButton defaultRadio;
    private JLabel fieldLabel;
    private JTextField fieldTextField;
    private JCheckBox finalCheck;
    private JCheckBox generateCheck;
    private JLabel identifierLabel;
    private JTextField identifierTextField;
    private JButton initButton;
    private JLabel initLabel;
    private JTextField initTextField;
    private JLabel modifiersLabel;
    private JRadioButton privateRadio;
    private JRadioButton protectedRadio;
    private JRadioButton publicRadio;
    private JCheckBox staticCheck;
    private JCheckBox transientCheck;

    public JavaReplacePanel(JavaI18nSupport javaI18nSupport) {
        this.javaI18nSupport = javaI18nSupport;
        this.bundle = NbBundle.getBundle(Util.class);
        this.initComponents();
        this.initAccessibility();
        this.updateValues();
    }

    private void updateValues() {
        this.javaI18nSupport.createIdentifier();
        this.generateCheck.setSelected(this.javaI18nSupport.isGenerateField());
        this.setAllEnabled(this.generateCheck.isSelected());
        this.identifierTextField.setText(this.javaI18nSupport.getIdentifier());
        this.initTextField.setText(this.javaI18nSupport.getInitString());
    }

    private void updateModifiers() {
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_JavaReplacePanel"));
        this.fieldTextField.selectAll();
        this.initTextField.selectAll();
        this.staticCheck.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_staticCheck"));
        this.identifierTextField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_identifierTextField"));
        this.transientCheck.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_transientCheck"));
        this.defaultRadio.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_defaultRadio"));
        this.fieldTextField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_fieldTextField"));
        this.initButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_initButton"));
        this.publicRadio.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_publicRadio"));
        this.generateCheck.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_generateCheck"));
        this.finalCheck.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_finalCheck"));
        this.privateRadio.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_privateRadio"));
        this.initTextField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_initTextField"));
        this.protectedRadio.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_protectedRadio"));
    }

    private void initComponents() {
        this.generateCheck = new JCheckBox();
        this.modifiersLabel = new JLabel();
        this.defaultRadio = new JRadioButton();
        this.privateRadio = new JRadioButton();
        this.protectedRadio = new JRadioButton();
        this.publicRadio = new JRadioButton();
        this.staticCheck = new JCheckBox();
        this.finalCheck = new JCheckBox();
        this.transientCheck = new JCheckBox();
        this.identifierLabel = new JLabel();
        this.identifierTextField = new JTextField();
        this.initLabel = new JLabel();
        this.initTextField = new JTextField();
        this.fieldLabel = new JLabel();
        this.fieldTextField = new JTextField();
        this.initButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.generateCheck.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateCheck, (String)this.bundle.getString("CTL_GenerateField"));
        this.generateCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.generateCheckActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.generateCheck, gridBagConstraints);
        this.modifiersLabel.setText(this.bundle.getString("LBL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.modifiersLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultRadio, (String)this.bundle.getString("CTL_DefaultRadio"));
        this.defaultRadio.setEnabled(false);
        this.defaultRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.defaultRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.defaultRadio, gridBagConstraints);
        this.privateRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.privateRadio, (String)NbBundle.getMessage(JavaReplacePanel.class, (String)"CTL_PrivateRadio"));
        this.privateRadio.setEnabled(false);
        this.privateRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.privateRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.privateRadio, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.protectedRadio, (String)NbBundle.getMessage(JavaReplacePanel.class, (String)"CTL_ProtectedRadio"));
        this.protectedRadio.setEnabled(false);
        this.protectedRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.protectedRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.protectedRadio, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.publicRadio, (String)NbBundle.getMessage(JavaReplacePanel.class, (String)"CTL_PublicRadio"));
        this.publicRadio.setEnabled(false);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.defaultRadio);
        radioGroup.add(this.privateRadio);
        radioGroup.add(this.protectedRadio);
        radioGroup.add(this.publicRadio);
        this.publicRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.publicRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.publicRadio, gridBagConstraints);
        this.staticCheck.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.staticCheck, (String)NbBundle.getMessage(JavaReplacePanel.class, (String)"CTL_StaticCheck"));
        this.staticCheck.setEnabled(false);
        this.staticCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.staticCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.staticCheck, gridBagConstraints);
        this.finalCheck.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.finalCheck, (String)NbBundle.getMessage(JavaReplacePanel.class, (String)"CTL_FinalCheck"));
        this.finalCheck.setEnabled(false);
        this.finalCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.finalCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.finalCheck, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.transientCheck, (String)NbBundle.getMessage(JavaReplacePanel.class, (String)"CTL_TransientCheck"));
        this.transientCheck.setEnabled(false);
        this.transientCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.transientCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.transientCheck, gridBagConstraints);
        this.identifierLabel.setLabelFor(this.identifierTextField);
        Mnemonics.setLocalizedText((JLabel)this.identifierLabel, (String)this.bundle.getString("LBL_Identifier"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.identifierLabel, gridBagConstraints);
        this.identifierTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.identifierTextFieldActionPerformed(evt);
            }
        });
        this.identifierTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JavaReplacePanel.this.identifierTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.identifierTextField, gridBagConstraints);
        this.initLabel.setLabelFor(this.initTextField);
        Mnemonics.setLocalizedText((JLabel)this.initLabel, (String)this.bundle.getString("LBL_InitFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.initLabel, gridBagConstraints);
        this.initTextField.setEditable(false);
        this.initTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JavaReplacePanel.this.initTextFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.initTextField, gridBagConstraints);
        this.fieldLabel.setLabelFor(this.fieldTextField);
        Mnemonics.setLocalizedText((JLabel)this.fieldLabel, (String)this.bundle.getString("LBL_Field"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 11, 0);
        this.add((Component)this.fieldLabel, gridBagConstraints);
        this.fieldTextField.setEditable(false);
        this.fieldTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JavaReplacePanel.this.fieldTextFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.fieldTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.initButton, (String)this.bundle.getString("CTL_Format"));
        this.initButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaReplacePanel.this.initButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.initButton, gridBagConstraints);
    }

    private void fieldTextFieldFocusGained(FocusEvent evt) {
        this.fieldTextField.selectAll();
    }

    private void initTextFieldFocusGained(FocusEvent evt) {
        this.initTextField.selectAll();
    }

    private void initButtonActionPerformed(ActionEvent evt) {
        final Dialog[] dialogs = new Dialog[1];
        final HelpStringCustomEditor customPanel = new HelpStringCustomEditor(this.javaI18nSupport.getInitFormat(), I18nUtil.getInitFormatItems(), I18nUtil.getInitHelpItems(), Util.getString("LBL_InitCodeFormat"), "i18n.pe.bundlestring");
        DialogDescriptor dd = new DialogDescriptor((Object)customPanel, this.bundle.getString("LBL_InitStringFormatEditor"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() == DialogDescriptor.OK_OPTION) {
                    String newText = (String)customPanel.getPropertyValue();
                    if (!newText.equals(JavaReplacePanel.this.javaI18nSupport.getInitFormat())) {
                        JavaReplacePanel.this.javaI18nSupport.setInitFormat(newText);
                        JavaReplacePanel.this.initTextField.setText(JavaReplacePanel.this.javaI18nSupport.getInitString());
                        I18nUtil.getOptions().setInitJavaCode(newText);
                    }
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                } else if (ev.getSource() == DialogDescriptor.CANCEL_OPTION) {
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                }
            }
        });
        dialogs[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialogs[0].setVisible(true);
    }

    private void identifierTextFieldFocusLost(FocusEvent evt) {
        this.identifierTextFieldEventHandlerDelegate(evt);
    }

    private void identifierTextFieldActionPerformed(ActionEvent evt) {
        this.identifierTextFieldEventHandlerDelegate(evt);
    }

    public void identifierTextFieldEventHandlerDelegate(AWTEvent evt) {
        if (!this.identifierTextField.getText().equals(this.javaI18nSupport.getIdentifier())) {
            this.javaI18nSupport.setIdentifier(this.identifierTextField.getText());
            this.updateModifiers();
        }
    }

    private void transientCheckActionPerformed(ActionEvent evt) {
        if (this.transientCheck.isSelected()) {
            this.staticCheck.setSelected(false);
            this.staticCheck.setEnabled(false);
        } else {
            this.staticCheck.setEnabled(true);
        }
        this.modifiersActionPerformed();
    }

    private void finalCheckActionPerformed(ActionEvent evt) {
        this.modifiersActionPerformed();
    }

    private void staticCheckActionPerformed(ActionEvent evt) {
        if (this.staticCheck.isSelected()) {
            this.transientCheck.setSelected(false);
            this.transientCheck.setEnabled(false);
        } else {
            this.transientCheck.setEnabled(true);
        }
        this.modifiersActionPerformed();
    }

    private void publicRadioActionPerformed(ActionEvent evt) {
        this.modifiersActionPerformed();
    }

    private void protectedRadioActionPerformed(ActionEvent evt) {
        this.modifiersActionPerformed();
    }

    private void privateRadioActionPerformed(ActionEvent evt) {
        this.modifiersActionPerformed();
    }

    private void defaultRadioActionPerformed(ActionEvent evt) {
        this.modifiersActionPerformed();
    }

    private void generateCheckActionPerformed(ActionEvent evt) {
        boolean selected = this.generateCheck.isSelected();
        if (selected != this.javaI18nSupport.isGenerateField()) {
            this.javaI18nSupport.setGenerateField(selected);
            this.setAllEnabled(selected);
        }
    }

    private void modifiersActionPerformed() {
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (this.privateRadio.isSelected()) {
            modifiers.add(Modifier.PRIVATE);
        } else if (this.protectedRadio.isSelected()) {
            modifiers.add(Modifier.PROTECTED);
        } else if (this.publicRadio.isSelected()) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (this.staticCheck.isSelected()) {
            modifiers.add(Modifier.STATIC);
        }
        if (this.finalCheck.isSelected()) {
            modifiers.add(Modifier.FINAL);
        }
        if (this.transientCheck.isSelected()) {
            modifiers.add(Modifier.TRANSIENT);
        }
        if (!((Object)modifiers).equals(this.javaI18nSupport.getModifiers())) {
            this.javaI18nSupport.setModifiers(modifiers);
        }
    }

    private void setAllEnabled(boolean enable) {
        this.defaultRadio.setEnabled(enable);
        this.privateRadio.setEnabled(enable);
        this.protectedRadio.setEnabled(enable);
        this.publicRadio.setEnabled(enable);
        this.staticCheck.setEnabled(enable);
        this.transientCheck.setEnabled(enable);
        this.finalCheck.setEnabled(enable);
        this.identifierTextField.setEnabled(enable);
        this.fieldTextField.setEnabled(enable);
        this.initButton.setEnabled(enable);
        if (enable) {
            this.updateModifiers();
        }
    }

    private void enableModifiers(boolean enable) {
        this.defaultRadio.setEnabled(enable);
        this.privateRadio.setEnabled(enable);
        this.protectedRadio.setEnabled(enable);
        this.publicRadio.setEnabled(enable);
        this.staticCheck.setEnabled(enable);
        this.finalCheck.setEnabled(enable);
        this.transientCheck.setEnabled(enable);
        this.initTextField.setEnabled(enable);
        this.initButton.setEnabled(enable);
    }
}

