/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatUsers;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class InstallPanelVisual
extends JPanel {
    private static final String SERVER_XML = "conf/server.xml";
    private final List listeners = new ArrayList();
    private final TomcatManager.TomcatVersion tomcatVersion;
    private String errorMessage;
    private boolean infoMessage;
    private String serverPort;
    private String shutdownPort;
    private RequestProcessor.Task validationTask;
    private JCheckBox createUserCheckBox;
    private JButton jButtonBaseBrowse;
    private JButton jButtonHomeBrowse;
    private JCheckBox jCheckBoxShared;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelBaseDir;
    private JLabel jLabelHomeDir;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JTextField jTextFieldBaseDir;
    private JTextField jTextFieldHomeDir;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldUsername;

    public InstallPanelVisual(TomcatManager.TomcatVersion tomcatVersion) {
        this.tomcatVersion = tomcatVersion;
        this.initComponents();
        DocumentListener updateListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InstallPanelVisual.this.fireChange();
            }
        };
        this.jTextFieldHomeDir.getDocument().addDocumentListener(updateListener);
        this.jTextFieldBaseDir.getDocument().addDocumentListener(updateListener);
        this.jTextFieldUsername.getDocument().addDocumentListener(updateListener);
        this.jTextFieldPassword.getDocument().addDocumentListener(updateListener);
        this.createUserCheckBox.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InstallPanelVisual.this.fireChange();
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (InstallPanelVisual.this.isJWSDP()) {
                    if (InstallPanelVisual.this.jCheckBoxShared.isEnabled()) {
                        InstallPanelVisual.this.jCheckBoxShared.setEnabled(false);
                        InstallPanelVisual.this.setBaseEnabled(false);
                    }
                } else if (!InstallPanelVisual.this.jCheckBoxShared.isEnabled()) {
                    InstallPanelVisual.this.jCheckBoxShared.setEnabled(true);
                    if (InstallPanelVisual.this.jCheckBoxShared.isSelected()) {
                        InstallPanelVisual.this.setBaseEnabled(true);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private void initComponents() {
        this.jLabelHomeDir = new JLabel();
        this.jLabelBaseDir = new JLabel();
        this.jTextFieldHomeDir = new JTextField();
        this.jTextFieldBaseDir = new JTextField();
        this.jButtonBaseBrowse = new JButton();
        this.jButtonHomeBrowse = new JButton();
        this.jCheckBoxShared = new JCheckBox();
        this.jLabelUsername = new JLabel();
        this.jLabelPassword = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldPassword = new JPasswordField();
        this.jTextFieldUsername = new JTextField();
        this.jLabel2 = new JLabel();
        this.createUserCheckBox = new JCheckBox();
        this.setName(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_InstallationAndLoginDetails"));
        this.jLabelHomeDir.setLabelFor(this.jTextFieldHomeDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelHomeDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_home_dir"));
        this.jLabelBaseDir.setLabelFor(this.jTextFieldBaseDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelBaseDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_base_dir"));
        this.jLabelBaseDir.setEnabled(false);
        this.jTextFieldHomeDir.setColumns(15);
        this.jTextFieldBaseDir.setColumns(15);
        this.jTextFieldBaseDir.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBaseBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_base"));
        this.jButtonBaseBrowse.setEnabled(false);
        this.jButtonBaseBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jButtonBaseBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonHomeBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_home"));
        this.jButtonHomeBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jButtonHomeBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxShared, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_SharedInstall"));
        this.jCheckBoxShared.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanelVisual.this.jCheckBoxSharedActionPerformed(evt);
            }
        });
        this.jLabelUsername.setLabelFor(this.jTextFieldUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabelUsername, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Username"));
        this.jLabelUsername.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.jLabelPassword.setLabelFor(this.jTextFieldPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPassword, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Password"));
        this.jLabelPassword.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_TextAbove"));
        this.jTextFieldPassword.setColumns(20);
        this.jTextFieldUsername.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Credentials", (Object[])new Object[]{TomcatManager.TomcatVersion.TOMCAT_70.equals((Object)this.tomcatVersion) ? "manager-script" : "manager"}));
        this.jLabel2.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.createUserCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createUserCheckBox, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUser"));
        this.createUserCheckBox.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.createUserCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createUserCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jCheckBoxShared).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelUsername).add((Component)this.jLabelPassword).add((GroupLayout.Group)layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabelBaseDir)).add((Component)this.jLabelHomeDir)).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.createUserCheckBox).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jTextFieldBaseDir, -1, 252, Short.MAX_VALUE).add(2, (Component)this.jTextFieldHomeDir, -1, 252, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonHomeBrowse, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonBaseBrowse, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldPassword, 0, 0, Short.MAX_VALUE).add(1, (Component)this.jTextFieldUsername, -1, 129, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabelHomeDir)).add((GroupLayout.Group)layout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonHomeBrowse).add((Component)this.jTextFieldHomeDir, -2, -1, -2)))).add(5, 5, 5).add((Component)this.jCheckBoxShared).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabelBaseDir)).add((GroupLayout.Group)layout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldBaseDir, -2, -1, -2).add((Component)this.jButtonBaseBrowse)))).add(14, 14, 14).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(7, 7, 7).add((Component)this.jLabelUsername)).add((GroupLayout.Group)layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jTextFieldUsername, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelPassword).add((Component)this.jTextFieldPassword, -2, -1, -2)).addPreferredGap(0).add((Component)this.createUserCheckBox).addContainerGap(51, Short.MAX_VALUE)));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelHomeDir"));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelHomeDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelBaseDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelBaseDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_homeDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_homeDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_baseDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_baseDir"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonBaseBrowse"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonBaseBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonHomeBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonHomeBrowse"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_shared"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_shared"));
        this.jLabelUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelUsername"));
        this.jLabelUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelUsername"));
        this.jLabelPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelPassword"));
        this.jLabelPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelPassword"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_password"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_password"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_username"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_username"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_panel"));
    }

    private void jButtonBaseBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.jTextFieldBaseDir.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.jTextFieldBaseDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jButtonHomeBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.jTextFieldHomeDir.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.jTextFieldHomeDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jCheckBoxSharedActionPerformed(ActionEvent evt) {
        this.setBaseEnabled(this.jCheckBoxShared.isSelected());
        this.fireChange();
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.put("httpportnumber", this.serverPort);
        p.put("admin_port", this.shutdownPort);
        p.put("monitor_enabled", "false");
        return p;
    }

    public TomcatManager.TomcatVersion getTomcatVersion() {
        return this.tomcatVersion;
    }

    public String getUrl() {
        String url;
        switch (this.tomcatVersion) {
            case TOMCAT_70: {
                url = "tomcat70:";
                break;
            }
            case TOMCAT_60: {
                url = "tomcat60:";
                break;
            }
            case TOMCAT_55: {
                url = "tomcat55:";
                break;
            }
            default: {
                url = "tomcat:";
            }
        }
        url = url + "home=" + this.jTextFieldHomeDir.getText();
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            url = url + ":base=" + this.jTextFieldBaseDir.getText();
        }
        Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.FINE, "TomcatInstall.getUrl: " + url);
        return url;
    }

    public String getUsername() {
        return this.jTextFieldUsername.getText();
    }

    public String getPassword() {
        return new String(this.jTextFieldPassword.getPassword());
    }

    boolean createUserEnabled() {
        return this.createUserCheckBox.isSelected();
    }

    public File getHomeDir() {
        return new File(this.jTextFieldHomeDir.getText());
    }

    private File getBaseDir() {
        File[] files;
        File base;
        if (this.jCheckBoxShared.isSelected() && (base = new File(this.jTextFieldBaseDir.getText())).isDirectory() && (files = base.listFiles()) != null && files.length > 0) {
            return base;
        }
        return new File(this.jTextFieldHomeDir.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : "<html>" + this.errorMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
    }

    public boolean isInfoMessage() {
        return this.infoMessage;
    }

    boolean isServerXmlValid(File file) {
        try {
            Server server = Server.createGraph(file);
            this.serverPort = TomcatInstallUtil.getPort(server);
            this.shutdownPort = TomcatInstallUtil.getShutdownPort(server);
            if (this.serverPort != null && this.shutdownPort != null) {
                Integer.parseInt(this.serverPort);
                Integer.parseInt(this.shutdownPort);
                return true;
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, ioe);
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, nfe);
        }
        catch (RuntimeException e) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, e);
        }
        return false;
    }

    private boolean isHomeValid() {
        File serverFile;
        String base;
        File libDir;
        String homeDir = this.jTextFieldHomeDir.getText();
        if (homeDir.length() == 0) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyHomeDir");
            this.infoMessage = true;
            return false;
        }
        if (!new File(homeDir, "bin/bootstrap.jar").exists()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        File file = libDir = TomcatManager.TomcatVersion.TOMCAT_60.equals((Object)this.tomcatVersion) || TomcatManager.TomcatVersion.TOMCAT_70.equals((Object)this.tomcatVersion) ? new File(homeDir, "lib") : new File(homeDir, "common" + File.separator + "lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        boolean serverXmlInBaseDir = false;
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() && (base = this.jTextFieldBaseDir.getText()).length() != 0 && (serverFile = new File(base, SERVER_XML)).exists()) {
            serverXmlInBaseDir = true;
        }
        File serverFile2 = new File(homeDir, SERVER_XML);
        if (!serverXmlInBaseDir && !serverFile2.canRead()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableHomeServerXml");
            return false;
        }
        if (!(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() || this.isServerXmlValid(serverFile2))) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
            return false;
        }
        return true;
    }

    private boolean isJWSDP() {
        File homeDir;
        if (this.isHomeValid() && (homeDir = this.getHomeDir()) != null && homeDir.exists()) {
            File[] files = homeDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "jwsdp-shared".equals(name);
                }
            });
            return files.length != 0;
        }
        return false;
    }

    private boolean isBaseValid() {
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            String base = this.jTextFieldBaseDir.getText();
            if (base.length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyBaseDir");
                this.infoMessage = true;
                return false;
            }
            File baseDir = new File(base);
            String[] files = baseDir.list();
            File serverXml = new File(baseDir, SERVER_XML);
            if (!baseDir.exists() || files == null || files.length > 0 && !serverXml.exists()) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidBaseDir");
                return false;
            }
            if (files.length > 0) {
                if (!serverXml.canRead()) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableBaseServerXml");
                    return false;
                }
                if (!this.isServerXmlValid(serverXml)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedBaseServerXml");
                    return false;
                }
            } else {
                File serverFile = new File(this.jTextFieldHomeDir.getText(), SERVER_XML);
                if (!serverFile.canRead()) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableHomeServerXml");
                    return false;
                }
                if (!this.isServerXmlValid(serverFile)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isUsernamePasswordValid() {
        if (this.createUserCheckBox.isSelected()) {
            if (this.jTextFieldUsername.getText().length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UsernameEmpty");
                this.infoMessage = true;
                return false;
            }
            if (this.jTextFieldPassword.getPassword().length == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_PasswordEmpty");
                this.infoMessage = true;
                return false;
            }
        } else {
            if (this.jTextFieldUsername.getText().length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UsernameEmptyWarning");
                this.infoMessage = true;
            }
            File tomcatUsersXml = new File(this.getBaseDir(), "conf/tomcat-users.xml");
            try {
                if (!TomcatUsers.userExists(tomcatUsersXml, this.jTextFieldUsername.getText())) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UserDoesNotExist");
                } else if (!TomcatUsers.hasManagerRole(tomcatUsersXml, this.jTextFieldUsername.getText())) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UserHasNotManagerRole");
                }
            }
            catch (IOException e) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_MissingOrInvalidTomcatUsersXml", (Object)tomcatUsersXml.getPath());
            }
        }
        return true;
    }

    private boolean isAlreadyRegistered() {
        if (InstanceProperties.getInstanceProperties((String)this.getUrl()) != null) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() ? "MSG_AlreadyRegisteredBase" : "MSG_AlreadyRegisteredHome"));
            return true;
        }
        return false;
    }

    private void setBaseEnabled(boolean enabled) {
        this.jLabelBaseDir.setEnabled(enabled);
        this.jTextFieldBaseDir.setEnabled(enabled);
        this.jButtonBaseBrowse.setEnabled(enabled);
    }

    public boolean hasValidData() {
        this.errorMessage = null;
        this.infoMessage = false;
        return this.isHomeValid() && this.isBaseValid() && !this.isAlreadyRegistered() && this.isUsernamePasswordValid();
    }

    private void fireChange() {
        if (this.validationTask == null) {
            this.validationTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList tempList;
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    ChangeEvent event = new ChangeEvent(this);
                    List list = InstallPanelVisual.this.listeners;
                    synchronized (list) {
                        tempList = new ArrayList(InstallPanelVisual.this.listeners);
                    }
                    Iterator iter = tempList.iterator();
                    while (iter.hasNext()) {
                        ((ChangeListener)iter.next()).stateChanged(event);
                    }
                }
            });
        }
        this.validationTask.schedule(60);
    }
}

