/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.SContext;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;

public class TomcatModuleConfig {
    private static final String CONTEXT_XML_PATH = "/META-INF/context.xml";
    private File contextXml;
    private File serverXml;
    private long timestampContextXML;
    private long timestampServerXML;
    private String path;
    private boolean hasLogger;
    private String loggerClassName;
    private String loggerDir;
    private String loggerPrefix;
    private String loggerSuffix;
    private boolean loggerTimestamp;

    public TomcatModuleConfig(String docBase, String path, String serverXmlPath) {
        this.path = path.equals("/") ? "" : path;
        this.contextXml = new File(docBase + CONTEXT_XML_PATH);
        this.serverXml = new File(serverXmlPath);
        this.refresh();
    }

    private Context getContext() {
        try {
            this.timestampContextXML = this.contextXml.lastModified();
            Context ctx = Context.createGraph(this.contextXml);
            return ctx;
        }
        catch (IOException ioe) {
            Logger.getLogger(TomcatModuleConfig.class.getName()).log(Level.INFO, null, ioe);
            return null;
        }
        catch (RuntimeException e) {
            Logger.getLogger(TomcatModuleConfig.class.getName()).log(Level.INFO, null, e);
            return null;
        }
    }

    private SContext getSContext() {
        try {
            Host[] host;
            Engine engine;
            this.timestampServerXML = this.serverXml.lastModified();
            Server server = Server.createGraph(this.serverXml);
            Service[] service = server.getService();
            if (service.length > 0 && (engine = service[0].getEngine()) != null && (host = engine.getHost()).length > 0) {
                SContext[] sContext = host[0].getSContext();
                for (int i = 0; i < sContext.length; ++i) {
                    if (!sContext[i].getAttributeValue("path").equals(this.path)) continue;
                    return sContext[i];
                }
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(TomcatModuleConfig.class.getName()).log(Level.INFO, null, ioe);
        }
        return null;
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String loggerClassName() {
        return this.loggerClassName;
    }

    public String loggerDir() {
        return this.loggerDir;
    }

    public String loggerPrefix() {
        return this.loggerPrefix;
    }

    public String loggerSuffix() {
        return this.loggerSuffix;
    }

    public boolean loggerTimestamp() {
        return this.loggerTimestamp;
    }

    public void refresh() {
        if (this.contextXml.exists()) {
            long newTimestamp = this.contextXml.lastModified();
            if (newTimestamp > this.timestampContextXML) {
                this.timestampContextXML = newTimestamp;
                Context ctx = this.getContext();
                if (ctx != null) {
                    this.hasLogger = ctx.isLogger();
                    if (this.hasLogger) {
                        this.loggerClassName = ctx.getLoggerClassName();
                        this.loggerDir = ctx.getLoggerDirectory();
                        this.loggerPrefix = ctx.getLoggerPrefix();
                        this.loggerSuffix = ctx.getLoggerSuffix();
                        this.loggerTimestamp = Boolean.valueOf(ctx.getLoggerTimestamp());
                        return;
                    }
                }
            }
        } else if (this.serverXml.exists()) {
            long newTimestamp = this.serverXml.lastModified();
            if (newTimestamp > this.timestampServerXML) {
                this.timestampServerXML = newTimestamp;
                SContext sCtx = this.getSContext();
                if (sCtx != null) {
                    this.hasLogger = sCtx.isLogger();
                    if (this.hasLogger) {
                        this.loggerClassName = sCtx.getAttributeValue("Logger", "className");
                        this.loggerDir = sCtx.getAttributeValue("Logger", "directory");
                        this.loggerPrefix = sCtx.getAttributeValue("Logger", "prefix");
                        this.loggerSuffix = sCtx.getAttributeValue("Logger", "suffix");
                        String timestamp = sCtx.getAttributeValue("Logger", "timestamp");
                        this.loggerTimestamp = Boolean.valueOf(timestamp);
                    }
                }
            }
        } else {
            this.hasLogger = false;
        }
    }
}

