/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

public class FunctionReference
extends SpelNodeImpl {
    private final String name;

    public FunctionReference(String functionName, int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.name = functionName;
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue o = state.lookupVariable(this.name);
        if (o == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_NOT_DEFINED, this.name);
        }
        if (!(o.getValue() instanceof Method)) {
            throw new SpelEvaluationException(SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, this.name, o.getClass());
        }
        try {
            return this.executeFunctionJLRMethod(state, (Method)o.getValue());
        }
        catch (SpelEvaluationException se) {
            se.setPosition(this.getStartPosition());
            throw se;
        }
    }

    private TypedValue executeFunctionJLRMethod(ExpressionState state, Method m) throws EvaluationException {
        Object[] functionArgs = this.getArguments(state);
        if (!m.isVarArgs() && m.getParameterTypes().length != functionArgs.length) {
            throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, functionArgs.length, m.getParameterTypes().length);
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_MUST_BE_STATIC, String.valueOf(m.getDeclaringClass().getName()) + "." + m.getName(), this.name);
        }
        if (functionArgs != null) {
            TypeConverter converter = state.getEvaluationContext().getTypeConverter();
            ReflectionHelper.convertAllArguments(m.getParameterTypes(), m.isVarArgs(), converter, functionArgs);
        }
        if (m.isVarArgs()) {
            functionArgs = ReflectionHelper.setupArgumentsForVarargsInvocation(m.getParameterTypes(), functionArgs);
        }
        try {
            ReflectionUtils.makeAccessible((Method)m);
            Object result = m.invoke(m.getClass(), functionArgs);
            return new TypedValue(result, new TypeDescriptor(new MethodParameter(m, -1)));
        }
        catch (IllegalArgumentException e) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, e.getMessage());
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder("#").append(this.name);
        sb.append("(");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private Object[] getArguments(ExpressionState state) throws EvaluationException {
        Object[] arguments = new Object[this.getChildCount()];
        int i = 0;
        while (i < arguments.length) {
            arguments[i] = this.children[i].getValueInternal(state).getValue();
            ++i;
        }
        return arguments;
    }
}

