/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class PHPCompletionItem
implements CompletionProposal {
    private static final String PHP_KEYWORD_ICON = "org/netbeans/modules/php/editor/resources/php16Key.png";
    protected static ImageIcon keywordIcon = null;
    final CompletionRequest request;
    private final ElementHandle element;
    protected QualifiedNameKind generateAs;
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    PHPCompletionItem(ElementHandle element, CompletionRequest request, QualifiedNameKind generateAs) {
        this.request = request;
        this.element = element;
        keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)PHP_KEYWORD_ICON));
        this.generateAs = generateAs;
    }

    PHPCompletionItem(ElementHandle element, CompletionRequest request) {
        this(element, request, null);
    }

    public int getAnchorOffset() {
        return this.request.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.appendText(this.getName());
        return formatter.getText();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        Set emptyModifiers = Collections.emptySet();
        ElementHandle handle = this.getElement();
        return handle != null ? handle.getModifiers() : emptyModifiers;
    }

    public String getFileNameURL() {
        ElementHandle elem = this.getElement();
        return elem instanceof PhpElement ? ((PhpElement)elem).getFilenameUrl() : "";
    }

    public boolean isSmart() {
        String url = this.getFileNameURL();
        return url != null && url.equals(this.request.currentlyEditedFileURL) || this.element instanceof AliasedElement;
    }

    private static NamespaceDeclaration findEnclosingNamespace(PHPParseResult info, int offset) {
        Program program = info.getProgram();
        List<ASTNode> nodes = NavUtils.underCaret(info, Math.min(program != null ? program.getEndOffset() : offset, offset));
        for (ASTNode node : nodes) {
            if (!(node instanceof NamespaceDeclaration)) continue;
            return (NamespaceDeclaration)node;
        }
        return null;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public String getInsertPrefix() {
        MethodElement method;
        StringBuilder template = new StringBuilder();
        ElementHandle elem = this.getElement();
        if (elem instanceof MethodElement && (method = (MethodElement)elem).isConstructor()) {
            elem = method.getType();
        }
        if (elem instanceof FullyQualifiedElement) {
            PhpLanguageOptions.Properties props;
            FullyQualifiedElement ifq = (FullyQualifiedElement)elem;
            QualifiedName qn = QualifiedName.create(this.request.prefix);
            FileObject fileObject = this.request.result.getSnapshot().getSource().getFileObject();
            PhpLanguageOptions.Properties properties = props = fileObject != null ? PhpLanguageOptions.getDefault().getProperties(fileObject) : null;
            if (props != null && props.getPhpVersion() == PhpLanguageOptions.PhpVersion.PHP_53) {
                if (this.generateAs == null) {
                    CodeCompletionPanel.CodeCompletionType codeCompletionType = OptionsUtils.codeCompletionType();
                    switch (codeCompletionType) {
                        case FULLY_QUALIFIED: {
                            template.append(ifq.getFullyQualifiedName());
                            return template.toString();
                        }
                        case UNQUALIFIED: {
                            template.append(this.getName());
                            return template.toString();
                        }
                        case SMART: {
                            this.generateAs = qn.getKind();
                        }
                    }
                } else if (this.generateAs.isQualified() && ifq instanceof TypeElement && ifq.getNamespaceName().toString().equals("")) {
                    this.generateAs = QualifiedNameKind.FULLYQUALIFIED;
                }
            } else {
                template.append(this.getName());
                return template.toString();
            }
            switch (this.generateAs) {
                case FULLYQUALIFIED: {
                    template.append(ifq.getFullyQualifiedName());
                    break;
                }
                case QUALIFIED: {
                    String fqn = ifq.getFullyQualifiedName().toString();
                    int indexOf = fqn.toLowerCase().indexOf(qn.toNamespaceName().toString().toLowerCase());
                    if (indexOf != -1) {
                        template.append(fqn.substring(indexOf == 0 ? 1 : indexOf));
                        break;
                    }
                }
                case UNQUALIFIED: {
                    boolean isUnqualified;
                    boolean fncFromDefaultNamespace = ifq instanceof FunctionElement && ifq.getIn() == null && "".equals(ifq.getNamespaceName().toString());
                    boolean bl = isUnqualified = ifq.isAliased() && ifq instanceof AliasedElement && ((AliasedElement)ifq).isNameAliased();
                    if (!fncFromDefaultNamespace && !isUnqualified) {
                        Model model = this.request.result.getModel();
                        NamespaceDeclaration namespaceDeclaration = PHPCompletionItem.findEnclosingNamespace(this.request.result, this.request.anchor);
                        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(namespaceDeclaration, model.getFileScope());
                        if (namespaceScope != null) {
                            QualifiedName suffix;
                            LinkedList<String> segments = ifq.getFullyQualifiedName().getSegments();
                            QualifiedName fqna = QualifiedName.create(false, segments);
                            if (!(namespaceScope.isDefaultNamespace() && fqna.getKind().isUnqualified() || (suffix = VariousUtils.getPreferredName(fqna, namespaceScope)) == null)) {
                                template.append(suffix.toString());
                                break;
                            }
                        }
                    }
                    template.append(this.getName());
                }
            }
            return template.toString();
        }
        return this.getName();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        if (this.element instanceof TypeMemberElement) {
            TypeMemberElement classMember = (TypeMemberElement)this.element;
            TypeElement type = classMember.getType();
            QualifiedName qualifiedName = type.getNamespaceName();
            if (qualifiedName.isDefaultNamespace()) {
                formatter.appendText(type.getName());
                return formatter.getText();
            }
            formatter.appendText(type.getFullyQualifiedName().toString());
            return formatter.getText();
        }
        String in = this.element.getIn();
        if (in != null && in.length() > 0) {
            formatter.appendText(this.element.getIn());
            return formatter.getText();
        }
        if (this.element instanceof PhpElement) {
            PhpElement ie = (PhpElement)this.element;
            if (ie.isPlatform()) {
                return NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform");
            }
            String filename = ie.getFilenameUrl();
            if (filename != null) {
                int index = filename.lastIndexOf(47);
                if (index != -1) {
                    filename = filename.substring(index + 1);
                }
                formatter.appendText(filename);
                return formatter.getText();
            }
            if (ie.getFileObject() != null) {
                formatter.appendText(ie.getFileObject().getNameExt());
                return formatter.getText();
            }
        }
        return null;
    }

    public static ImageIcon getInterfaceIcon() {
        return InterfaceItem.icon();
    }

    private static void scheduleShowingCompletion() {
        if (OptionsUtils.autoCompletionTypes()) {
            service.schedule(new Runnable(){

                @Override
                public void run() {
                    Completion.get().showCompletion();
                }
            }, 750L, TimeUnit.MILLISECONDS);
        }
    }

    public static class CompletionRequest {
        public int anchor;
        public PHPParseResult result;
        public ParserResult info;
        public String prefix;
        public String currentlyEditedFileURL;
        public CompletionContextFinder.CompletionContext context;
        ElementQuery.Index index;
    }

    static class TagItem
    extends KeywordItem {
        private int sortKey;

        public TagItem(String tag, int sortKey, CompletionRequest request) {
            super(tag, request);
            this.sortKey = sortKey;
        }

        @Override
        public String getSortText() {
            return "" + this.sortKey + this.getName();
        }
    }

    static class ReturnItem
    extends KeywordItem {
        public ReturnItem(CompletionRequest request) {
            super("return", request);
        }

        @Override
        public String getCustomInsertTemplate() {
            return "return ${cursor};";
        }
    }

    static class SpecialFunctionItem
    extends KeywordItem {
        public SpecialFunctionItem(String fncName, CompletionRequest request) {
            super(fncName, request);
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getName());
            builder.append(" '${cursor}';");
            return builder.toString();
        }
    }

    static class VariableItem
    extends PHPCompletionItem {
        VariableItem(VariableElement variable, CompletionRequest request) {
            super(variable, request);
        }

        VariableElement getVariable() {
            return (VariableElement)this.getElement();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.type(true);
            formatter.appendText(this.getTypeName());
            formatter.type(false);
            formatter.appendText(" ");
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getInsertPrefix() {
            Completion.get().showToolTip();
            return this.getName();
        }

        protected String getTypeName() {
            QualifiedName qualifiedName;
            TypeResolver typeResolver;
            String typeName;
            Set types = this.getVariable().getInstanceTypes();
            String string = types.isEmpty() ? "?" : (typeName = types.size() > 1 ? "mixed" : "?");
            if (types.size() == 1 && (typeResolver = (TypeResolver)types.iterator().next()).isResolved() && (qualifiedName = typeResolver.getTypeName(false)) != null) {
                typeName = qualifiedName.toString();
            }
            return typeName;
        }
    }

    static class InterfaceItem
    extends PHPCompletionItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";
        private static ImageIcon INTERFACE_ICON = null;
        private boolean endWithDoubleColon;

        InterfaceItem(InterfaceElement iface, CompletionRequest request, boolean endWithDoubleColon) {
            super(iface, request);
            this.endWithDoubleColon = endWithDoubleColon;
        }

        InterfaceItem(InterfaceElement iface, CompletionRequest request, QualifiedNameKind generateAs, boolean endWithDoubleColon) {
            super(iface, request, generateAs);
            this.endWithDoubleColon = endWithDoubleColon;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        private static ImageIcon icon() {
            if (INTERFACE_ICON == null) {
                INTERFACE_ICON = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return INTERFACE_ICON;
        }

        @Override
        public ImageIcon getIcon() {
            return InterfaceItem.icon();
        }

        @Override
        public String getInsertPrefix() {
            String insertPrefix = super.getInsertPrefix();
            int indexOf = this.request.prefix != null && insertPrefix != null ? insertPrefix.toLowerCase().indexOf(this.request.prefix.toLowerCase()) : -1;
            return indexOf > 0 ? insertPrefix.substring(indexOf) : insertPrefix;
        }

        @Override
        public String getCustomInsertTemplate() {
            String superTemplate = super.getInsertPrefix();
            if (this.endWithDoubleColon) {
                StringBuilder builder = new StringBuilder();
                if (superTemplate != null) {
                    builder.append(superTemplate);
                } else {
                    builder.append(this.getName());
                }
                builder.append("::${cursor}");
                PHPCompletionItem.scheduleShowingCompletion();
                return builder.toString();
            }
            return superTemplate;
        }
    }

    static class ClassItem
    extends PHPCompletionItem {
        private boolean endWithDoubleColon;

        ClassItem(ClassElement clazz, CompletionRequest request, boolean endWithDoubleColon, QualifiedNameKind generateAs) {
            super(clazz, request, generateAs);
            this.endWithDoubleColon = endWithDoubleColon;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        @Override
        public String getInsertPrefix() {
            String insertPrefix = super.getInsertPrefix();
            int indexOf = this.request.prefix != null && insertPrefix != null ? insertPrefix.toLowerCase().indexOf(this.request.prefix.toLowerCase()) : -1;
            return indexOf > 0 ? insertPrefix.substring(indexOf) : insertPrefix;
        }

        @Override
        public String getCustomInsertTemplate() {
            String superTemplate = super.getInsertPrefix();
            if (this.endWithDoubleColon) {
                StringBuilder builder = new StringBuilder();
                if (superTemplate != null) {
                    builder.append(superTemplate);
                } else {
                    builder.append(this.getName());
                }
                boolean includeDoubleColumn = true;
                if (EditorRegistry.lastFocusedComponent() != null) {
                    Document doc = EditorRegistry.lastFocusedComponent().getDocument();
                    int caret = EditorRegistry.lastFocusedComponent().getCaretPosition();
                    try {
                        if (caret + 2 < doc.getLength() && "::".equals(doc.getText(caret, 2))) {
                            includeDoubleColumn = false;
                        }
                    }
                    catch (BadLocationException ex) {
                        // empty catch block
                    }
                }
                if (includeDoubleColumn) {
                    builder.append("::");
                }
                builder.append("${cursor}");
                PHPCompletionItem.scheduleShowingCompletion();
                return builder.toString();
            }
            if (CompletionContextFinder.CompletionContext.NEW_CLASS.equals((Object)this.request.context)) {
                PHPCompletionItem.scheduleShowingCompletion();
            }
            return superTemplate;
        }
    }

    static class ConstantItem
    extends PHPCompletionItem {
        ConstantItem(ConstantElement constant, CompletionRequest request) {
            super(constant, request);
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            String value = ((ConstantElement)this.getElement()).getValue();
            formatter.name(this.getKind(), true);
            if (this.emphasisName()) {
                formatter.emphasis(true);
                formatter.appendText(this.getName());
                formatter.emphasis(false);
            } else {
                formatter.appendText(this.getName());
            }
            formatter.name(this.getKind(), false);
            formatter.appendText(" ");
            formatter.type(true);
            formatter.appendText(value != null ? value : "?");
            formatter.type(false);
            return formatter.getText();
        }

        protected boolean emphasisName() {
            return true;
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }
    }

    static class NamespaceItem
    extends PHPCompletionItem {
        Boolean isSmart;

        NamespaceItem(NamespaceElement namespace, CompletionRequest request, QualifiedNameKind generateAs) {
            super(namespace, request, generateAs);
        }

        @Override
        public int getSortPrioOverride() {
            return this.isSmart() ? -10001 : super.getSortPrioOverride();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return this.getNamespaceElement().getName();
        }

        NamespaceElement getNamespaceElement() {
            return (NamespaceElement)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            QualifiedName namespaceName = this.getNamespaceElement().getNamespaceName();
            if (namespaceName != null && !namespaceName.isDefaultNamespace()) {
                formatter.appendText(namespaceName.toString());
                return formatter.getText();
            }
            return null;
        }

        @Override
        public boolean isSmart() {
            if (this.isSmart == null && this.getElement() instanceof AliasedElement) {
                this.isSmart = true;
            }
            if (this.isSmart == null) {
                QualifiedName namespaceName = this.getNamespaceElement().getNamespaceName();
                this.isSmart = namespaceName != null && namespaceName.isDefaultNamespace();
                if (!this.isSmart.booleanValue()) {
                    NamespaceScope namespaceScope;
                    FileScope fileScope = this.request.result.getModel().getFileScope();
                    NamespaceScope namespaceScope2 = namespaceScope = fileScope != null ? ModelUtils.getNamespaceScope(fileScope, this.request.anchor) : null;
                    if (namespaceScope != null) {
                        NamespaceElement ifq = this.getNamespaceElement();
                        LinkedList<String> segments = ifq.getFullyQualifiedName().getSegments();
                        QualifiedName fqna = QualifiedName.create(false, segments);
                        Collection<QualifiedName> relativeUses = VariousUtils.getRelativesToUses(namespaceScope, fqna);
                        for (QualifiedName qualifiedName : relativeUses) {
                            if (qualifiedName.getSegments().size() != 1) continue;
                            this.isSmart = true;
                            break;
                        }
                        if (!this.isSmart.booleanValue()) {
                            relativeUses = VariousUtils.getRelativesToNamespace(namespaceScope, fqna);
                            for (QualifiedName qualifiedName : relativeUses) {
                                if (qualifiedName.getSegments().size() != 1) continue;
                                this.isSmart = true;
                                break;
                            }
                        }
                    }
                }
            }
            return this.isSmart;
        }
    }

    static class SuperGlobalItem
    extends PHPCompletionItem {
        private String name;

        public SuperGlobalItem(CompletionRequest request, String name) {
            super(new PredefinedSymbolElement(name), request);
            this.name = name;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.emphasis(true);
            formatter.appendText(this.getName());
            formatter.emphasis(false);
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return "$" + this.name;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            formatter.appendText(NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform"));
            return formatter.getText();
        }

        public String getDocumentation() {
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            return keywordIcon;
        }
    }

    static class KeywordItem
    extends PHPCompletionItem {
        private String description = null;
        String keyword = null;
        private static final List<String> CLS_KEYWORDS = Arrays.asList(PHPCodeCompletion.PHP_CLASS_KEYWORDS);

        KeywordItem(String keyword, CompletionRequest request) {
            super(null, request);
            this.keyword = keyword;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.description != null) {
                formatter.appendHtml(this.description);
                return formatter.getText();
            }
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            return keywordIcon;
        }

        @Override
        public boolean isSmart() {
            return CLS_KEYWORDS.contains(this.getName()) ? true : super.isSmart();
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            CompletionContextFinder.KeywordCompletionType type;
            StringBuilder builder = new StringBuilder();
            if (CLS_KEYWORDS.contains(this.getName())) {
                PHPCompletionItem.scheduleShowingCompletion();
            }
            if ((type = PHPCodeCompletion.PHP_KEYWORDS.get(this.getName())) == null) {
                return this.getName();
            }
            switch (type) {
                case SIMPLE: {
                    return null;
                }
                case ENDS_WITH_SPACE: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    builder.append(this.getName());
                    builder.append(" (${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    builder.append(this.getName());
                    builder.append(" {${cursor}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    builder.append(this.getName());
                    builder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}:");
                    break;
                }
                default: {
                    assert (false) : type.toString();
                    break;
                }
            }
            return builder.toString();
        }
    }

    static class ClassScopeKeywordItem
    extends KeywordItem {
        private final String className;

        ClassScopeKeywordItem(String className, String keyword, CompletionRequest request) {
            super(keyword, request);
            this.className = className;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.keyword.startsWith("$")) {
                if (this.className != null) {
                    formatter.type(true);
                    formatter.appendText(this.className);
                    formatter.type(false);
                }
                formatter.appendText(" ");
            }
            return super.getLhsHtml(formatter);
        }
    }

    public static class MethodDeclarationItem
    extends MethodElementItem {
        public static MethodDeclarationItem getDeclarationItem(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters()));
        }

        public static MethodDeclarationItem forIntroduceHint(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters())){

                @Override
                protected String getFunctionBodyForTemplate() {
                    return "\n";
                }
            };
        }

        public static MethodDeclarationItem forMethodName(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters())){

                @Override
                public String getCustomInsertTemplate() {
                    return super.getNameAndFunctionBodyForTemplate();
                }
            };
        }

        private MethodDeclarationItem(FunctionElementItem functionItem) {
            super(functionItem);
        }

        public MethodElement getMethod() {
            return (MethodElement)this.getBaseFunctionElement();
        }

        @Override
        public boolean isSmart() {
            return !this.isMagic();
        }

        @Override
        protected boolean emphasisName() {
            return this.isMagic() ? false : super.emphasisName();
        }

        public boolean isMagic() {
            return ((MethodElement)this.getBaseFunctionElement()).isMagic();
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            String modifierStr = BodyDeclaration.Modifier.toString(this.getBaseFunctionElement().getFlags());
            if (modifierStr.length() != 0) {
                modifierStr = modifierStr.replace("abstract", "").trim();
                template.append(modifierStr);
            }
            template.append(" ").append("function");
            template.append(this.getNameAndFunctionBodyForTemplate());
            return template.toString();
        }

        protected String getNameAndFunctionBodyForTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(this.getBaseFunctionElement().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration));
            template.append(" ").append("{\n");
            template.append(this.getFunctionBodyForTemplate());
            template.append("}");
            return template.toString();
        }

        protected String getFunctionBodyForTemplate() {
            StringBuilder template = new StringBuilder();
            MethodElement method = (MethodElement)this.getBaseFunctionElement();
            TypeElement type = method.getType();
            if (this.isMagic() || type.isInterface() || method.isAbstract()) {
                template.append("${cursor};\n");
            } else {
                template.append("${cursor}parent::").append(this.getSignature().replace("&$", "$")).append(";\n");
            }
            return template.toString();
        }

        private String getSignature() {
            StringBuilder retval = new StringBuilder();
            retval.append(this.getBaseFunctionElement().getName());
            retval.append("(");
            StringBuilder parametersInfo = new StringBuilder();
            List<ParameterElement> parameters = this.getBaseFunctionElement().getParameters();
            for (ParameterElement parameter : parameters) {
                if (parametersInfo.length() > 0) {
                    parametersInfo.append(", ");
                }
                parametersInfo.append(parameter.getName());
            }
            retval.append((CharSequence)parametersInfo);
            retval.append(")");
            return retval.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getLhsHtml(formatter));
            sb.append(' ').append(NbBundle.getMessage(PHPCompletionItem.class, (String)"Generate"));
            return sb.toString();
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.isMagic()) {
                String message = NbBundle.getMessage(PHPCompletionItem.class, (String)"MagicMethod");
                formatter.appendText(message);
                return formatter.getText();
            }
            return super.getRhsHtml(formatter);
        }
    }

    static class TypeConstantItem
    extends PHPCompletionItem {
        public static TypeConstantItem getItem(TypeConstantElement constant, CompletionRequest request) {
            return new TypeConstantItem(constant, request);
        }

        private TypeConstantItem(TypeConstantElement constant, CompletionRequest request) {
            super(constant, request);
        }

        TypeConstantElement getConstant() {
            return (TypeConstantElement)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            formatter.appendText(" ");
            String value = this.getConstant().getValue();
            formatter.type(true);
            formatter.appendText(value != null ? value : "?");
            formatter.type(false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return this.getConstant().getName();
        }

        @Override
        public String getInsertPrefix() {
            Completion.get().showToolTip();
            return this.getName();
        }
    }

    static class FieldItem
    extends BasicFieldItem {
        public static FieldItem getItem(FieldElement field, CompletionRequest request) {
            return new FieldItem(field, request);
        }

        private FieldItem(FieldElement field, CompletionRequest request) {
            super(field, null, request);
        }

        FieldElement getField() {
            return (FieldElement)this.getElement();
        }

        @Override
        public String getName() {
            FieldElement field = this.getField();
            return field.getName(field.isStatic());
        }

        @Override
        protected String getTypeName() {
            QualifiedName qualifiedName;
            TypeResolver typeResolver;
            String typeName;
            Set<TypeResolver> types = this.getField().getInstanceTypes();
            String string = types.isEmpty() ? "?" : (typeName = types.size() > 1 ? "mixed" : "?");
            if (types.size() == 1 && (typeResolver = types.iterator().next()).isResolved() && (qualifiedName = typeResolver.getTypeName(false)) != null) {
                typeName = qualifiedName.toString();
            }
            return typeName;
        }
    }

    static class BasicFieldItem
    extends PHPCompletionItem {
        private String typeName;

        public static BasicFieldItem getItem(PhpElement field, String type, CompletionRequest request) {
            return new BasicFieldItem(field, type, request);
        }

        private BasicFieldItem(PhpElement field, String typeName, CompletionRequest request) {
            super(field, request);
            this.typeName = typeName;
        }

        @Override
        public String getInsertPrefix() {
            Completion.get().showToolTip();
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.type(true);
            formatter.appendText(this.getTypeName());
            formatter.type(false);
            formatter.appendText(" ");
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            String name = this.getElement().getName();
            return name.startsWith("$") ? name.substring(1) : name;
        }

        protected String getTypeName() {
            return this.typeName;
        }
    }

    static class FunctionElementItem
    extends PHPCompletionItem {
        private List<ParameterElement> parameters;

        static List<FunctionElementItem> getItems(BaseFunctionElement function, CompletionRequest request) {
            ArrayList<FunctionElementItem> retval = new ArrayList<FunctionElementItem>();
            ArrayList<ParameterElement> parameters = new ArrayList<ParameterElement>();
            for (ParameterElement param : function.getParameters()) {
                if (!param.isMandatory()) {
                    if (retval.isEmpty()) {
                        retval.add(new FunctionElementItem(function, request, parameters));
                    }
                    parameters.add(param);
                    retval.add(new FunctionElementItem(function, request, parameters));
                    continue;
                }
                parameters.add(param);
            }
            if (retval.isEmpty()) {
                retval.add(new FunctionElementItem(function, request, parameters));
            }
            return retval;
        }

        FunctionElementItem(BaseFunctionElement function, CompletionRequest request, List<ParameterElement> parameters) {
            super(function, request);
            this.parameters = new ArrayList<ParameterElement>(parameters);
        }

        public BaseFunctionElement getBaseFunctionElement() {
            return (BaseFunctionElement)this.getElement();
        }

        public ElementKind getKind() {
            return this.getBaseFunctionElement().getPhpElementKind().getElementKind();
        }

        @Override
        public String getInsertPrefix() {
            String insertPrefix = super.getInsertPrefix();
            int indexOf = this.request.prefix != null && insertPrefix != null ? insertPrefix.toLowerCase().indexOf(this.request.prefix.toLowerCase()) : -1;
            return indexOf > 0 ? insertPrefix.substring(indexOf) : insertPrefix;
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            String superTemplate = super.getInsertPrefix();
            if (superTemplate != null) {
                template.append(superTemplate);
            } else {
                template.append(this.getName());
            }
            template.append("(");
            List<String> params = this.getInsertParams();
            for (int i = 0; i < params.size(); ++i) {
                String param = params.get(i);
                if (param.startsWith("&")) {
                    param = param.substring(1);
                }
                template.append(String.format("${php-cc-%d  default=\"%s\"}", i, param));
                if (i >= params.size() - 1) continue;
                template.append(", ");
            }
            template.append(')');
            return template.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            ElementKind kind = this.getKind();
            formatter.name(kind, true);
            if (this.emphasisName()) {
                formatter.emphasis(true);
                formatter.appendText(this.getName());
                formatter.emphasis(false);
            } else {
                formatter.appendText(this.getName());
            }
            formatter.name(kind, false);
            formatter.appendHtml("(");
            formatter.parameters(true);
            this.appendParamsStr(formatter);
            formatter.parameters(false);
            formatter.appendHtml(")");
            return formatter.getText();
        }

        protected boolean emphasisName() {
            return true;
        }

        public List<String> getInsertParams() {
            LinkedList<String> insertParams = new LinkedList<String>();
            for (ParameterElement parameter : this.parameters) {
                insertParams.add(parameter.getName());
            }
            return insertParams;
        }

        @Override
        public String getSortText() {
            return this.getName() + this.parameters.size();
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            List<ParameterElement> allParameters = this.parameters;
            for (int i = 0; i < allParameters.size(); ++i) {
                ParameterElement parameter = allParameters.get(i);
                String paramName = parameter.getName();
                if (paramName.startsWith("&")) {
                    paramName = paramName.substring(1);
                }
                if (i != 0) {
                    formatter.appendText(", ");
                }
                String paramTpl = parameter.asString(true);
                if (!parameter.isMandatory()) {
                    formatter.appendText(paramTpl);
                    continue;
                }
                formatter.emphasis(true);
                formatter.appendText(paramTpl);
                formatter.emphasis(false);
            }
        }
    }

    public static class MethodElementItem
    extends FunctionElementItem {
        static List<MethodElementItem> getItems(MethodElement methodElement, CompletionRequest request) {
            ArrayList<MethodElementItem> retval = new ArrayList<MethodElementItem>();
            List<FunctionElementItem> items = FunctionElementItem.getItems(methodElement, request);
            for (FunctionElementItem functionElementItem : items) {
                retval.add(new MethodElementItem(functionElementItem));
            }
            return retval;
        }

        MethodElementItem(FunctionElementItem function) {
            super(function.getBaseFunctionElement(), function.request, function.parameters);
        }
    }

    static class NewClassItem
    extends MethodElementItem {
        static List<NewClassItem> getNewClassItems(MethodElement methodElement, CompletionRequest request) {
            ArrayList<NewClassItem> retval = new ArrayList<NewClassItem>();
            List<FunctionElementItem> items = FunctionElementItem.getItems(methodElement, request);
            for (FunctionElementItem functionElementItem : items) {
                retval.add(new NewClassItem(functionElementItem));
            }
            return retval;
        }

        private NewClassItem(FunctionElementItem function) {
            super(function);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            String namespaceName;
            if (this.getElement().getIn() != null && (namespaceName = ((MethodElement)this.getElement()).getType().getNamespaceName().toString()) != null && !"".equals(namespaceName)) {
                formatter.appendText(namespaceName);
                return formatter.getText();
            }
            return super.getRhsHtml(formatter);
        }

        @Override
        public String getName() {
            String in = this.getElement().getIn();
            return in != null ? in : super.getName();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        @Override
        public boolean isSmart() {
            return this.getElement() instanceof AliasedElement ? true : super.isSmart();
        }
    }
}

